/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    public static final String EMOJIS_FIELD = "emojis";
    public static final String MASKPOSITION_FIELD = "mask_position";
    private Integer userId;
    private String name;
    private String emojis;
    private MaskPosition maskPosition;
    private Boolean isNewPngSticker;
    private String pngSticker;
    private File pngStickerFile;
    private InputStream pngStickerStream;
    private String pngStickerName;

    public AddStickerToSet() {
    }

    public AddStickerToSet(Integer userId, String name, String emojis) {
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.emojis = (String)Preconditions.checkNotNull((Object)emojis);
    }

    public Integer getUserId() {
        return this.userId;
    }

    public AddStickerToSet setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public String getPngSticker() {
        return this.pngSticker;
    }

    public AddStickerToSet setPngSticker(String pngSticker) {
        this.pngSticker = pngSticker;
        this.isNewPngSticker = false;
        return this;
    }

    public File getPngStickerFile() {
        return this.pngStickerFile;
    }

    public AddStickerToSet setPngStickerFile(File pngStickerFile) {
        Objects.requireNonNull(pngStickerFile, "pngStickerFile cannot be null!");
        this.pngStickerFile = pngStickerFile;
        this.isNewPngSticker = true;
        return this;
    }

    public InputStream getPngStickerStream() {
        return this.pngStickerStream;
    }

    public AddStickerToSet setPngStickerStream(String pngStickerName, InputStream pngStickerStream) {
        Objects.requireNonNull(pngStickerName, "pngStickerName cannot be null!");
        Objects.requireNonNull(pngStickerStream, "pngStickerStream cannot be null!");
        this.pngStickerStream = pngStickerStream;
        this.pngStickerName = pngStickerName;
        this.isNewPngSticker = true;
        return this;
    }

    public String getPngStickerName() {
        return this.pngStickerName;
    }

    public Boolean isNewPngSticker() {
        return this.isNewPngSticker;
    }

    public String getName() {
        return this.name;
    }

    public AddStickerToSet setName(String name) {
        this.name = name;
        return this;
    }

    public String getEmojis() {
        return this.emojis;
    }

    public AddStickerToSet setEmojis(String emojis) {
        this.emojis = emojis;
        return this;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public AddStickerToSet setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
        return this;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error creating new sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.emojis == null || this.emojis.isEmpty()) {
            throw new TelegramApiValidationException("emojis can't be empty", this);
        }
        if (this.isNewPngSticker.booleanValue()) {
            if (this.pngStickerFile == null && this.pngStickerStream == null) {
                throw new TelegramApiValidationException("PngSticker can't be empty", this);
            }
            if (this.pngStickerStream != null && (this.pngStickerName == null || this.pngStickerName.isEmpty())) {
                throw new TelegramApiValidationException("PngSticker name can't be empty", this);
            }
        } else if (this.pngSticker == null) {
            throw new TelegramApiValidationException("PngSticker can't be empty", this);
        }
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
    }

    public String toString() {
        return "AddStickerToSet{userId=" + this.userId + ", name='" + this.name + '\'' + ", emojis='" + this.emojis + '\'' + ", maskPosition=" + this.maskPosition + ", isNewPngSticker=" + this.isNewPngSticker + ", pngSticker='" + this.pngSticker + '\'' + ", pngStickerFile=" + this.pngStickerFile + ", pngStickerStream=" + this.pngStickerStream + ", pngStickerName='" + this.pngStickerName + '\'' + '}';
    }
}

