/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta;

import java.text.MessageFormat;
import org.telegram.telegrambots.meta.ApiContext;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.Webhook;
import org.telegram.telegrambots.meta.generics.WebhookBot;

public class TelegramBotsApi {
    private static final String webhookUrlFormat = "{0}callback/";
    private boolean useWebhook;
    private Webhook webhook;
    private String extrenalUrl;
    private String pathToCertificate;

    public TelegramBotsApi() {
    }

    public TelegramBotsApi(String externalUrl, String internalUrl) throws TelegramApiRequestException {
        if (externalUrl == null || externalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter externalUrl can not be null or empty");
        }
        if (internalUrl == null || internalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter internalUrl can not be null or empty");
        }
        this.useWebhook = true;
        this.extrenalUrl = TelegramBotsApi.fixExternalUrl(externalUrl);
        this.webhook = ApiContext.getInstance(Webhook.class);
        this.webhook.setInternalUrl(internalUrl);
        this.webhook.startServer();
    }

    public TelegramBotsApi(String keyStore, String keyStorePassword, String externalUrl, String internalUrl) throws TelegramApiRequestException {
        if (externalUrl == null || externalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter externalUrl can not be null or empty");
        }
        if (internalUrl == null || internalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter internalUrl can not be null or empty");
        }
        if (keyStore == null || keyStore.isEmpty()) {
            throw new TelegramApiRequestException("Parameter keyStore can not be null or empty");
        }
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            throw new TelegramApiRequestException("Parameter keyStorePassword can not be null or empty");
        }
        this.useWebhook = true;
        this.extrenalUrl = TelegramBotsApi.fixExternalUrl(externalUrl);
        this.webhook = ApiContext.getInstance(Webhook.class);
        this.webhook.setInternalUrl(internalUrl);
        this.webhook.setKeyStore(keyStore, keyStorePassword);
        this.webhook.startServer();
    }

    public TelegramBotsApi(String keyStore, String keyStorePassword, String externalUrl, String internalUrl, String pathToCertificate) throws TelegramApiRequestException {
        if (externalUrl == null || externalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter externalUrl can not be null or empty");
        }
        if (internalUrl == null || internalUrl.isEmpty()) {
            throw new TelegramApiRequestException("Parameter internalUrl can not be null or empty");
        }
        if (keyStore == null || keyStore.isEmpty()) {
            throw new TelegramApiRequestException("Parameter keyStore can not be null or empty");
        }
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            throw new TelegramApiRequestException("Parameter keyStorePassword can not be null or empty");
        }
        if (pathToCertificate == null || pathToCertificate.isEmpty()) {
            throw new TelegramApiRequestException("Parameter pathToCertificate can not be null or empty");
        }
        this.useWebhook = true;
        this.extrenalUrl = TelegramBotsApi.fixExternalUrl(externalUrl);
        this.pathToCertificate = pathToCertificate;
        this.webhook = ApiContext.getInstance(Webhook.class);
        this.webhook.setInternalUrl(internalUrl);
        this.webhook.setKeyStore(keyStore, keyStorePassword);
        this.webhook.startServer();
    }

    public BotSession registerBot(LongPollingBot bot) throws TelegramApiRequestException {
        bot.clearWebhook();
        BotSession session = ApiContext.getInstance(BotSession.class);
        session.setToken(bot.getBotToken());
        session.setOptions(bot.getOptions());
        session.setCallback(bot);
        session.start();
        return session;
    }

    public void registerBot(WebhookBot bot) throws TelegramApiRequestException {
        if (this.useWebhook) {
            this.webhook.registerWebhook(bot);
            bot.setWebhook(this.extrenalUrl + bot.getBotPath(), this.pathToCertificate);
        }
    }

    private static String fixExternalUrl(String externalUrl) {
        if (externalUrl != null && !externalUrl.endsWith("/")) {
            externalUrl = externalUrl + "/";
        }
        return MessageFormat.format(webhookUrlFormat, externalUrl);
    }
}

