/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.logging;

import java.time.LocalDateTime;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class FileFormatter
extends Formatter {
    FileFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        LocalDateTime currentDate = LocalDateTime.now();
        String dateForLog = FileFormatter.dateFormatterForLogs(currentDate);
        String result = record.getThrown() == null ? FileFormatter.logMsgToFile(record.getLevel(), record.getMessage(), dateForLog) : FileFormatter.logThrowableToFile(record.getLevel(), record.getMessage(), record.getThrown(), dateForLog);
        return result;
    }

    private static String dateFormatterForLogs(LocalDateTime dateTime) {
        String dateString = "[";
        dateString = dateString + dateTime.getDayOfMonth() + "_";
        dateString = dateString + dateTime.getMonthValue() + "_";
        dateString = dateString + dateTime.getYear() + "_";
        dateString = dateString + dateTime.getHour() + ":";
        dateString = dateString + dateTime.getMinute() + ":";
        dateString = dateString + dateTime.getSecond();
        dateString = dateString + "] ";
        return dateString;
    }

    private static String logMsgToFile(Level level, String msg, String dateForLog) {
        return String.format("%s{%s} %s\n", dateForLog, level.toString(), msg);
    }

    private static String logThrowableToFile(Level level, String message, Throwable throwable, String dateForLog) {
        String throwableLog = String.format("%s{%s} %s - %s\n", dateForLog, level.toString(), message, throwable.toString());
        for (StackTraceElement element : throwable.getStackTrace()) {
            throwableLog = throwableLog + "\tat " + element + "\n";
        }
        return throwableLog;
    }
}

