/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.commands.BotCommand;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetMyCommands
extends BotApiMethod<Boolean> {
    public static final String PATH = "setMyCommands";
    private static final String COMMANDS_FIELD = "commands";
    @JsonProperty(value="commands")
    private List<BotCommand> commands;

    public SetMyCommands() {
    }

    public SetMyCommands(List<BotCommand> commands) {
        this.commands = (List)Preconditions.checkNotNull(commands);
    }

    public List<BotCommand> getCommands() {
        return this.commands;
    }

    public SetMyCommands setCommands(List<BotCommand> commands) {
        this.commands = (List)Preconditions.checkNotNull(commands);
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending commands", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.commands == null) {
            throw new TelegramApiValidationException("Commands parameter can't be empty", this);
        }
        if (this.commands.size() > 100) {
            throw new TelegramApiValidationException("No more than 100 commands are allowed", this);
        }
        for (BotCommand command : this.commands) {
            command.validate();
        }
    }

    public String toString() {
        return "SetMyCommands{commands=" + this.commands + '}';
    }
}

