/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class ExportChatInviteLink
extends BotApiMethod<String> {
    public static final String PATH = "exportChatInviteLink";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    private String chatId;

    public ExportChatInviteLink() {
    }

    public ExportChatInviteLink(String chatId) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
    }

    public ExportChatInviteLink(Long chatId) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
    }

    public String getChatId() {
        return this.chatId;
    }

    public ExportChatInviteLink setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public ExportChatInviteLink setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public String deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<String>>(){});
            if (result.getOk().booleanValue()) {
                return (String)result.getResult();
            }
            throw new TelegramApiRequestException("Error exporting invite link", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
    }

    public String toString() {
        return "ExportChatInviteLink{chatId='" + this.chatId + '\'' + '}';
    }
}

