/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class PromoteChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "promoteChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String CANCHANGEINFORMATION_FIELD = "can_change_info";
    private static final String CANPOSTMESSAGES_FIELD = "can_post_messages";
    private static final String CANEDITMESSAGES_FIELD = "can_edit_messages";
    private static final String CANDELETEMESSAGES_FIELD = "can_delete_messages";
    private static final String CANINVITEUSERS_FIELD = "can_invite_users";
    private static final String CANRESTRICTMEMBERS_FIELD = "can_restrict_members";
    private static final String CANPINMESSAGES_FIELD = "can_pin_messages";
    private static final String CANPROMOTEMEMBERS_FIELD = "can_promote_members";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="user_id")
    private Integer userId;
    @JsonProperty(value="can_change_info")
    private Boolean canChangeInformation;
    @JsonProperty(value="can_post_messages")
    private Boolean canPostMessages;
    @JsonProperty(value="can_edit_messages")
    private Boolean canEditMessages;
    @JsonProperty(value="can_delete_messages")
    private Boolean canDeleteMessages;
    @JsonProperty(value="can_invite_users")
    private Boolean canInviteUsers;
    @JsonProperty(value="can_restrict_members")
    private Boolean canRestrictMembers;
    @JsonProperty(value="can_pin_messages")
    private Boolean canPinMessages;
    @JsonProperty(value="can_promote_members")
    private Boolean canPromoteMembers;

    public PromoteChatMember() {
    }

    public PromoteChatMember(String chatId, Integer userId) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
    }

    public PromoteChatMember(Long chatId, Integer userId) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public PromoteChatMember setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public PromoteChatMember setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public PromoteChatMember setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Boolean getCanChangeInformation() {
        return this.canChangeInformation;
    }

    public PromoteChatMember setCanChangeInformation(Boolean canChangeInformation) {
        this.canChangeInformation = canChangeInformation;
        return this;
    }

    public Boolean getCanPostMessages() {
        return this.canPostMessages;
    }

    public PromoteChatMember setCanPostMessages(Boolean canPostMessages) {
        this.canPostMessages = canPostMessages;
        return this;
    }

    public Boolean getCanEditMessages() {
        return this.canEditMessages;
    }

    public PromoteChatMember setCanEditMessages(Boolean canEditMessages) {
        this.canEditMessages = canEditMessages;
        return this;
    }

    public Boolean getCanDeleteMessages() {
        return this.canDeleteMessages;
    }

    public PromoteChatMember setCanDeleteMessages(Boolean canDeleteMessages) {
        this.canDeleteMessages = canDeleteMessages;
        return this;
    }

    public Boolean getCanInviteUsers() {
        return this.canInviteUsers;
    }

    public PromoteChatMember setCanInviteUsers(Boolean canInviteUsers) {
        this.canInviteUsers = canInviteUsers;
        return this;
    }

    public Boolean getCanRestrictMembers() {
        return this.canRestrictMembers;
    }

    public PromoteChatMember setCanRestrictMembers(Boolean canRestrictMembers) {
        this.canRestrictMembers = canRestrictMembers;
        return this;
    }

    public Boolean getCanPinMessages() {
        return this.canPinMessages;
    }

    public PromoteChatMember setCanPinMessages(Boolean canPinMessages) {
        this.canPinMessages = canPinMessages;
        return this;
    }

    public Boolean getCanPromoteMembers() {
        return this.canPromoteMembers;
    }

    public PromoteChatMember setCanPromoteMembers(Boolean canPromoteMembers) {
        this.canPromoteMembers = canPromoteMembers;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error promoting chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be null", this);
        }
    }

    public String toString() {
        return "PromoteChatMember{chatId='" + this.chatId + '\'' + ", userId=" + this.userId + ", canChangeInformation=" + this.canChangeInformation + ", canPostMessages=" + this.canPostMessages + ", canEditMessages=" + this.canEditMessages + ", canDeleteMessages=" + this.canDeleteMessages + ", canInviteUsers=" + this.canInviteUsers + ", canRestrictMembers=" + this.canRestrictMembers + ", canPinMessages=" + this.canPinMessages + ", canPromoteMembers=" + this.canPromoteMembers + '}';
    }
}

