/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.polls.Poll;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class StopPoll
extends BotApiMethod<Poll> {
    public static final String PATH = "stopPoll";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;

    public StopPoll() {
    }

    public StopPoll(String chatId, Integer messageId) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.messageId = (Integer)Preconditions.checkNotNull((Object)messageId);
    }

    public StopPoll(Long chatId, Integer messageId) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.messageId = (Integer)Preconditions.checkNotNull((Object)messageId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public StopPoll setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public StopPoll setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public StopPoll setMessageId(Integer messageId) {
        this.messageId = messageId;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Poll deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Poll>>(){});
            if (result.getOk().booleanValue()) {
                return (Poll)result.getResult();
            }
            throw new TelegramApiRequestException("Error stopping poll", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == null || this.messageId == 0) {
            throw new TelegramApiValidationException("Message Id parameter can't be empty", this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StopPoll)) {
            return false;
        }
        StopPoll sendMessage = (StopPoll)o;
        return Objects.equals(this.chatId, sendMessage.chatId) && Objects.equals(this.messageId, sendMessage.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.chatId, this.messageId);
    }

    public String toString() {
        return "StopPoll{chatId='" + this.chatId + '\'' + ", messageId=" + this.messageId + '}';
    }
}

