/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.User;

public class ChatMember
implements BotApiObject {
    private static final String USER_FIELD = "user";
    private static final String STATUS_FIELD = "status";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String CANBEEDITED_FIELD = "can_be_edited";
    private static final String CANCHANGEINFORMATION_FIELD = "can_change_information";
    private static final String CANPOSTMESSAGES_FIELD = "can_post_messages";
    private static final String CANEDITMESSAGES_FIELD = "can_edit_messages";
    private static final String CANDELETEMESSAGES_FIELD = "can_delete_messages";
    private static final String CANINVITEUSERS_FIELD = "can_invite_users";
    private static final String CANRESTRICTMEMBERS_FIELD = "can_restrict_members";
    private static final String CANPINMESSAGES_FIELD = "can_pin_messages";
    private static final String CANPROMOTEMEMBERS_FIELD = "can_promote_members";
    private static final String CANSENDMESSAGES_FIELD = "can_send_messages";
    private static final String CANSENDMEDIAMESSAGES_FIELD = "can_send_media_messages";
    private static final String CANSENDOTHERMESSAGES_FIELD = "can_send_other_messages";
    private static final String CANADDWEBPAGEPREVIEWS_FIELD = "can_add_web_page_previews";
    private static final String CAN_SEND_POLLS_FIELD = "can_send_polls";
    private static final String ISMEMBER_FIELD = "is_member";
    private static final String CUSTOMTITLE_FIELD = "custom_title";
    @JsonProperty(value="user")
    private User user;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="can_be_edited")
    private Boolean canBeEdited;
    @JsonProperty(value="can_change_information")
    private Boolean canChangeInformation;
    @JsonProperty(value="can_post_messages")
    private Boolean canPostMessages;
    @JsonProperty(value="can_edit_messages")
    private Boolean canEditMessages;
    @JsonProperty(value="can_delete_messages")
    private Boolean canDeleteMessages;
    @JsonProperty(value="can_invite_users")
    private Boolean canInviteUsers;
    @JsonProperty(value="can_restrict_members")
    private Boolean canRestrictMembers;
    @JsonProperty(value="can_pin_messages")
    private Boolean canPinMessages;
    @JsonProperty(value="can_promote_members")
    private Boolean canPromoteMembers;
    @JsonProperty(value="can_send_messages")
    private Boolean canSendMessages;
    @JsonProperty(value="can_send_media_messages")
    private Boolean canSendMediaMessages;
    @JsonProperty(value="can_send_other_messages")
    private Boolean canSendOtherMessages;
    @JsonProperty(value="can_add_web_page_previews")
    private Boolean canAddWebPagePreviews;
    @JsonProperty(value="can_send_polls")
    private Boolean canSendPolls;
    @JsonProperty(value="is_member")
    private Boolean isMemberField;
    @JsonProperty(value="custom_title")
    private String customTitle;

    public User getUser() {
        return this.user;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    public Instant getUntilDateAsInstant() {
        if (this.untilDate == null) {
            return null;
        }
        return Instant.ofEpochSecond(this.untilDate.intValue());
    }

    public Boolean getCanBeEdited() {
        return this.canBeEdited;
    }

    public Boolean getCanChangeInformation() {
        return this.canChangeInformation;
    }

    public Boolean getCanPostMessages() {
        return this.canPostMessages;
    }

    public Boolean getCanEditMessages() {
        return this.canEditMessages;
    }

    public Boolean getCanDeleteMessages() {
        return this.canDeleteMessages;
    }

    public Boolean getCanInviteUsers() {
        return this.canInviteUsers;
    }

    public Boolean getCanRestrictMembers() {
        return this.canRestrictMembers;
    }

    @Deprecated
    public Boolean getCanRestrictUsers() {
        return this.canRestrictMembers;
    }

    public Boolean getCanPinMessages() {
        return this.canPinMessages;
    }

    public Boolean getCanPromoteMembers() {
        return this.canPromoteMembers;
    }

    public Boolean getCanSendMessages() {
        return this.canSendMessages;
    }

    public Boolean getCanSendMediaMessages() {
        return this.canSendMediaMessages;
    }

    public Boolean getCanSendOtherMessages() {
        return this.canSendOtherMessages;
    }

    public Boolean getCanAddWebPagePreviews() {
        return this.canAddWebPagePreviews;
    }

    public Boolean getCanSendPolls() {
        return this.canSendPolls;
    }

    public Boolean getMemberField() {
        return this.isMemberField;
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public String toString() {
        return "ChatMember{user=" + this.user + ", status='" + this.status + '\'' + ", untilDate=" + this.untilDate + ", canBeEdited=" + this.canBeEdited + ", canChangeInformation=" + this.canChangeInformation + ", canPostMessages=" + this.canPostMessages + ", canEditMessages=" + this.canEditMessages + ", canDeleteMessages=" + this.canDeleteMessages + ", canInviteUsers=" + this.canInviteUsers + ", canRestrictMembers=" + this.canRestrictMembers + ", canPinMessages=" + this.canPinMessages + ", canPromoteMembers=" + this.canPromoteMembers + ", canSendMessages=" + this.canSendMessages + ", canSendMediaMessages=" + this.canSendMediaMessages + ", canSendOtherMessages=" + this.canSendOtherMessages + ", canAddWebPagePreviews=" + this.canAddWebPagePreviews + ", canSendPolls=" + this.canSendPolls + ", isMemberField=" + this.isMemberField + ", customTitle=" + this.customTitle + '}';
    }
}

