/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.InputStream;
import org.telegram.telegrambots.meta.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.InputFileSerializer;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonSerialize(using=InputFileSerializer.class, as=String.class)
public class InputFile
implements InputBotApiObject,
Validable {
    private String attachName;
    @JsonIgnore
    private String mediaName;
    @JsonIgnore
    private File newMediaFile;
    @JsonIgnore
    private InputStream newMediaStream;
    @JsonIgnore
    private boolean isNew;

    public InputFile() {
    }

    public InputFile(String attachName) {
        this();
        this.setMedia(attachName);
    }

    public InputFile(File mediaFile, String fileName) {
        this();
        this.setMedia(mediaFile, fileName);
    }

    public InputFile(InputStream mediaStream, String fileName) {
        this();
        this.setMedia(mediaStream, fileName);
    }

    public InputFile setMedia(File mediaFile, String fileName) {
        this.newMediaFile = mediaFile;
        this.mediaName = fileName;
        this.attachName = "attach://" + fileName;
        this.isNew = true;
        return this;
    }

    public InputFile setMedia(InputStream mediaStream, String fileName) {
        this.newMediaStream = mediaStream;
        this.mediaName = fileName;
        this.attachName = "attach://" + fileName;
        this.isNew = true;
        return this;
    }

    public InputFile setMedia(String attachName) {
        this.attachName = attachName;
        this.isNew = false;
        return this;
    }

    public String getAttachName() {
        return this.attachName;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public File getNewMediaFile() {
        return this.newMediaFile;
    }

    public InputStream getNewMediaStream() {
        return this.newMediaStream;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.isNew) {
            if (this.mediaName == null || this.mediaName.isEmpty()) {
                throw new TelegramApiValidationException("Media name can't be empty", this);
            }
            if (this.newMediaFile == null && this.newMediaStream == null) {
                throw new TelegramApiValidationException("Media can't be empty", this);
            }
        } else if (this.attachName == null || this.attachName.isEmpty()) {
            throw new TelegramApiValidationException("File_id can't be empty", this);
        }
    }
}

