/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultGif
implements InlineQueryResult {
    private static final List<String> VALIDTHUMBTYPES = Collections.unmodifiableList(Arrays.asList("image/jpeg", "image/gif", "video/mp4"));
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String GIFURL_FIELD = "gif_url";
    private static final String GIFWIDTH_FIELD = "gif_width";
    private static final String GIFHEIGHT_FIELD = "gif_height";
    private static final String THUMBURL_FIELD = "thumb_url";
    private static final String THUMBMIMETYPE_FIELD = "thumb_mime_type";
    private static final String TITLE_FIELD = "title";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String GIF_DURATION_FIELD = "gif_duration";
    private static final String PARSEMODE_FIELD = "parse_mode";
    @JsonProperty(value="type")
    private final String type = "gif";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="gif_url")
    private String gifUrl;
    @JsonProperty(value="gif_width")
    private Integer gifWidth;
    @JsonProperty(value="gif_height")
    private Integer gifHeight;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_mime_type")
    private String thumbUrlType;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="gif_duration")
    private Integer gifDuration;
    @JsonProperty(value="parse_mode")
    private String parseMode;

    public String getType() {
        return "gif";
    }

    public String getId() {
        return this.id;
    }

    public InlineQueryResultGif setId(String id) {
        this.id = id;
        return this;
    }

    public String getGifUrl() {
        return this.gifUrl;
    }

    public InlineQueryResultGif setGifUrl(String gifUrl) {
        this.gifUrl = gifUrl;
        return this;
    }

    public Integer getGifWidth() {
        return this.gifWidth;
    }

    public InlineQueryResultGif setGifWidth(Integer gifWidth) {
        this.gifWidth = gifWidth;
        return this;
    }

    public Integer getGifHeight() {
        return this.gifHeight;
    }

    public InlineQueryResultGif setGifHeight(Integer gifHeight) {
        this.gifHeight = gifHeight;
        return this;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public InlineQueryResultGif setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
        return this;
    }

    public String getThumbUrlType() {
        return this.thumbUrlType;
    }

    public InlineQueryResultGif setThumbUrlType(String thumbUrlType) {
        this.thumbUrlType = thumbUrlType;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public InlineQueryResultGif setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineQueryResultGif setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineQueryResultGif setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
        return this;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InlineQueryResultGif setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Integer getGifDuration() {
        return this.gifDuration;
    }

    public InlineQueryResultGif setGifDuration(Integer gifDuration) {
        this.gifDuration = gifDuration;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InlineQueryResultGif setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.gifUrl == null || this.gifUrl.isEmpty()) {
            throw new TelegramApiValidationException("GifUrl parameter can't be empty", this);
        }
        if (this.thumbUrlType != null && !VALIDTHUMBTYPES.contains(this.thumbUrlType)) {
            throw new TelegramApiValidationException("ThumbUrlType parameter must be one of \u201cimage/jpeg\u201d, \u201cimage/gif\u201d, or \u201cvideo/mp4\u201d", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "InlineQueryResultGif{type='gif', id='" + this.id + '\'' + ", gifUrl='" + this.gifUrl + '\'' + ", gifWidth=" + this.gifWidth + ", gifHeight=" + this.gifHeight + ", thumbUrl='" + this.thumbUrl + '\'' + ", thumbUrlType='" + this.thumbUrlType + '\'' + ", title='" + this.title + '\'' + ", caption='" + this.caption + '\'' + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", gifDuration=" + this.gifDuration + ", parseMode='" + this.parseMode + '\'' + '}';
    }
}

