/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonPollType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class KeyboardButton
implements Validable,
BotApiObject {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    private static final String REQUEST_POLL_FIELD = "request_poll";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;
    @JsonProperty(value="request_poll")
    private KeyboardButtonPollType requestPoll;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.requestContact != null && this.requestLocation != null && this.requestContact.booleanValue() && this.requestLocation.booleanValue()) {
            throw new TelegramApiValidationException("Cant request contact and location at the same time", this);
        }
        if (this.requestContact != null && this.requestPoll != null && this.requestContact.booleanValue()) {
            throw new TelegramApiValidationException("Cant request contact and poll at the same time", this);
        }
        if (this.requestLocation != null && this.requestPoll != null && this.requestLocation.booleanValue()) {
            throw new TelegramApiValidationException("Cant request location and poll at the same time", this);
        }
    }

    public static KeyboardButtonBuilder builder() {
        return new KeyboardButtonBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButton)) {
            return false;
        }
        KeyboardButton other = (KeyboardButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requestContact = this.getRequestContact();
        Boolean other$requestContact = other.getRequestContact();
        if (this$requestContact == null ? other$requestContact != null : !((Object)this$requestContact).equals(other$requestContact)) {
            return false;
        }
        Boolean this$requestLocation = this.getRequestLocation();
        Boolean other$requestLocation = other.getRequestLocation();
        if (this$requestLocation == null ? other$requestLocation != null : !((Object)this$requestLocation).equals(other$requestLocation)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        KeyboardButtonPollType this$requestPoll = this.getRequestPoll();
        KeyboardButtonPollType other$requestPoll = other.getRequestPoll();
        return !(this$requestPoll == null ? other$requestPoll != null : !((Object)this$requestPoll).equals(other$requestPoll));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requestContact = this.getRequestContact();
        result = result * 59 + ($requestContact == null ? 43 : ((Object)$requestContact).hashCode());
        Boolean $requestLocation = this.getRequestLocation();
        result = result * 59 + ($requestLocation == null ? 43 : ((Object)$requestLocation).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        KeyboardButtonPollType $requestPoll = this.getRequestPoll();
        result = result * 59 + ($requestPoll == null ? 43 : ((Object)$requestPoll).hashCode());
        return result;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public Boolean getRequestContact() {
        return this.requestContact;
    }

    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    public KeyboardButtonPollType getRequestPoll() {
        return this.requestPoll;
    }

    @JsonProperty(value="text")
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="request_contact")
    public void setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
    }

    @JsonProperty(value="request_location")
    public void setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
    }

    @JsonProperty(value="request_poll")
    public void setRequestPoll(KeyboardButtonPollType requestPoll) {
        this.requestPoll = requestPoll;
    }

    public String toString() {
        return "KeyboardButton(text=" + this.getText() + ", requestContact=" + this.getRequestContact() + ", requestLocation=" + this.getRequestLocation() + ", requestPoll=" + this.getRequestPoll() + ")";
    }

    public KeyboardButton() {
    }

    public KeyboardButton(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    public KeyboardButton(@NonNull String text, Boolean requestContact, Boolean requestLocation, KeyboardButtonPollType requestPoll) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.requestContact = requestContact;
        this.requestLocation = requestLocation;
        this.requestPoll = requestPoll;
    }

    public static class KeyboardButtonBuilder {
        private String text;
        private Boolean requestContact;
        private Boolean requestLocation;
        private KeyboardButtonPollType requestPoll;

        KeyboardButtonBuilder() {
        }

        @JsonProperty(value="text")
        public KeyboardButtonBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        @JsonProperty(value="request_contact")
        public KeyboardButtonBuilder requestContact(Boolean requestContact) {
            this.requestContact = requestContact;
            return this;
        }

        @JsonProperty(value="request_location")
        public KeyboardButtonBuilder requestLocation(Boolean requestLocation) {
            this.requestLocation = requestLocation;
            return this;
        }

        @JsonProperty(value="request_poll")
        public KeyboardButtonBuilder requestPoll(KeyboardButtonPollType requestPoll) {
            this.requestPoll = requestPoll;
            return this;
        }

        public KeyboardButton build() {
            return new KeyboardButton(this.text, this.requestContact, this.requestLocation, this.requestPoll);
        }

        public String toString() {
            return "KeyboardButton.KeyboardButtonBuilder(text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + ", requestPoll=" + this.requestPoll + ")";
        }
    }
}

