/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatStickerSet
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatStickerSet";
    private static final String CHATID_FIELD = "chat_id";
    private static final String STICKERSETNAME_FIELD = "sticker_set_name";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="sticker_set_name")
    @NonNull
    private String stickerSetName;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.stickerSetName == null || this.stickerSetName.isEmpty()) {
            throw new TelegramApiValidationException("StickerSetName can't be empty", this);
        }
    }

    public static SetChatStickerSetBuilder builder() {
        return new SetChatStickerSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatStickerSet)) {
            return false;
        }
        SetChatStickerSet other = (SetChatStickerSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$stickerSetName = this.getStickerSetName();
        String other$stickerSetName = other.getStickerSetName();
        return !(this$stickerSetName == null ? other$stickerSetName != null : !this$stickerSetName.equals(other$stickerSetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatStickerSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $stickerSetName = this.getStickerSetName();
        result = result * 59 + ($stickerSetName == null ? 43 : $stickerSetName.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getStickerSetName() {
        return this.stickerSetName;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="sticker_set_name")
    public void setStickerSetName(@NonNull String stickerSetName) {
        if (stickerSetName == null) {
            throw new NullPointerException("stickerSetName is marked non-null but is null");
        }
        this.stickerSetName = stickerSetName;
    }

    public String toString() {
        return "SetChatStickerSet(chatId=" + this.getChatId() + ", stickerSetName=" + this.getStickerSetName() + ")";
    }

    public SetChatStickerSet() {
    }

    public SetChatStickerSet(@NonNull String chatId, @NonNull String stickerSetName) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (stickerSetName == null) {
            throw new NullPointerException("stickerSetName is marked non-null but is null");
        }
        this.chatId = chatId;
        this.stickerSetName = stickerSetName;
    }

    public static class SetChatStickerSetBuilder {
        private String chatId;
        private String stickerSetName;

        SetChatStickerSetBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetChatStickerSetBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="sticker_set_name")
        public SetChatStickerSetBuilder stickerSetName(@NonNull String stickerSetName) {
            if (stickerSetName == null) {
                throw new NullPointerException("stickerSetName is marked non-null but is null");
            }
            this.stickerSetName = stickerSetName;
            return this;
        }

        public SetChatStickerSet build() {
            return new SetChatStickerSet(this.chatId, this.stickerSetName);
        }

        public String toString() {
            return "SetChatStickerSet.SetChatStickerSetBuilder(chatId=" + this.chatId + ", stickerSetName=" + this.stickerSetName + ")";
        }
    }
}

