/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendVenue
extends BotApiMethod<Message> {
    public static final String PATH = "sendVenue";
    private static final String CHATID_FIELD = "chat_id";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String TITLE_FIELD = "title";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String ADDRESS_FIELD = "address";
    private static final String FOURSQUAREID_FIELD = "foursquare_id";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String FOURSQUARETYPE_FIELD = "foursquare_type";
    private static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    private static final String GOOGLEPLACEID_FIELD = "google_place_id";
    private static final String GOOGLEPLACETYPE_FIELD = "google_place_type";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="latitude")
    @NonNull
    private Double latitude;
    @JsonProperty(value="longitude")
    @NonNull
    private Double longitude;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="address")
    @NonNull
    private String address;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="foursquare_id")
    private String foursquareId;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="foursquare_type")
    private String foursquareType;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="google_place_id")
    private String googlePlaceId;
    @JsonProperty(value="google_place_type")
    private String googlePlaceType;

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending venue", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.longitude == null) {
            throw new TelegramApiValidationException("Longitude parameter can't be empty", this);
        }
        if (this.latitude == null) {
            throw new TelegramApiValidationException("Latitude parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.address == null) {
            throw new TelegramApiValidationException("Address parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static SendVenueBuilder builder() {
        return new SendVenueBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendVenue)) {
            return false;
        }
        SendVenue other = (SendVenue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$foursquareId = this.getFoursquareId();
        String other$foursquareId = other.getFoursquareId();
        if (this$foursquareId == null ? other$foursquareId != null : !this$foursquareId.equals(other$foursquareId)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$foursquareType = this.getFoursquareType();
        String other$foursquareType = other.getFoursquareType();
        if (this$foursquareType == null ? other$foursquareType != null : !this$foursquareType.equals(other$foursquareType)) {
            return false;
        }
        String this$googlePlaceId = this.getGooglePlaceId();
        String other$googlePlaceId = other.getGooglePlaceId();
        if (this$googlePlaceId == null ? other$googlePlaceId != null : !this$googlePlaceId.equals(other$googlePlaceId)) {
            return false;
        }
        String this$googlePlaceType = this.getGooglePlaceType();
        String other$googlePlaceType = other.getGooglePlaceType();
        return !(this$googlePlaceType == null ? other$googlePlaceType != null : !this$googlePlaceType.equals(other$googlePlaceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendVenue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $foursquareId = this.getFoursquareId();
        result = result * 59 + ($foursquareId == null ? 43 : $foursquareId.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $foursquareType = this.getFoursquareType();
        result = result * 59 + ($foursquareType == null ? 43 : $foursquareType.hashCode());
        String $googlePlaceId = this.getGooglePlaceId();
        result = result * 59 + ($googlePlaceId == null ? 43 : $googlePlaceId.hashCode());
        String $googlePlaceType = this.getGooglePlaceType();
        result = result * 59 + ($googlePlaceType == null ? 43 : $googlePlaceType.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public Double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getFoursquareType() {
        return this.foursquareType;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public String getGooglePlaceId() {
        return this.googlePlaceId;
    }

    public String getGooglePlaceType() {
        return this.googlePlaceType;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(@NonNull Double latitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(@NonNull Double longitude) {
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        this.longitude = longitude;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="address")
    public void setAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="foursquare_id")
    public void setFoursquareId(String foursquareId) {
        this.foursquareId = foursquareId;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="foursquare_type")
    public void setFoursquareType(String foursquareType) {
        this.foursquareType = foursquareType;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="google_place_id")
    public void setGooglePlaceId(String googlePlaceId) {
        this.googlePlaceId = googlePlaceId;
    }

    @JsonProperty(value="google_place_type")
    public void setGooglePlaceType(String googlePlaceType) {
        this.googlePlaceType = googlePlaceType;
    }

    public String toString() {
        return "SendVenue(chatId=" + this.getChatId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", disableNotification=" + this.getDisableNotification() + ", foursquareId=" + this.getFoursquareId() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", foursquareType=" + this.getFoursquareType() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", googlePlaceId=" + this.getGooglePlaceId() + ", googlePlaceType=" + this.getGooglePlaceType() + ")";
    }

    public SendVenue(@NonNull String chatId, @NonNull Double latitude, @NonNull Double longitude, @NonNull String title, @NonNull String address) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.chatId = chatId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
    }

    public SendVenue() {
    }

    public SendVenue(@NonNull String chatId, @NonNull Double latitude, @NonNull Double longitude, @NonNull String title, @NonNull String address, Boolean disableNotification, String foursquareId, Integer replyToMessageId, ReplyKeyboard replyMarkup, String foursquareType, Boolean allowSendingWithoutReply, String googlePlaceId, String googlePlaceType) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (latitude == null) {
            throw new NullPointerException("latitude is marked non-null but is null");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.chatId = chatId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
        this.disableNotification = disableNotification;
        this.foursquareId = foursquareId;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.foursquareType = foursquareType;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.googlePlaceId = googlePlaceId;
        this.googlePlaceType = googlePlaceType;
    }

    public static class SendVenueBuilder {
        private String chatId;
        private Double latitude;
        private Double longitude;
        private String title;
        private String address;
        private Boolean disableNotification;
        private String foursquareId;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private String foursquareType;
        private Boolean allowSendingWithoutReply;
        private String googlePlaceId;
        private String googlePlaceType;

        SendVenueBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SendVenueBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="latitude")
        public SendVenueBuilder latitude(@NonNull Double latitude) {
            if (latitude == null) {
                throw new NullPointerException("latitude is marked non-null but is null");
            }
            this.latitude = latitude;
            return this;
        }

        @JsonProperty(value="longitude")
        public SendVenueBuilder longitude(@NonNull Double longitude) {
            if (longitude == null) {
                throw new NullPointerException("longitude is marked non-null but is null");
            }
            this.longitude = longitude;
            return this;
        }

        @JsonProperty(value="title")
        public SendVenueBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="address")
        public SendVenueBuilder address(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this;
        }

        @JsonProperty(value="disable_notification")
        public SendVenueBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="foursquare_id")
        public SendVenueBuilder foursquareId(String foursquareId) {
            this.foursquareId = foursquareId;
            return this;
        }

        @JsonProperty(value="reply_to_message_id")
        public SendVenueBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public SendVenueBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="foursquare_type")
        public SendVenueBuilder foursquareType(String foursquareType) {
            this.foursquareType = foursquareType;
            return this;
        }

        @JsonProperty(value="allow_sending_without_reply")
        public SendVenueBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        @JsonProperty(value="google_place_id")
        public SendVenueBuilder googlePlaceId(String googlePlaceId) {
            this.googlePlaceId = googlePlaceId;
            return this;
        }

        @JsonProperty(value="google_place_type")
        public SendVenueBuilder googlePlaceType(String googlePlaceType) {
            this.googlePlaceType = googlePlaceType;
            return this;
        }

        public SendVenue build() {
            return new SendVenue(this.chatId, this.latitude, this.longitude, this.title, this.address, this.disableNotification, this.foursquareId, this.replyToMessageId, this.replyMarkup, this.foursquareType, this.allowSendingWithoutReply, this.googlePlaceId, this.googlePlaceType);
        }

        public String toString() {
            return "SendVenue.SendVenueBuilder(chatId=" + this.chatId + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", disableNotification=" + this.disableNotification + ", foursquareId=" + this.foursquareId + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", foursquareType=" + this.foursquareType + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", googlePlaceId=" + this.googlePlaceId + ", googlePlaceType=" + this.googlePlaceType + ")";
        }
    }
}

