/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerCallbackQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answercallbackquery";
    private static final String CALLBACKQUERYID_FIELD = "callback_query_id";
    private static final String TEXT_FIELD = "text";
    private static final String SHOWALERT_FIELD = "show_alert";
    private static final String URL_FIELD = "url";
    private static final String CACHETIME_FIELD = "cache_time";
    @JsonProperty(value="callback_query_id")
    @NonNull
    private String callbackQueryId;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="show_alert")
    private Boolean showAlert;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="cache_time")
    private Integer cacheTime;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error answering callback query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.callbackQueryId == null) {
            throw new TelegramApiValidationException("CallbackQueryId can't be null", this);
        }
    }

    public static AnswerCallbackQueryBuilder builder() {
        return new AnswerCallbackQueryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerCallbackQuery)) {
            return false;
        }
        AnswerCallbackQuery other = (AnswerCallbackQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showAlert = this.getShowAlert();
        Boolean other$showAlert = other.getShowAlert();
        if (this$showAlert == null ? other$showAlert != null : !((Object)this$showAlert).equals(other$showAlert)) {
            return false;
        }
        Integer this$cacheTime = this.getCacheTime();
        Integer other$cacheTime = other.getCacheTime();
        if (this$cacheTime == null ? other$cacheTime != null : !((Object)this$cacheTime).equals(other$cacheTime)) {
            return false;
        }
        String this$callbackQueryId = this.getCallbackQueryId();
        String other$callbackQueryId = other.getCallbackQueryId();
        if (this$callbackQueryId == null ? other$callbackQueryId != null : !this$callbackQueryId.equals(other$callbackQueryId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerCallbackQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showAlert = this.getShowAlert();
        result = result * 59 + ($showAlert == null ? 43 : ((Object)$showAlert).hashCode());
        Integer $cacheTime = this.getCacheTime();
        result = result * 59 + ($cacheTime == null ? 43 : ((Object)$cacheTime).hashCode());
        String $callbackQueryId = this.getCallbackQueryId();
        result = result * 59 + ($callbackQueryId == null ? 43 : $callbackQueryId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @NonNull
    public String getCallbackQueryId() {
        return this.callbackQueryId;
    }

    public String getText() {
        return this.text;
    }

    public Boolean getShowAlert() {
        return this.showAlert;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    @JsonProperty(value="callback_query_id")
    public void setCallbackQueryId(@NonNull String callbackQueryId) {
        if (callbackQueryId == null) {
            throw new NullPointerException("callbackQueryId is marked non-null but is null");
        }
        this.callbackQueryId = callbackQueryId;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="show_alert")
    public void setShowAlert(Boolean showAlert) {
        this.showAlert = showAlert;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="cache_time")
    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    public String toString() {
        return "AnswerCallbackQuery(callbackQueryId=" + this.getCallbackQueryId() + ", text=" + this.getText() + ", showAlert=" + this.getShowAlert() + ", url=" + this.getUrl() + ", cacheTime=" + this.getCacheTime() + ")";
    }

    public AnswerCallbackQuery() {
    }

    public AnswerCallbackQuery(@NonNull String callbackQueryId) {
        if (callbackQueryId == null) {
            throw new NullPointerException("callbackQueryId is marked non-null but is null");
        }
        this.callbackQueryId = callbackQueryId;
    }

    public AnswerCallbackQuery(@NonNull String callbackQueryId, String text, Boolean showAlert, String url, Integer cacheTime) {
        if (callbackQueryId == null) {
            throw new NullPointerException("callbackQueryId is marked non-null but is null");
        }
        this.callbackQueryId = callbackQueryId;
        this.text = text;
        this.showAlert = showAlert;
        this.url = url;
        this.cacheTime = cacheTime;
    }

    public static class AnswerCallbackQueryBuilder {
        private String callbackQueryId;
        private String text;
        private Boolean showAlert;
        private String url;
        private Integer cacheTime;

        AnswerCallbackQueryBuilder() {
        }

        @JsonProperty(value="callback_query_id")
        public AnswerCallbackQueryBuilder callbackQueryId(@NonNull String callbackQueryId) {
            if (callbackQueryId == null) {
                throw new NullPointerException("callbackQueryId is marked non-null but is null");
            }
            this.callbackQueryId = callbackQueryId;
            return this;
        }

        @JsonProperty(value="text")
        public AnswerCallbackQueryBuilder text(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="show_alert")
        public AnswerCallbackQueryBuilder showAlert(Boolean showAlert) {
            this.showAlert = showAlert;
            return this;
        }

        @JsonProperty(value="url")
        public AnswerCallbackQueryBuilder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="cache_time")
        public AnswerCallbackQueryBuilder cacheTime(Integer cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        public AnswerCallbackQuery build() {
            return new AnswerCallbackQuery(this.callbackQueryId, this.text, this.showAlert, this.url, this.cacheTime);
        }

        public String toString() {
            return "AnswerCallbackQuery.AnswerCallbackQueryBuilder(callbackQueryId=" + this.callbackQueryId + ", text=" + this.text + ", showAlert=" + this.showAlert + ", url=" + this.url + ", cacheTime=" + this.cacheTime + ")";
        }
    }
}

