/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class BanChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "banChatMember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String REVOKEMESSAGES_FIELD = "revoke_messages";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="revoke_messages")
    private Boolean revokeMessages;

    @JsonIgnore
    public void setUntilDateInstant(Instant instant) {
        this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public void setUntilDateDateTime(ZonedDateTime date) {
        this.setUntilDateInstant(date.toInstant());
    }

    @JsonIgnore
    public void forTimePeriodDuration(Duration duration) {
        this.setUntilDateInstant(Instant.now().plusMillis(duration.toMillis()));
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error kicking chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null || this.userId == 0L) {
            throw new TelegramApiValidationException("UserId can't be null or 0", this);
        }
    }

    public static BanChatMemberBuilder builder() {
        return new BanChatMemberBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BanChatMember)) {
            return false;
        }
        BanChatMember other = (BanChatMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$untilDate = this.getUntilDate();
        Integer other$untilDate = other.getUntilDate();
        if (this$untilDate == null ? other$untilDate != null : !((Object)this$untilDate).equals(other$untilDate)) {
            return false;
        }
        Boolean this$revokeMessages = this.getRevokeMessages();
        Boolean other$revokeMessages = other.getRevokeMessages();
        if (this$revokeMessages == null ? other$revokeMessages != null : !((Object)this$revokeMessages).equals(other$revokeMessages)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BanChatMember;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $untilDate = this.getUntilDate();
        result = result * 59 + ($untilDate == null ? 43 : ((Object)$untilDate).hashCode());
        Boolean $revokeMessages = this.getRevokeMessages();
        result = result * 59 + ($revokeMessages == null ? 43 : ((Object)$revokeMessages).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    public Boolean getRevokeMessages() {
        return this.revokeMessages;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="until_date")
    public void setUntilDate(Integer untilDate) {
        this.untilDate = untilDate;
    }

    @JsonProperty(value="revoke_messages")
    public void setRevokeMessages(Boolean revokeMessages) {
        this.revokeMessages = revokeMessages;
    }

    public String toString() {
        return "BanChatMember(chatId=" + this.getChatId() + ", userId=" + this.getUserId() + ", untilDate=" + this.getUntilDate() + ", revokeMessages=" + this.getRevokeMessages() + ")";
    }

    public BanChatMember() {
    }

    public BanChatMember(@NonNull String chatId, @NonNull Long userId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
    }

    public BanChatMember(@NonNull String chatId, @NonNull Long userId, Integer untilDate, Boolean revokeMessages) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.userId = userId;
        this.untilDate = untilDate;
        this.revokeMessages = revokeMessages;
    }

    public static class BanChatMemberBuilder {
        private String chatId;
        private Long userId;
        private Integer untilDate;
        private Boolean revokeMessages;

        BanChatMemberBuilder() {
        }

        @JsonProperty(value="chat_id")
        public BanChatMemberBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="user_id")
        public BanChatMemberBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="until_date")
        public BanChatMemberBuilder untilDate(Integer untilDate) {
            this.untilDate = untilDate;
            return this;
        }

        @JsonProperty(value="revoke_messages")
        public BanChatMemberBuilder revokeMessages(Boolean revokeMessages) {
            this.revokeMessages = revokeMessages;
            return this;
        }

        public BanChatMember build() {
            return new BanChatMember(this.chatId, this.userId, this.untilDate, this.revokeMessages);
        }

        public String toString() {
            return "BanChatMember.BanChatMemberBuilder(chatId=" + this.chatId + ", userId=" + this.userId + ", untilDate=" + this.untilDate + ", revokeMessages=" + this.revokeMessages + ")";
        }
    }
}

