/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatPermissions;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatPermissions
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatPermissions";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String PERMISSIONS_FIELD = "permissions";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="permissions")
    @NonNull
    private ChatPermissions permissions;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat description", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.permissions == null) {
            throw new TelegramApiValidationException("Permissions can't be null", this);
        }
    }

    public static SetChatPermissionsBuilder builder() {
        return new SetChatPermissionsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatPermissions)) {
            return false;
        }
        SetChatPermissions other = (SetChatPermissions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        ChatPermissions this$permissions = this.getPermissions();
        ChatPermissions other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatPermissions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        ChatPermissions $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public ChatPermissions getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(@NonNull ChatPermissions permissions) {
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.permissions = permissions;
    }

    public String toString() {
        return "SetChatPermissions(chatId=" + this.getChatId() + ", permissions=" + this.getPermissions() + ")";
    }

    public SetChatPermissions() {
    }

    public SetChatPermissions(@NonNull String chatId, @NonNull ChatPermissions permissions) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (permissions == null) {
            throw new NullPointerException("permissions is marked non-null but is null");
        }
        this.chatId = chatId;
        this.permissions = permissions;
    }

    public static class SetChatPermissionsBuilder {
        private String chatId;
        private ChatPermissions permissions;

        SetChatPermissionsBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetChatPermissionsBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="permissions")
        public SetChatPermissionsBuilder permissions(@NonNull ChatPermissions permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions is marked non-null but is null");
            }
            this.permissions = permissions;
            return this;
        }

        public SetChatPermissions build() {
            return new SetChatPermissions(this.chatId, this.permissions);
        }

        public String toString() {
            return "SetChatPermissions.SetChatPermissionsBuilder(chatId=" + this.chatId + ", permissions=" + this.permissions + ")";
        }
    }
}

