/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.Audio;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.api.objects.Contact;
import org.telegram.telegrambots.meta.api.objects.Dice;
import org.telegram.telegrambots.meta.api.objects.Document;
import org.telegram.telegrambots.meta.api.objects.Location;
import org.telegram.telegrambots.meta.api.objects.MessageAutoDeleteTimerChanged;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.PhotoSize;
import org.telegram.telegrambots.meta.api.objects.ProximityAlertTriggered;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.Venue;
import org.telegram.telegrambots.meta.api.objects.Video;
import org.telegram.telegrambots.meta.api.objects.VideoNote;
import org.telegram.telegrambots.meta.api.objects.Voice;
import org.telegram.telegrambots.meta.api.objects.games.Animation;
import org.telegram.telegrambots.meta.api.objects.games.Game;
import org.telegram.telegrambots.meta.api.objects.passport.PassportData;
import org.telegram.telegrambots.meta.api.objects.payments.Invoice;
import org.telegram.telegrambots.meta.api.objects.payments.SuccessfulPayment;
import org.telegram.telegrambots.meta.api.objects.polls.Poll;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.stickers.Sticker;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatEnded;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatParticipantsInvited;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatScheduled;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatStarted;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppData;

public class Message
implements BotApiObject {
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String FROM_FIELD = "from";
    private static final String DATE_FIELD = "date";
    private static final String CHAT_FIELD = "chat";
    private static final String FORWARDFROM_FIELD = "forward_from";
    private static final String FORWARDFROMCHAT_FIELD = "forward_from_chat";
    private static final String FORWARDDATE_FIELD = "forward_date";
    private static final String TEXT_FIELD = "text";
    private static final String ENTITIES_FIELD = "entities";
    private static final String CAPTIONENTITIES_FIELD = "caption_entities";
    private static final String AUDIO_FIELD = "audio";
    private static final String DOCUMENT_FIELD = "document";
    private static final String PHOTO_FIELD = "photo";
    private static final String STICKER_FIELD = "sticker";
    private static final String VIDEO_FIELD = "video";
    private static final String CONTACT_FIELD = "contact";
    private static final String LOCATION_FIELD = "location";
    private static final String VENUE_FIELD = "venue";
    private static final String ANIMATION_FIELD = "animation";
    private static final String PINNED_MESSAGE_FIELD = "pinned_message";
    private static final String NEWCHATMEMBERS_FIELD = "new_chat_members";
    private static final String LEFTCHATMEMBER_FIELD = "left_chat_member";
    private static final String NEWCHATTITLE_FIELD = "new_chat_title";
    private static final String NEWCHATPHOTO_FIELD = "new_chat_photo";
    private static final String DELETECHATPHOTO_FIELD = "delete_chat_photo";
    private static final String GROUPCHATCREATED_FIELD = "group_chat_created";
    private static final String REPLYTOMESSAGE_FIELD = "reply_to_message";
    private static final String VOICE_FIELD = "voice";
    private static final String CAPTION_FIELD = "caption";
    private static final String SUPERGROUPCREATED_FIELD = "supergroup_chat_created";
    private static final String CHANNELCHATCREATED_FIELD = "channel_chat_created";
    private static final String MIGRATETOCHAT_FIELD = "migrate_to_chat_id";
    private static final String MIGRATEFROMCHAT_FIELD = "migrate_from_chat_id";
    private static final String EDITDATE_FIELD = "edit_date";
    private static final String GAME_FIELD = "game";
    private static final String FORWARDFROMMESSAGEID_FIELD = "forward_from_message_id";
    private static final String INVOICE_FIELD = "invoice";
    private static final String SUCCESSFUL_PAYMENT_FIELD = "successful_payment";
    private static final String VIDEO_NOTE_FIELD = "video_note";
    private static final String AUTHORSIGNATURE_FIELD = "author_signature";
    private static final String FORWARDSIGNATURE_FIELD = "forward_signature";
    private static final String MEDIAGROUPID_FIELD = "media_group_id";
    private static final String CONNECTEDWEBSITE_FIELD = "connected_website";
    private static final String PASSPORTDATA_FIELD = "passport_data";
    private static final String FORWARDSENDERNAME_FIELD = "forward_sender_name";
    private static final String POLL_FIELD = "poll";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String DICE_FIELD = "dice";
    private static final String VIABOT_FIELD = "via_bot";
    private static final String SENDERCHAT_FIELD = "sender_chat";
    private static final String PROXIMITYALERTTRIGGERED_FIELD = "proximity_alert_triggered";
    private static final String MESSAGEAUTODELETETIMERCHANGED_FIELD = "message_auto_delete_timer_changed";
    private static final String ISAUTOMATICFORWARD_FIELD = "is_automatic_forward";
    private static final String HASPROTECTEDCONTENT_FIELD = "has_protected_content";
    private static final String WEBAPPDATA_FIELD = "web_app_data";
    private static final String VIDEOCHATSCHEDULED_FIELD = "video_chat_scheduled";
    private static final String VIDEOCHATSTARTED_FIELD = "video_chat_started";
    private static final String VIDEOCHATENDED_FIELD = "video_chat_ended";
    private static final String VIDEOCHATPARTICIPANTSINVITED_FIELD = "video_chat_participants_invited";
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="date")
    private Integer date;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="forward_from")
    private User forwardFrom;
    @JsonProperty(value="forward_from_chat")
    private Chat forwardFromChat;
    @JsonProperty(value="forward_date")
    private Integer forwardDate;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="audio")
    private Audio audio;
    @JsonProperty(value="document")
    private Document document;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="sticker")
    private Sticker sticker;
    @JsonProperty(value="video")
    private Video video;
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="venue")
    private Venue venue;
    @JsonProperty(value="animation")
    private Animation animation;
    @JsonProperty(value="pinned_message")
    private Message pinnedMessage;
    @JsonProperty(value="new_chat_members")
    private List<User> newChatMembers;
    @JsonProperty(value="left_chat_member")
    private User leftChatMember;
    @JsonProperty(value="new_chat_title")
    private String newChatTitle;
    @JsonProperty(value="new_chat_photo")
    private List<PhotoSize> newChatPhoto;
    @JsonProperty(value="delete_chat_photo")
    private Boolean deleteChatPhoto;
    @JsonProperty(value="group_chat_created")
    private Boolean groupchatCreated;
    @JsonProperty(value="reply_to_message")
    private Message replyToMessage;
    @JsonProperty(value="voice")
    private Voice voice;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="supergroup_chat_created")
    private Boolean superGroupCreated;
    @JsonProperty(value="channel_chat_created")
    private Boolean channelChatCreated;
    @JsonProperty(value="migrate_to_chat_id")
    private Long migrateToChatId;
    @JsonProperty(value="migrate_from_chat_id")
    private Long migrateFromChatId;
    @JsonProperty(value="edit_date")
    private Integer editDate;
    @JsonProperty(value="game")
    private Game game;
    @JsonProperty(value="forward_from_message_id")
    private Integer forwardFromMessageId;
    @JsonProperty(value="invoice")
    private Invoice invoice;
    @JsonProperty(value="successful_payment")
    private SuccessfulPayment successfulPayment;
    @JsonProperty(value="video_note")
    private VideoNote videoNote;
    @JsonProperty(value="author_signature")
    private String authorSignature;
    @JsonProperty(value="forward_signature")
    private String forwardSignature;
    @JsonProperty(value="media_group_id")
    private String mediaGroupId;
    @JsonProperty(value="connected_website")
    private String connectedWebsite;
    @JsonProperty(value="passport_data")
    private PassportData passportData;
    @JsonProperty(value="forward_sender_name")
    private String forwardSenderName;
    @JsonProperty(value="poll")
    private Poll poll;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="dice")
    private Dice dice;
    @JsonProperty(value="via_bot")
    private User viaBot;
    @JsonProperty(value="sender_chat")
    private Chat senderChat;
    @JsonProperty(value="proximity_alert_triggered")
    private ProximityAlertTriggered proximityAlertTriggered;
    @JsonProperty(value="message_auto_delete_timer_changed")
    private MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged;
    @JsonProperty(value="is_automatic_forward")
    private Boolean isAutomaticForward;
    @JsonProperty(value="has_protected_content")
    private Boolean hasProtectedContent;
    @JsonProperty(value="web_app_data")
    private WebAppData webAppData;
    @JsonProperty(value="video_chat_started")
    private VideoChatStarted videoChatStarted;
    @JsonProperty(value="video_chat_ended")
    private VideoChatEnded videoChatEnded;
    @JsonProperty(value="video_chat_participants_invited")
    private VideoChatParticipantsInvited videoChatParticipantsInvited;
    @JsonProperty(value="video_chat_scheduled")
    private VideoChatScheduled videoChatScheduled;

    public List<MessageEntity> getEntities() {
        if (this.entities != null) {
            this.entities.forEach(x -> x.computeText(this.text));
        }
        return this.entities;
    }

    public List<MessageEntity> getCaptionEntities() {
        if (this.captionEntities != null) {
            this.captionEntities.forEach(x -> x.computeText(this.caption));
        }
        return this.captionEntities;
    }

    @JsonIgnore
    public List<User> getNewChatMembers() {
        return this.newChatMembers == null ? new ArrayList() : this.newChatMembers;
    }

    @JsonIgnore
    public boolean hasSticker() {
        return this.sticker != null;
    }

    @JsonIgnore
    public boolean isGroupMessage() {
        return this.chat.isGroupChat();
    }

    @JsonIgnore
    public boolean isUserMessage() {
        return this.chat.isUserChat();
    }

    @JsonIgnore
    public boolean isChannelMessage() {
        return this.chat.isChannelChat();
    }

    @JsonIgnore
    public boolean isSuperGroupMessage() {
        return this.chat.isSuperGroupChat();
    }

    @JsonIgnore
    public Long getChatId() {
        return this.chat.getId();
    }

    @JsonIgnore
    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    @JsonIgnore
    public boolean isCommand() {
        if (this.hasText() && this.entities != null) {
            for (MessageEntity entity : this.entities) {
                if (entity == null || entity.getOffset() != 0 || !"bot_command".equals(entity.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasDocument() {
        return this.document != null;
    }

    @JsonIgnore
    public boolean hasVideo() {
        return this.video != null;
    }

    @JsonIgnore
    public boolean hasAudio() {
        return this.audio != null;
    }

    @JsonIgnore
    public boolean hasVoice() {
        return this.voice != null;
    }

    @JsonIgnore
    public boolean isReply() {
        return this.replyToMessage != null;
    }

    @JsonIgnore
    public boolean hasLocation() {
        return this.location != null;
    }

    @JsonIgnore
    private boolean hasGame() {
        return this.game != null;
    }

    @JsonIgnore
    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    @JsonIgnore
    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    @JsonIgnore
    public boolean hasInvoice() {
        return this.invoice != null;
    }

    @JsonIgnore
    public boolean hasSuccessfulPayment() {
        return this.successfulPayment != null;
    }

    @JsonIgnore
    public boolean hasContact() {
        return this.contact != null;
    }

    @JsonIgnore
    public boolean hasVideoNote() {
        return this.videoNote != null;
    }

    @JsonIgnore
    public boolean hasPassportData() {
        return this.passportData != null;
    }

    @JsonIgnore
    public boolean hasAnimation() {
        return this.animation != null;
    }

    @JsonIgnore
    public boolean hasPoll() {
        return this.poll != null;
    }

    @JsonIgnore
    public boolean hasDice() {
        return this.dice != null;
    }

    @JsonIgnore
    public boolean hasViaBot() {
        return this.viaBot != null;
    }

    @JsonIgnore
    public boolean hasReplyMarkup() {
        return this.replyMarkup != null;
    }

    @JsonIgnore
    private boolean hasMessageAutoDeleteTimerChanged() {
        return this.messageAutoDeleteTimerChanged != null;
    }

    @JsonIgnore
    private boolean hasWebAppData() {
        return this.webAppData != null;
    }

    @JsonIgnore
    private boolean hasVideoChatStarted() {
        return this.videoChatStarted != null;
    }

    @JsonIgnore
    private boolean hasVideoChatEnded() {
        return this.videoChatEnded != null;
    }

    @JsonIgnore
    private boolean hasVideoChatScheduled() {
        return this.videoChatScheduled != null;
    }

    @JsonIgnore
    private boolean hasVideoChatParticipantsInvited() {
        return this.videoChatParticipantsInvited != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Integer this$date = this.getDate();
        Integer other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Integer this$forwardDate = this.getForwardDate();
        Integer other$forwardDate = other.getForwardDate();
        if (this$forwardDate == null ? other$forwardDate != null : !((Object)this$forwardDate).equals(other$forwardDate)) {
            return false;
        }
        Boolean this$deleteChatPhoto = this.getDeleteChatPhoto();
        Boolean other$deleteChatPhoto = other.getDeleteChatPhoto();
        if (this$deleteChatPhoto == null ? other$deleteChatPhoto != null : !((Object)this$deleteChatPhoto).equals(other$deleteChatPhoto)) {
            return false;
        }
        Boolean this$groupchatCreated = this.getGroupchatCreated();
        Boolean other$groupchatCreated = other.getGroupchatCreated();
        if (this$groupchatCreated == null ? other$groupchatCreated != null : !((Object)this$groupchatCreated).equals(other$groupchatCreated)) {
            return false;
        }
        Boolean this$superGroupCreated = this.getSuperGroupCreated();
        Boolean other$superGroupCreated = other.getSuperGroupCreated();
        if (this$superGroupCreated == null ? other$superGroupCreated != null : !((Object)this$superGroupCreated).equals(other$superGroupCreated)) {
            return false;
        }
        Boolean this$channelChatCreated = this.getChannelChatCreated();
        Boolean other$channelChatCreated = other.getChannelChatCreated();
        if (this$channelChatCreated == null ? other$channelChatCreated != null : !((Object)this$channelChatCreated).equals(other$channelChatCreated)) {
            return false;
        }
        Long this$migrateToChatId = this.getMigrateToChatId();
        Long other$migrateToChatId = other.getMigrateToChatId();
        if (this$migrateToChatId == null ? other$migrateToChatId != null : !((Object)this$migrateToChatId).equals(other$migrateToChatId)) {
            return false;
        }
        Long this$migrateFromChatId = this.getMigrateFromChatId();
        Long other$migrateFromChatId = other.getMigrateFromChatId();
        if (this$migrateFromChatId == null ? other$migrateFromChatId != null : !((Object)this$migrateFromChatId).equals(other$migrateFromChatId)) {
            return false;
        }
        Integer this$editDate = this.getEditDate();
        Integer other$editDate = other.getEditDate();
        if (this$editDate == null ? other$editDate != null : !((Object)this$editDate).equals(other$editDate)) {
            return false;
        }
        Integer this$forwardFromMessageId = this.getForwardFromMessageId();
        Integer other$forwardFromMessageId = other.getForwardFromMessageId();
        if (this$forwardFromMessageId == null ? other$forwardFromMessageId != null : !((Object)this$forwardFromMessageId).equals(other$forwardFromMessageId)) {
            return false;
        }
        Boolean this$isAutomaticForward = this.getIsAutomaticForward();
        Boolean other$isAutomaticForward = other.getIsAutomaticForward();
        if (this$isAutomaticForward == null ? other$isAutomaticForward != null : !((Object)this$isAutomaticForward).equals(other$isAutomaticForward)) {
            return false;
        }
        Boolean this$hasProtectedContent = this.getHasProtectedContent();
        Boolean other$hasProtectedContent = other.getHasProtectedContent();
        if (this$hasProtectedContent == null ? other$hasProtectedContent != null : !((Object)this$hasProtectedContent).equals(other$hasProtectedContent)) {
            return false;
        }
        User this$from = this.getFrom();
        User other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Chat this$chat = this.getChat();
        Chat other$chat = other.getChat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        User this$forwardFrom = this.getForwardFrom();
        User other$forwardFrom = other.getForwardFrom();
        if (this$forwardFrom == null ? other$forwardFrom != null : !((Object)this$forwardFrom).equals(other$forwardFrom)) {
            return false;
        }
        Chat this$forwardFromChat = this.getForwardFromChat();
        Chat other$forwardFromChat = other.getForwardFromChat();
        if (this$forwardFromChat == null ? other$forwardFromChat != null : !((Object)this$forwardFromChat).equals(other$forwardFromChat)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        Audio this$audio = this.getAudio();
        Audio other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        List<PhotoSize> this$photo = this.getPhoto();
        List<PhotoSize> other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo)) {
            return false;
        }
        Sticker this$sticker = this.getSticker();
        Sticker other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        Contact this$contact = this.getContact();
        Contact other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !((Object)this$contact).equals(other$contact)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Venue this$venue = this.getVenue();
        Venue other$venue = other.getVenue();
        if (this$venue == null ? other$venue != null : !((Object)this$venue).equals(other$venue)) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        Message this$pinnedMessage = this.getPinnedMessage();
        Message other$pinnedMessage = other.getPinnedMessage();
        if (this$pinnedMessage == null ? other$pinnedMessage != null : !((Object)this$pinnedMessage).equals(other$pinnedMessage)) {
            return false;
        }
        List<User> this$newChatMembers = this.getNewChatMembers();
        List<User> other$newChatMembers = other.getNewChatMembers();
        if (this$newChatMembers == null ? other$newChatMembers != null : !((Object)this$newChatMembers).equals(other$newChatMembers)) {
            return false;
        }
        User this$leftChatMember = this.getLeftChatMember();
        User other$leftChatMember = other.getLeftChatMember();
        if (this$leftChatMember == null ? other$leftChatMember != null : !((Object)this$leftChatMember).equals(other$leftChatMember)) {
            return false;
        }
        String this$newChatTitle = this.getNewChatTitle();
        String other$newChatTitle = other.getNewChatTitle();
        if (this$newChatTitle == null ? other$newChatTitle != null : !this$newChatTitle.equals(other$newChatTitle)) {
            return false;
        }
        List<PhotoSize> this$newChatPhoto = this.getNewChatPhoto();
        List<PhotoSize> other$newChatPhoto = other.getNewChatPhoto();
        if (this$newChatPhoto == null ? other$newChatPhoto != null : !((Object)this$newChatPhoto).equals(other$newChatPhoto)) {
            return false;
        }
        Message this$replyToMessage = this.getReplyToMessage();
        Message other$replyToMessage = other.getReplyToMessage();
        if (this$replyToMessage == null ? other$replyToMessage != null : !((Object)this$replyToMessage).equals(other$replyToMessage)) {
            return false;
        }
        Voice this$voice = this.getVoice();
        Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !((Object)this$game).equals(other$game)) {
            return false;
        }
        Invoice this$invoice = this.getInvoice();
        Invoice other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !((Object)this$invoice).equals(other$invoice)) {
            return false;
        }
        SuccessfulPayment this$successfulPayment = this.getSuccessfulPayment();
        SuccessfulPayment other$successfulPayment = other.getSuccessfulPayment();
        if (this$successfulPayment == null ? other$successfulPayment != null : !((Object)this$successfulPayment).equals(other$successfulPayment)) {
            return false;
        }
        VideoNote this$videoNote = this.getVideoNote();
        VideoNote other$videoNote = other.getVideoNote();
        if (this$videoNote == null ? other$videoNote != null : !((Object)this$videoNote).equals(other$videoNote)) {
            return false;
        }
        String this$authorSignature = this.getAuthorSignature();
        String other$authorSignature = other.getAuthorSignature();
        if (this$authorSignature == null ? other$authorSignature != null : !this$authorSignature.equals(other$authorSignature)) {
            return false;
        }
        String this$forwardSignature = this.getForwardSignature();
        String other$forwardSignature = other.getForwardSignature();
        if (this$forwardSignature == null ? other$forwardSignature != null : !this$forwardSignature.equals(other$forwardSignature)) {
            return false;
        }
        String this$mediaGroupId = this.getMediaGroupId();
        String other$mediaGroupId = other.getMediaGroupId();
        if (this$mediaGroupId == null ? other$mediaGroupId != null : !this$mediaGroupId.equals(other$mediaGroupId)) {
            return false;
        }
        String this$connectedWebsite = this.getConnectedWebsite();
        String other$connectedWebsite = other.getConnectedWebsite();
        if (this$connectedWebsite == null ? other$connectedWebsite != null : !this$connectedWebsite.equals(other$connectedWebsite)) {
            return false;
        }
        PassportData this$passportData = this.getPassportData();
        PassportData other$passportData = other.getPassportData();
        if (this$passportData == null ? other$passportData != null : !((Object)this$passportData).equals(other$passportData)) {
            return false;
        }
        String this$forwardSenderName = this.getForwardSenderName();
        String other$forwardSenderName = other.getForwardSenderName();
        if (this$forwardSenderName == null ? other$forwardSenderName != null : !this$forwardSenderName.equals(other$forwardSenderName)) {
            return false;
        }
        Poll this$poll = this.getPoll();
        Poll other$poll = other.getPoll();
        if (this$poll == null ? other$poll != null : !((Object)this$poll).equals(other$poll)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        Dice this$dice = this.getDice();
        Dice other$dice = other.getDice();
        if (this$dice == null ? other$dice != null : !((Object)this$dice).equals(other$dice)) {
            return false;
        }
        User this$viaBot = this.getViaBot();
        User other$viaBot = other.getViaBot();
        if (this$viaBot == null ? other$viaBot != null : !((Object)this$viaBot).equals(other$viaBot)) {
            return false;
        }
        Chat this$senderChat = this.getSenderChat();
        Chat other$senderChat = other.getSenderChat();
        if (this$senderChat == null ? other$senderChat != null : !((Object)this$senderChat).equals(other$senderChat)) {
            return false;
        }
        ProximityAlertTriggered this$proximityAlertTriggered = this.getProximityAlertTriggered();
        ProximityAlertTriggered other$proximityAlertTriggered = other.getProximityAlertTriggered();
        if (this$proximityAlertTriggered == null ? other$proximityAlertTriggered != null : !((Object)this$proximityAlertTriggered).equals(other$proximityAlertTriggered)) {
            return false;
        }
        MessageAutoDeleteTimerChanged this$messageAutoDeleteTimerChanged = this.getMessageAutoDeleteTimerChanged();
        MessageAutoDeleteTimerChanged other$messageAutoDeleteTimerChanged = other.getMessageAutoDeleteTimerChanged();
        if (this$messageAutoDeleteTimerChanged == null ? other$messageAutoDeleteTimerChanged != null : !((Object)this$messageAutoDeleteTimerChanged).equals(other$messageAutoDeleteTimerChanged)) {
            return false;
        }
        WebAppData this$webAppData = this.getWebAppData();
        WebAppData other$webAppData = other.getWebAppData();
        if (this$webAppData == null ? other$webAppData != null : !((Object)this$webAppData).equals(other$webAppData)) {
            return false;
        }
        VideoChatStarted this$videoChatStarted = this.getVideoChatStarted();
        VideoChatStarted other$videoChatStarted = other.getVideoChatStarted();
        if (this$videoChatStarted == null ? other$videoChatStarted != null : !((Object)this$videoChatStarted).equals(other$videoChatStarted)) {
            return false;
        }
        VideoChatEnded this$videoChatEnded = this.getVideoChatEnded();
        VideoChatEnded other$videoChatEnded = other.getVideoChatEnded();
        if (this$videoChatEnded == null ? other$videoChatEnded != null : !((Object)this$videoChatEnded).equals(other$videoChatEnded)) {
            return false;
        }
        VideoChatParticipantsInvited this$videoChatParticipantsInvited = this.getVideoChatParticipantsInvited();
        VideoChatParticipantsInvited other$videoChatParticipantsInvited = other.getVideoChatParticipantsInvited();
        if (this$videoChatParticipantsInvited == null ? other$videoChatParticipantsInvited != null : !((Object)this$videoChatParticipantsInvited).equals(other$videoChatParticipantsInvited)) {
            return false;
        }
        VideoChatScheduled this$videoChatScheduled = this.getVideoChatScheduled();
        VideoChatScheduled other$videoChatScheduled = other.getVideoChatScheduled();
        return !(this$videoChatScheduled == null ? other$videoChatScheduled != null : !((Object)this$videoChatScheduled).equals(other$videoChatScheduled));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Integer $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Integer $forwardDate = this.getForwardDate();
        result = result * 59 + ($forwardDate == null ? 43 : ((Object)$forwardDate).hashCode());
        Boolean $deleteChatPhoto = this.getDeleteChatPhoto();
        result = result * 59 + ($deleteChatPhoto == null ? 43 : ((Object)$deleteChatPhoto).hashCode());
        Boolean $groupchatCreated = this.getGroupchatCreated();
        result = result * 59 + ($groupchatCreated == null ? 43 : ((Object)$groupchatCreated).hashCode());
        Boolean $superGroupCreated = this.getSuperGroupCreated();
        result = result * 59 + ($superGroupCreated == null ? 43 : ((Object)$superGroupCreated).hashCode());
        Boolean $channelChatCreated = this.getChannelChatCreated();
        result = result * 59 + ($channelChatCreated == null ? 43 : ((Object)$channelChatCreated).hashCode());
        Long $migrateToChatId = this.getMigrateToChatId();
        result = result * 59 + ($migrateToChatId == null ? 43 : ((Object)$migrateToChatId).hashCode());
        Long $migrateFromChatId = this.getMigrateFromChatId();
        result = result * 59 + ($migrateFromChatId == null ? 43 : ((Object)$migrateFromChatId).hashCode());
        Integer $editDate = this.getEditDate();
        result = result * 59 + ($editDate == null ? 43 : ((Object)$editDate).hashCode());
        Integer $forwardFromMessageId = this.getForwardFromMessageId();
        result = result * 59 + ($forwardFromMessageId == null ? 43 : ((Object)$forwardFromMessageId).hashCode());
        Boolean $isAutomaticForward = this.getIsAutomaticForward();
        result = result * 59 + ($isAutomaticForward == null ? 43 : ((Object)$isAutomaticForward).hashCode());
        Boolean $hasProtectedContent = this.getHasProtectedContent();
        result = result * 59 + ($hasProtectedContent == null ? 43 : ((Object)$hasProtectedContent).hashCode());
        User $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Chat $chat = this.getChat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        User $forwardFrom = this.getForwardFrom();
        result = result * 59 + ($forwardFrom == null ? 43 : ((Object)$forwardFrom).hashCode());
        Chat $forwardFromChat = this.getForwardFromChat();
        result = result * 59 + ($forwardFromChat == null ? 43 : ((Object)$forwardFromChat).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        Audio $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        List<PhotoSize> $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        Sticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : ((Object)$video).hashCode());
        Contact $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : ((Object)$contact).hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Venue $venue = this.getVenue();
        result = result * 59 + ($venue == null ? 43 : ((Object)$venue).hashCode());
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        Message $pinnedMessage = this.getPinnedMessage();
        result = result * 59 + ($pinnedMessage == null ? 43 : ((Object)$pinnedMessage).hashCode());
        List<User> $newChatMembers = this.getNewChatMembers();
        result = result * 59 + ($newChatMembers == null ? 43 : ((Object)$newChatMembers).hashCode());
        User $leftChatMember = this.getLeftChatMember();
        result = result * 59 + ($leftChatMember == null ? 43 : ((Object)$leftChatMember).hashCode());
        String $newChatTitle = this.getNewChatTitle();
        result = result * 59 + ($newChatTitle == null ? 43 : $newChatTitle.hashCode());
        List<PhotoSize> $newChatPhoto = this.getNewChatPhoto();
        result = result * 59 + ($newChatPhoto == null ? 43 : ((Object)$newChatPhoto).hashCode());
        Message $replyToMessage = this.getReplyToMessage();
        result = result * 59 + ($replyToMessage == null ? 43 : ((Object)$replyToMessage).hashCode());
        Voice $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : ((Object)$game).hashCode());
        Invoice $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : ((Object)$invoice).hashCode());
        SuccessfulPayment $successfulPayment = this.getSuccessfulPayment();
        result = result * 59 + ($successfulPayment == null ? 43 : ((Object)$successfulPayment).hashCode());
        VideoNote $videoNote = this.getVideoNote();
        result = result * 59 + ($videoNote == null ? 43 : ((Object)$videoNote).hashCode());
        String $authorSignature = this.getAuthorSignature();
        result = result * 59 + ($authorSignature == null ? 43 : $authorSignature.hashCode());
        String $forwardSignature = this.getForwardSignature();
        result = result * 59 + ($forwardSignature == null ? 43 : $forwardSignature.hashCode());
        String $mediaGroupId = this.getMediaGroupId();
        result = result * 59 + ($mediaGroupId == null ? 43 : $mediaGroupId.hashCode());
        String $connectedWebsite = this.getConnectedWebsite();
        result = result * 59 + ($connectedWebsite == null ? 43 : $connectedWebsite.hashCode());
        PassportData $passportData = this.getPassportData();
        result = result * 59 + ($passportData == null ? 43 : ((Object)$passportData).hashCode());
        String $forwardSenderName = this.getForwardSenderName();
        result = result * 59 + ($forwardSenderName == null ? 43 : $forwardSenderName.hashCode());
        Poll $poll = this.getPoll();
        result = result * 59 + ($poll == null ? 43 : ((Object)$poll).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        Dice $dice = this.getDice();
        result = result * 59 + ($dice == null ? 43 : ((Object)$dice).hashCode());
        User $viaBot = this.getViaBot();
        result = result * 59 + ($viaBot == null ? 43 : ((Object)$viaBot).hashCode());
        Chat $senderChat = this.getSenderChat();
        result = result * 59 + ($senderChat == null ? 43 : ((Object)$senderChat).hashCode());
        ProximityAlertTriggered $proximityAlertTriggered = this.getProximityAlertTriggered();
        result = result * 59 + ($proximityAlertTriggered == null ? 43 : ((Object)$proximityAlertTriggered).hashCode());
        MessageAutoDeleteTimerChanged $messageAutoDeleteTimerChanged = this.getMessageAutoDeleteTimerChanged();
        result = result * 59 + ($messageAutoDeleteTimerChanged == null ? 43 : ((Object)$messageAutoDeleteTimerChanged).hashCode());
        WebAppData $webAppData = this.getWebAppData();
        result = result * 59 + ($webAppData == null ? 43 : ((Object)$webAppData).hashCode());
        VideoChatStarted $videoChatStarted = this.getVideoChatStarted();
        result = result * 59 + ($videoChatStarted == null ? 43 : ((Object)$videoChatStarted).hashCode());
        VideoChatEnded $videoChatEnded = this.getVideoChatEnded();
        result = result * 59 + ($videoChatEnded == null ? 43 : ((Object)$videoChatEnded).hashCode());
        VideoChatParticipantsInvited $videoChatParticipantsInvited = this.getVideoChatParticipantsInvited();
        result = result * 59 + ($videoChatParticipantsInvited == null ? 43 : ((Object)$videoChatParticipantsInvited).hashCode());
        VideoChatScheduled $videoChatScheduled = this.getVideoChatScheduled();
        result = result * 59 + ($videoChatScheduled == null ? 43 : ((Object)$videoChatScheduled).hashCode());
        return result;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public User getFrom() {
        return this.from;
    }

    public Integer getDate() {
        return this.date;
    }

    public Chat getChat() {
        return this.chat;
    }

    public User getForwardFrom() {
        return this.forwardFrom;
    }

    public Chat getForwardFromChat() {
        return this.forwardFromChat;
    }

    public Integer getForwardDate() {
        return this.forwardDate;
    }

    public String getText() {
        return this.text;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public Video getVideo() {
        return this.video;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Location getLocation() {
        return this.location;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Message getPinnedMessage() {
        return this.pinnedMessage;
    }

    public User getLeftChatMember() {
        return this.leftChatMember;
    }

    public String getNewChatTitle() {
        return this.newChatTitle;
    }

    public List<PhotoSize> getNewChatPhoto() {
        return this.newChatPhoto;
    }

    public Boolean getDeleteChatPhoto() {
        return this.deleteChatPhoto;
    }

    public Boolean getGroupchatCreated() {
        return this.groupchatCreated;
    }

    public Message getReplyToMessage() {
        return this.replyToMessage;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public String getCaption() {
        return this.caption;
    }

    public Boolean getSuperGroupCreated() {
        return this.superGroupCreated;
    }

    public Boolean getChannelChatCreated() {
        return this.channelChatCreated;
    }

    public Long getMigrateToChatId() {
        return this.migrateToChatId;
    }

    public Long getMigrateFromChatId() {
        return this.migrateFromChatId;
    }

    public Integer getEditDate() {
        return this.editDate;
    }

    public Game getGame() {
        return this.game;
    }

    public Integer getForwardFromMessageId() {
        return this.forwardFromMessageId;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public SuccessfulPayment getSuccessfulPayment() {
        return this.successfulPayment;
    }

    public VideoNote getVideoNote() {
        return this.videoNote;
    }

    public String getAuthorSignature() {
        return this.authorSignature;
    }

    public String getForwardSignature() {
        return this.forwardSignature;
    }

    public String getMediaGroupId() {
        return this.mediaGroupId;
    }

    public String getConnectedWebsite() {
        return this.connectedWebsite;
    }

    public PassportData getPassportData() {
        return this.passportData;
    }

    public String getForwardSenderName() {
        return this.forwardSenderName;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public Dice getDice() {
        return this.dice;
    }

    public User getViaBot() {
        return this.viaBot;
    }

    public Chat getSenderChat() {
        return this.senderChat;
    }

    public ProximityAlertTriggered getProximityAlertTriggered() {
        return this.proximityAlertTriggered;
    }

    public MessageAutoDeleteTimerChanged getMessageAutoDeleteTimerChanged() {
        return this.messageAutoDeleteTimerChanged;
    }

    public Boolean getIsAutomaticForward() {
        return this.isAutomaticForward;
    }

    public Boolean getHasProtectedContent() {
        return this.hasProtectedContent;
    }

    public WebAppData getWebAppData() {
        return this.webAppData;
    }

    public VideoChatStarted getVideoChatStarted() {
        return this.videoChatStarted;
    }

    public VideoChatEnded getVideoChatEnded() {
        return this.videoChatEnded;
    }

    public VideoChatParticipantsInvited getVideoChatParticipantsInvited() {
        return this.videoChatParticipantsInvited;
    }

    public VideoChatScheduled getVideoChatScheduled() {
        return this.videoChatScheduled;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="from")
    public void setFrom(User from) {
        this.from = from;
    }

    @JsonProperty(value="date")
    public void setDate(Integer date) {
        this.date = date;
    }

    @JsonProperty(value="chat")
    public void setChat(Chat chat) {
        this.chat = chat;
    }

    @JsonProperty(value="forward_from")
    public void setForwardFrom(User forwardFrom) {
        this.forwardFrom = forwardFrom;
    }

    @JsonProperty(value="forward_from_chat")
    public void setForwardFromChat(Chat forwardFromChat) {
        this.forwardFromChat = forwardFromChat;
    }

    @JsonProperty(value="forward_date")
    public void setForwardDate(Integer forwardDate) {
        this.forwardDate = forwardDate;
    }

    @JsonProperty(value="text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="entities")
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="audio")
    public void setAudio(Audio audio) {
        this.audio = audio;
    }

    @JsonProperty(value="document")
    public void setDocument(Document document) {
        this.document = document;
    }

    @JsonProperty(value="photo")
    public void setPhoto(List<PhotoSize> photo) {
        this.photo = photo;
    }

    @JsonProperty(value="sticker")
    public void setSticker(Sticker sticker) {
        this.sticker = sticker;
    }

    @JsonProperty(value="video")
    public void setVideo(Video video) {
        this.video = video;
    }

    @JsonProperty(value="contact")
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    @JsonProperty(value="venue")
    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    @JsonProperty(value="animation")
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @JsonProperty(value="pinned_message")
    public void setPinnedMessage(Message pinnedMessage) {
        this.pinnedMessage = pinnedMessage;
    }

    @JsonProperty(value="new_chat_members")
    public void setNewChatMembers(List<User> newChatMembers) {
        this.newChatMembers = newChatMembers;
    }

    @JsonProperty(value="left_chat_member")
    public void setLeftChatMember(User leftChatMember) {
        this.leftChatMember = leftChatMember;
    }

    @JsonProperty(value="new_chat_title")
    public void setNewChatTitle(String newChatTitle) {
        this.newChatTitle = newChatTitle;
    }

    @JsonProperty(value="new_chat_photo")
    public void setNewChatPhoto(List<PhotoSize> newChatPhoto) {
        this.newChatPhoto = newChatPhoto;
    }

    @JsonProperty(value="delete_chat_photo")
    public void setDeleteChatPhoto(Boolean deleteChatPhoto) {
        this.deleteChatPhoto = deleteChatPhoto;
    }

    @JsonProperty(value="group_chat_created")
    public void setGroupchatCreated(Boolean groupchatCreated) {
        this.groupchatCreated = groupchatCreated;
    }

    @JsonProperty(value="reply_to_message")
    public void setReplyToMessage(Message replyToMessage) {
        this.replyToMessage = replyToMessage;
    }

    @JsonProperty(value="voice")
    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="supergroup_chat_created")
    public void setSuperGroupCreated(Boolean superGroupCreated) {
        this.superGroupCreated = superGroupCreated;
    }

    @JsonProperty(value="channel_chat_created")
    public void setChannelChatCreated(Boolean channelChatCreated) {
        this.channelChatCreated = channelChatCreated;
    }

    @JsonProperty(value="migrate_to_chat_id")
    public void setMigrateToChatId(Long migrateToChatId) {
        this.migrateToChatId = migrateToChatId;
    }

    @JsonProperty(value="migrate_from_chat_id")
    public void setMigrateFromChatId(Long migrateFromChatId) {
        this.migrateFromChatId = migrateFromChatId;
    }

    @JsonProperty(value="edit_date")
    public void setEditDate(Integer editDate) {
        this.editDate = editDate;
    }

    @JsonProperty(value="game")
    public void setGame(Game game) {
        this.game = game;
    }

    @JsonProperty(value="forward_from_message_id")
    public void setForwardFromMessageId(Integer forwardFromMessageId) {
        this.forwardFromMessageId = forwardFromMessageId;
    }

    @JsonProperty(value="invoice")
    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    @JsonProperty(value="successful_payment")
    public void setSuccessfulPayment(SuccessfulPayment successfulPayment) {
        this.successfulPayment = successfulPayment;
    }

    @JsonProperty(value="video_note")
    public void setVideoNote(VideoNote videoNote) {
        this.videoNote = videoNote;
    }

    @JsonProperty(value="author_signature")
    public void setAuthorSignature(String authorSignature) {
        this.authorSignature = authorSignature;
    }

    @JsonProperty(value="forward_signature")
    public void setForwardSignature(String forwardSignature) {
        this.forwardSignature = forwardSignature;
    }

    @JsonProperty(value="media_group_id")
    public void setMediaGroupId(String mediaGroupId) {
        this.mediaGroupId = mediaGroupId;
    }

    @JsonProperty(value="connected_website")
    public void setConnectedWebsite(String connectedWebsite) {
        this.connectedWebsite = connectedWebsite;
    }

    @JsonProperty(value="passport_data")
    public void setPassportData(PassportData passportData) {
        this.passportData = passportData;
    }

    @JsonProperty(value="forward_sender_name")
    public void setForwardSenderName(String forwardSenderName) {
        this.forwardSenderName = forwardSenderName;
    }

    @JsonProperty(value="poll")
    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="dice")
    public void setDice(Dice dice) {
        this.dice = dice;
    }

    @JsonProperty(value="via_bot")
    public void setViaBot(User viaBot) {
        this.viaBot = viaBot;
    }

    @JsonProperty(value="sender_chat")
    public void setSenderChat(Chat senderChat) {
        this.senderChat = senderChat;
    }

    @JsonProperty(value="proximity_alert_triggered")
    public void setProximityAlertTriggered(ProximityAlertTriggered proximityAlertTriggered) {
        this.proximityAlertTriggered = proximityAlertTriggered;
    }

    @JsonProperty(value="message_auto_delete_timer_changed")
    public void setMessageAutoDeleteTimerChanged(MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged) {
        this.messageAutoDeleteTimerChanged = messageAutoDeleteTimerChanged;
    }

    @JsonProperty(value="is_automatic_forward")
    public void setIsAutomaticForward(Boolean isAutomaticForward) {
        this.isAutomaticForward = isAutomaticForward;
    }

    @JsonProperty(value="has_protected_content")
    public void setHasProtectedContent(Boolean hasProtectedContent) {
        this.hasProtectedContent = hasProtectedContent;
    }

    @JsonProperty(value="web_app_data")
    public void setWebAppData(WebAppData webAppData) {
        this.webAppData = webAppData;
    }

    @JsonProperty(value="video_chat_started")
    public void setVideoChatStarted(VideoChatStarted videoChatStarted) {
        this.videoChatStarted = videoChatStarted;
    }

    @JsonProperty(value="video_chat_ended")
    public void setVideoChatEnded(VideoChatEnded videoChatEnded) {
        this.videoChatEnded = videoChatEnded;
    }

    @JsonProperty(value="video_chat_participants_invited")
    public void setVideoChatParticipantsInvited(VideoChatParticipantsInvited videoChatParticipantsInvited) {
        this.videoChatParticipantsInvited = videoChatParticipantsInvited;
    }

    @JsonProperty(value="video_chat_scheduled")
    public void setVideoChatScheduled(VideoChatScheduled videoChatScheduled) {
        this.videoChatScheduled = videoChatScheduled;
    }

    public String toString() {
        return "Message(messageId=" + this.getMessageId() + ", from=" + this.getFrom() + ", date=" + this.getDate() + ", chat=" + this.getChat() + ", forwardFrom=" + this.getForwardFrom() + ", forwardFromChat=" + this.getForwardFromChat() + ", forwardDate=" + this.getForwardDate() + ", text=" + this.getText() + ", entities=" + this.getEntities() + ", captionEntities=" + this.getCaptionEntities() + ", audio=" + this.getAudio() + ", document=" + this.getDocument() + ", photo=" + this.getPhoto() + ", sticker=" + this.getSticker() + ", video=" + this.getVideo() + ", contact=" + this.getContact() + ", location=" + this.getLocation() + ", venue=" + this.getVenue() + ", animation=" + this.getAnimation() + ", pinnedMessage=" + this.getPinnedMessage() + ", newChatMembers=" + this.getNewChatMembers() + ", leftChatMember=" + this.getLeftChatMember() + ", newChatTitle=" + this.getNewChatTitle() + ", newChatPhoto=" + this.getNewChatPhoto() + ", deleteChatPhoto=" + this.getDeleteChatPhoto() + ", groupchatCreated=" + this.getGroupchatCreated() + ", replyToMessage=" + this.getReplyToMessage() + ", voice=" + this.getVoice() + ", caption=" + this.getCaption() + ", superGroupCreated=" + this.getSuperGroupCreated() + ", channelChatCreated=" + this.getChannelChatCreated() + ", migrateToChatId=" + this.getMigrateToChatId() + ", migrateFromChatId=" + this.getMigrateFromChatId() + ", editDate=" + this.getEditDate() + ", game=" + this.getGame() + ", forwardFromMessageId=" + this.getForwardFromMessageId() + ", invoice=" + this.getInvoice() + ", successfulPayment=" + this.getSuccessfulPayment() + ", videoNote=" + this.getVideoNote() + ", authorSignature=" + this.getAuthorSignature() + ", forwardSignature=" + this.getForwardSignature() + ", mediaGroupId=" + this.getMediaGroupId() + ", connectedWebsite=" + this.getConnectedWebsite() + ", passportData=" + this.getPassportData() + ", forwardSenderName=" + this.getForwardSenderName() + ", poll=" + this.getPoll() + ", replyMarkup=" + this.getReplyMarkup() + ", dice=" + this.getDice() + ", viaBot=" + this.getViaBot() + ", senderChat=" + this.getSenderChat() + ", proximityAlertTriggered=" + this.getProximityAlertTriggered() + ", messageAutoDeleteTimerChanged=" + this.getMessageAutoDeleteTimerChanged() + ", isAutomaticForward=" + this.getIsAutomaticForward() + ", hasProtectedContent=" + this.getHasProtectedContent() + ", webAppData=" + this.getWebAppData() + ", videoChatStarted=" + this.getVideoChatStarted() + ", videoChatEnded=" + this.getVideoChatEnded() + ", videoChatParticipantsInvited=" + this.getVideoChatParticipantsInvited() + ", videoChatScheduled=" + this.getVideoChatScheduled() + ")";
    }

    public Message() {
    }

    public Message(Integer messageId, User from, Integer date, Chat chat, User forwardFrom, Chat forwardFromChat, Integer forwardDate, String text, List<MessageEntity> entities, List<MessageEntity> captionEntities, Audio audio, Document document, List<PhotoSize> photo, Sticker sticker, Video video, Contact contact, Location location, Venue venue, Animation animation, Message pinnedMessage, List<User> newChatMembers, User leftChatMember, String newChatTitle, List<PhotoSize> newChatPhoto, Boolean deleteChatPhoto, Boolean groupchatCreated, Message replyToMessage, Voice voice, String caption, Boolean superGroupCreated, Boolean channelChatCreated, Long migrateToChatId, Long migrateFromChatId, Integer editDate, Game game, Integer forwardFromMessageId, Invoice invoice, SuccessfulPayment successfulPayment, VideoNote videoNote, String authorSignature, String forwardSignature, String mediaGroupId, String connectedWebsite, PassportData passportData, String forwardSenderName, Poll poll, InlineKeyboardMarkup replyMarkup, Dice dice, User viaBot, Chat senderChat, ProximityAlertTriggered proximityAlertTriggered, MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged, Boolean isAutomaticForward, Boolean hasProtectedContent, WebAppData webAppData, VideoChatStarted videoChatStarted, VideoChatEnded videoChatEnded, VideoChatParticipantsInvited videoChatParticipantsInvited, VideoChatScheduled videoChatScheduled) {
        this.messageId = messageId;
        this.from = from;
        this.date = date;
        this.chat = chat;
        this.forwardFrom = forwardFrom;
        this.forwardFromChat = forwardFromChat;
        this.forwardDate = forwardDate;
        this.text = text;
        this.entities = entities;
        this.captionEntities = captionEntities;
        this.audio = audio;
        this.document = document;
        this.photo = photo;
        this.sticker = sticker;
        this.video = video;
        this.contact = contact;
        this.location = location;
        this.venue = venue;
        this.animation = animation;
        this.pinnedMessage = pinnedMessage;
        this.newChatMembers = newChatMembers;
        this.leftChatMember = leftChatMember;
        this.newChatTitle = newChatTitle;
        this.newChatPhoto = newChatPhoto;
        this.deleteChatPhoto = deleteChatPhoto;
        this.groupchatCreated = groupchatCreated;
        this.replyToMessage = replyToMessage;
        this.voice = voice;
        this.caption = caption;
        this.superGroupCreated = superGroupCreated;
        this.channelChatCreated = channelChatCreated;
        this.migrateToChatId = migrateToChatId;
        this.migrateFromChatId = migrateFromChatId;
        this.editDate = editDate;
        this.game = game;
        this.forwardFromMessageId = forwardFromMessageId;
        this.invoice = invoice;
        this.successfulPayment = successfulPayment;
        this.videoNote = videoNote;
        this.authorSignature = authorSignature;
        this.forwardSignature = forwardSignature;
        this.mediaGroupId = mediaGroupId;
        this.connectedWebsite = connectedWebsite;
        this.passportData = passportData;
        this.forwardSenderName = forwardSenderName;
        this.poll = poll;
        this.replyMarkup = replyMarkup;
        this.dice = dice;
        this.viaBot = viaBot;
        this.senderChat = senderChat;
        this.proximityAlertTriggered = proximityAlertTriggered;
        this.messageAutoDeleteTimerChanged = messageAutoDeleteTimerChanged;
        this.isAutomaticForward = isAutomaticForward;
        this.hasProtectedContent = hasProtectedContent;
        this.webAppData = webAppData;
        this.videoChatStarted = videoChatStarted;
        this.videoChatEnded = videoChatEnded;
        this.videoChatParticipantsInvited = videoChatParticipantsInvited;
        this.videoChatScheduled = videoChatScheduled;
    }
}

