/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultArticle;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultAudio;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultContact;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultDocument;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultGame;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultGif;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultLocation;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultMpeg4Gif;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultPhoto;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultVenue;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultVideo;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultVoice;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedAudio;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedDocument;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedGif;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedMpeg4Gif;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedPhoto;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedSticker;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedVideo;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached.InlineQueryResultCachedVoice;

public class InlineQueryResultDeserializer
extends StdDeserializer<InlineQueryResult> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public InlineQueryResultDeserializer() {
        this(null);
    }

    private InlineQueryResultDeserializer(Class<?> vc) {
        super(vc);
    }

    public InlineQueryResult deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        switch (node.get("type").asText()) {
            case "article": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultArticle>(){});
            }
            case "audio": {
                if (node.has("audio_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultAudio>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedAudio>(){});
            }
            case "contact": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultContact>(){});
            }
            case "document": {
                if (node.has("document_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultDocument>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedDocument>(){});
            }
            case "game": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultGame>(){});
            }
            case "gif": {
                if (node.has("gif_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultGif>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedGif>(){});
            }
            case "location": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultLocation>(){});
            }
            case "mpeg4_gif": {
                if (node.has("mpeg4_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultMpeg4Gif>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedMpeg4Gif>(){});
            }
            case "photo": {
                if (node.has("photo_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultPhoto>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedPhoto>(){});
            }
            case "venue": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultVenue>(){});
            }
            case "video": {
                if (node.has("video_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultVideo>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedVideo>(){});
            }
            case "voice": {
                if (node.has("voice_url")) {
                    return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultVoice>(){});
                }
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedVoice>(){});
            }
            case "sticker": {
                return (InlineQueryResult)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineQueryResultCachedSticker>(){});
            }
        }
        return null;
    }
}

