/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.adminrights.ChatAdministratorRights;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.SwitchInlineQueryChosenChat;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class KeyboardButtonRequestChat
implements Validable,
BotApiObject {
    private static final String REQUESTID_FIELD = "request_id";
    private static final String CHATISCHANNEL_FIELD = "chat_is_channel";
    private static final String CHATISFORUM_FIELD = "chat_is_forum";
    private static final String CHATHASUSERNAME_FIELD = "chat_has_username";
    private static final String CHATISCREATED_FIELD = "chat_is_created";
    private static final String USERADMINISTRATORRIGHTS_FIELD = "user_administrator_rights";
    private static final String BOTADMINISTRATORRIGHTS_FIELD = "bot_administrator_rights";
    private static final String BOTISMEMBER_FIELD = "bot_is_member";
    private static final String SWITCH_INLINE_QUERY_CHOSEN_CHAT_FIELD = "switch_inline_query_chosen_chat";
    @JsonProperty(value="request_id")
    @NonNull
    private String requestId;
    @JsonProperty(value="chat_is_channel")
    @NonNull
    private Boolean chatIsChannel;
    @JsonProperty(value="chat_is_forum")
    private Boolean chatIsForum;
    @JsonProperty(value="chat_has_username")
    private Boolean chatHasUsername;
    @JsonProperty(value="chat_is_created")
    private Boolean chatIsCreated;
    @JsonProperty(value="user_administrator_rights")
    private ChatAdministratorRights userAdministratorRights;
    @JsonProperty(value="bot_administrator_rights")
    private ChatAdministratorRights botAdministratorRights;
    @JsonProperty(value="bot_is_member")
    private Boolean botIsMember;
    @JsonProperty(value="switch_inline_query_chosen_chat")
    private SwitchInlineQueryChosenChat switchInlineQueryChosenChat;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.requestId.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.userAdministratorRights != null) {
            this.userAdministratorRights.validate();
        }
        if (this.botAdministratorRights != null) {
            this.botAdministratorRights.validate();
        }
        if (this.switchInlineQueryChosenChat != null) {
            this.switchInlineQueryChosenChat.validate();
        }
    }

    public static KeyboardButtonRequestChatBuilder builder() {
        return new KeyboardButtonRequestChatBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButtonRequestChat)) {
            return false;
        }
        KeyboardButtonRequestChat other = (KeyboardButtonRequestChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$chatIsChannel = this.getChatIsChannel();
        Boolean other$chatIsChannel = other.getChatIsChannel();
        if (this$chatIsChannel == null ? other$chatIsChannel != null : !((Object)this$chatIsChannel).equals(other$chatIsChannel)) {
            return false;
        }
        Boolean this$chatIsForum = this.getChatIsForum();
        Boolean other$chatIsForum = other.getChatIsForum();
        if (this$chatIsForum == null ? other$chatIsForum != null : !((Object)this$chatIsForum).equals(other$chatIsForum)) {
            return false;
        }
        Boolean this$chatHasUsername = this.getChatHasUsername();
        Boolean other$chatHasUsername = other.getChatHasUsername();
        if (this$chatHasUsername == null ? other$chatHasUsername != null : !((Object)this$chatHasUsername).equals(other$chatHasUsername)) {
            return false;
        }
        Boolean this$chatIsCreated = this.getChatIsCreated();
        Boolean other$chatIsCreated = other.getChatIsCreated();
        if (this$chatIsCreated == null ? other$chatIsCreated != null : !((Object)this$chatIsCreated).equals(other$chatIsCreated)) {
            return false;
        }
        Boolean this$botIsMember = this.getBotIsMember();
        Boolean other$botIsMember = other.getBotIsMember();
        if (this$botIsMember == null ? other$botIsMember != null : !((Object)this$botIsMember).equals(other$botIsMember)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        ChatAdministratorRights this$userAdministratorRights = this.getUserAdministratorRights();
        ChatAdministratorRights other$userAdministratorRights = other.getUserAdministratorRights();
        if (this$userAdministratorRights == null ? other$userAdministratorRights != null : !((Object)this$userAdministratorRights).equals(other$userAdministratorRights)) {
            return false;
        }
        ChatAdministratorRights this$botAdministratorRights = this.getBotAdministratorRights();
        ChatAdministratorRights other$botAdministratorRights = other.getBotAdministratorRights();
        if (this$botAdministratorRights == null ? other$botAdministratorRights != null : !((Object)this$botAdministratorRights).equals(other$botAdministratorRights)) {
            return false;
        }
        SwitchInlineQueryChosenChat this$switchInlineQueryChosenChat = this.getSwitchInlineQueryChosenChat();
        SwitchInlineQueryChosenChat other$switchInlineQueryChosenChat = other.getSwitchInlineQueryChosenChat();
        return !(this$switchInlineQueryChosenChat == null ? other$switchInlineQueryChosenChat != null : !((Object)this$switchInlineQueryChosenChat).equals(other$switchInlineQueryChosenChat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButtonRequestChat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $chatIsChannel = this.getChatIsChannel();
        result = result * 59 + ($chatIsChannel == null ? 43 : ((Object)$chatIsChannel).hashCode());
        Boolean $chatIsForum = this.getChatIsForum();
        result = result * 59 + ($chatIsForum == null ? 43 : ((Object)$chatIsForum).hashCode());
        Boolean $chatHasUsername = this.getChatHasUsername();
        result = result * 59 + ($chatHasUsername == null ? 43 : ((Object)$chatHasUsername).hashCode());
        Boolean $chatIsCreated = this.getChatIsCreated();
        result = result * 59 + ($chatIsCreated == null ? 43 : ((Object)$chatIsCreated).hashCode());
        Boolean $botIsMember = this.getBotIsMember();
        result = result * 59 + ($botIsMember == null ? 43 : ((Object)$botIsMember).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        ChatAdministratorRights $userAdministratorRights = this.getUserAdministratorRights();
        result = result * 59 + ($userAdministratorRights == null ? 43 : ((Object)$userAdministratorRights).hashCode());
        ChatAdministratorRights $botAdministratorRights = this.getBotAdministratorRights();
        result = result * 59 + ($botAdministratorRights == null ? 43 : ((Object)$botAdministratorRights).hashCode());
        SwitchInlineQueryChosenChat $switchInlineQueryChosenChat = this.getSwitchInlineQueryChosenChat();
        result = result * 59 + ($switchInlineQueryChosenChat == null ? 43 : ((Object)$switchInlineQueryChosenChat).hashCode());
        return result;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    @NonNull
    public Boolean getChatIsChannel() {
        return this.chatIsChannel;
    }

    public Boolean getChatIsForum() {
        return this.chatIsForum;
    }

    public Boolean getChatHasUsername() {
        return this.chatHasUsername;
    }

    public Boolean getChatIsCreated() {
        return this.chatIsCreated;
    }

    public ChatAdministratorRights getUserAdministratorRights() {
        return this.userAdministratorRights;
    }

    public ChatAdministratorRights getBotAdministratorRights() {
        return this.botAdministratorRights;
    }

    public Boolean getBotIsMember() {
        return this.botIsMember;
    }

    public SwitchInlineQueryChosenChat getSwitchInlineQueryChosenChat() {
        return this.switchInlineQueryChosenChat;
    }

    @JsonProperty(value="request_id")
    public void setRequestId(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    @JsonProperty(value="chat_is_channel")
    public void setChatIsChannel(@NonNull Boolean chatIsChannel) {
        if (chatIsChannel == null) {
            throw new NullPointerException("chatIsChannel is marked non-null but is null");
        }
        this.chatIsChannel = chatIsChannel;
    }

    @JsonProperty(value="chat_is_forum")
    public void setChatIsForum(Boolean chatIsForum) {
        this.chatIsForum = chatIsForum;
    }

    @JsonProperty(value="chat_has_username")
    public void setChatHasUsername(Boolean chatHasUsername) {
        this.chatHasUsername = chatHasUsername;
    }

    @JsonProperty(value="chat_is_created")
    public void setChatIsCreated(Boolean chatIsCreated) {
        this.chatIsCreated = chatIsCreated;
    }

    @JsonProperty(value="user_administrator_rights")
    public void setUserAdministratorRights(ChatAdministratorRights userAdministratorRights) {
        this.userAdministratorRights = userAdministratorRights;
    }

    @JsonProperty(value="bot_administrator_rights")
    public void setBotAdministratorRights(ChatAdministratorRights botAdministratorRights) {
        this.botAdministratorRights = botAdministratorRights;
    }

    @JsonProperty(value="bot_is_member")
    public void setBotIsMember(Boolean botIsMember) {
        this.botIsMember = botIsMember;
    }

    @JsonProperty(value="switch_inline_query_chosen_chat")
    public void setSwitchInlineQueryChosenChat(SwitchInlineQueryChosenChat switchInlineQueryChosenChat) {
        this.switchInlineQueryChosenChat = switchInlineQueryChosenChat;
    }

    public String toString() {
        return "KeyboardButtonRequestChat(requestId=" + this.getRequestId() + ", chatIsChannel=" + this.getChatIsChannel() + ", chatIsForum=" + this.getChatIsForum() + ", chatHasUsername=" + this.getChatHasUsername() + ", chatIsCreated=" + this.getChatIsCreated() + ", userAdministratorRights=" + this.getUserAdministratorRights() + ", botAdministratorRights=" + this.getBotAdministratorRights() + ", botIsMember=" + this.getBotIsMember() + ", switchInlineQueryChosenChat=" + this.getSwitchInlineQueryChosenChat() + ")";
    }

    public KeyboardButtonRequestChat() {
    }

    public KeyboardButtonRequestChat(@NonNull String requestId, @NonNull Boolean chatIsChannel) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        if (chatIsChannel == null) {
            throw new NullPointerException("chatIsChannel is marked non-null but is null");
        }
        this.requestId = requestId;
        this.chatIsChannel = chatIsChannel;
    }

    public KeyboardButtonRequestChat(@NonNull String requestId, @NonNull Boolean chatIsChannel, Boolean chatIsForum, Boolean chatHasUsername, Boolean chatIsCreated, ChatAdministratorRights userAdministratorRights, ChatAdministratorRights botAdministratorRights, Boolean botIsMember, SwitchInlineQueryChosenChat switchInlineQueryChosenChat) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        if (chatIsChannel == null) {
            throw new NullPointerException("chatIsChannel is marked non-null but is null");
        }
        this.requestId = requestId;
        this.chatIsChannel = chatIsChannel;
        this.chatIsForum = chatIsForum;
        this.chatHasUsername = chatHasUsername;
        this.chatIsCreated = chatIsCreated;
        this.userAdministratorRights = userAdministratorRights;
        this.botAdministratorRights = botAdministratorRights;
        this.botIsMember = botIsMember;
        this.switchInlineQueryChosenChat = switchInlineQueryChosenChat;
    }

    public static class KeyboardButtonRequestChatBuilder {
        private String requestId;
        private Boolean chatIsChannel;
        private Boolean chatIsForum;
        private Boolean chatHasUsername;
        private Boolean chatIsCreated;
        private ChatAdministratorRights userAdministratorRights;
        private ChatAdministratorRights botAdministratorRights;
        private Boolean botIsMember;
        private SwitchInlineQueryChosenChat switchInlineQueryChosenChat;

        KeyboardButtonRequestChatBuilder() {
        }

        @JsonProperty(value="request_id")
        public KeyboardButtonRequestChatBuilder requestId(@NonNull String requestId) {
            if (requestId == null) {
                throw new NullPointerException("requestId is marked non-null but is null");
            }
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="chat_is_channel")
        public KeyboardButtonRequestChatBuilder chatIsChannel(@NonNull Boolean chatIsChannel) {
            if (chatIsChannel == null) {
                throw new NullPointerException("chatIsChannel is marked non-null but is null");
            }
            this.chatIsChannel = chatIsChannel;
            return this;
        }

        @JsonProperty(value="chat_is_forum")
        public KeyboardButtonRequestChatBuilder chatIsForum(Boolean chatIsForum) {
            this.chatIsForum = chatIsForum;
            return this;
        }

        @JsonProperty(value="chat_has_username")
        public KeyboardButtonRequestChatBuilder chatHasUsername(Boolean chatHasUsername) {
            this.chatHasUsername = chatHasUsername;
            return this;
        }

        @JsonProperty(value="chat_is_created")
        public KeyboardButtonRequestChatBuilder chatIsCreated(Boolean chatIsCreated) {
            this.chatIsCreated = chatIsCreated;
            return this;
        }

        @JsonProperty(value="user_administrator_rights")
        public KeyboardButtonRequestChatBuilder userAdministratorRights(ChatAdministratorRights userAdministratorRights) {
            this.userAdministratorRights = userAdministratorRights;
            return this;
        }

        @JsonProperty(value="bot_administrator_rights")
        public KeyboardButtonRequestChatBuilder botAdministratorRights(ChatAdministratorRights botAdministratorRights) {
            this.botAdministratorRights = botAdministratorRights;
            return this;
        }

        @JsonProperty(value="bot_is_member")
        public KeyboardButtonRequestChatBuilder botIsMember(Boolean botIsMember) {
            this.botIsMember = botIsMember;
            return this;
        }

        @JsonProperty(value="switch_inline_query_chosen_chat")
        public KeyboardButtonRequestChatBuilder switchInlineQueryChosenChat(SwitchInlineQueryChosenChat switchInlineQueryChosenChat) {
            this.switchInlineQueryChosenChat = switchInlineQueryChosenChat;
            return this;
        }

        public KeyboardButtonRequestChat build() {
            return new KeyboardButtonRequestChat(this.requestId, this.chatIsChannel, this.chatIsForum, this.chatHasUsername, this.chatIsCreated, this.userAdministratorRights, this.botAdministratorRights, this.botIsMember, this.switchInlineQueryChosenChat);
        }

        public String toString() {
            return "KeyboardButtonRequestChat.KeyboardButtonRequestChatBuilder(requestId=" + this.requestId + ", chatIsChannel=" + this.chatIsChannel + ", chatIsForum=" + this.chatIsForum + ", chatHasUsername=" + this.chatHasUsername + ", chatIsCreated=" + this.chatIsCreated + ", userAdministratorRights=" + this.userAdministratorRights + ", botAdministratorRights=" + this.botAdministratorRights + ", botIsMember=" + this.botIsMember + ", switchInlineQueryChosenChat=" + this.switchInlineQueryChosenChat + ")";
        }
    }
}

