/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SetStickerEmojiListBuilderImpl.class)
public class SetStickerEmojiList
extends BotApiMethodBoolean {
    public static final String PATH = "setStickerEmojiList";
    public static final String STICKER_FIELD = "sticker";
    public static final String EMOJI_LIST_FIELD = "emoji_list";
    @JsonProperty(value="sticker")
    @NonNull
    private String sticker;
    @JsonProperty(value="emoji_list")
    @NonNull
    private List<String> emojiList;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
        if (this.emojiList.isEmpty() || this.emojiList.size() > 20) {
            throw new TelegramApiValidationException("Emoji list must have between 1 and 20 items", this);
        }
    }

    protected SetStickerEmojiList(SetStickerEmojiListBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        List<Object> emojiList = switch (b.emojiList == null ? 0 : b.emojiList.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.emojiList.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.emojiList));
        };
        this.emojiList = emojiList;
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
    }

    public static SetStickerEmojiListBuilder<?, ?> builder() {
        return new SetStickerEmojiListBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetStickerEmojiList)) {
            return false;
        }
        SetStickerEmojiList other = (SetStickerEmojiList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sticker = this.getSticker();
        String other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !this$sticker.equals(other$sticker)) {
            return false;
        }
        List<String> this$emojiList = this.getEmojiList();
        List<String> other$emojiList = other.getEmojiList();
        return !(this$emojiList == null ? other$emojiList != null : !((Object)this$emojiList).equals(other$emojiList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetStickerEmojiList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : $sticker.hashCode());
        List<String> $emojiList = this.getEmojiList();
        result = result * 59 + ($emojiList == null ? 43 : ((Object)$emojiList).hashCode());
        return result;
    }

    @NonNull
    public String getSticker() {
        return this.sticker;
    }

    @NonNull
    public List<String> getEmojiList() {
        return this.emojiList;
    }

    @JsonProperty(value="sticker")
    public void setSticker(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @JsonProperty(value="emoji_list")
    public void setEmojiList(@NonNull List<String> emojiList) {
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.emojiList = emojiList;
    }

    public String toString() {
        return "SetStickerEmojiList(sticker=" + this.getSticker() + ", emojiList=" + this.getEmojiList() + ")";
    }

    public SetStickerEmojiList(@NonNull String sticker, @NonNull List<String> emojiList) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.sticker = sticker;
        this.emojiList = emojiList;
    }

    public static abstract class SetStickerEmojiListBuilder<C extends SetStickerEmojiList, B extends SetStickerEmojiListBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private String sticker;
        private ArrayList<String> emojiList;

        @JsonProperty(value="sticker")
        public B sticker(@NonNull String sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return (B)this.self();
        }

        public B emoji(String emoji) {
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.add(emoji);
            return (B)this.self();
        }

        @JsonProperty(value="emoji_list")
        public B emojiList(Collection<? extends String> emojiList) {
            if (emojiList == null) {
                throw new NullPointerException("emojiList cannot be null");
            }
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.addAll(emojiList);
            return (B)this.self();
        }

        public B clearEmojiList() {
            if (this.emojiList != null) {
                this.emojiList.clear();
            }
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SetStickerEmojiList.SetStickerEmojiListBuilder(super=" + super.toString() + ", sticker=" + this.sticker + ", emojiList=" + this.emojiList + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SetStickerEmojiListBuilderImpl
    extends SetStickerEmojiListBuilder<SetStickerEmojiList, SetStickerEmojiListBuilderImpl> {
        private SetStickerEmojiListBuilderImpl() {
        }

        @Override
        protected SetStickerEmojiListBuilderImpl self() {
            return this;
        }

        @Override
        public SetStickerEmojiList build() {
            return new SetStickerEmojiList(this);
        }
    }
}

