/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.business;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.Location;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=BusinessLocationBuilderImpl.class)
public class BusinessLocation
implements BotApiObject {
    private static final String ADDRESS_FIELD = "address";
    private static final String LOCATION_FIELD = "location";
    @JsonProperty(value="address")
    @NonNull
    private String address;
    @JsonProperty(value="location")
    private Location location;

    protected BusinessLocation(BusinessLocationBuilder<?, ?> b) {
        this.address = b.address;
        if (this.address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.location = b.location;
    }

    public static BusinessLocationBuilder<?, ?> builder() {
        return new BusinessLocationBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessLocation)) {
            return false;
        }
        BusinessLocation other = (BusinessLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="address")
    public void setAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        return "BusinessLocation(address=" + this.getAddress() + ", location=" + this.getLocation() + ")";
    }

    public BusinessLocation(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    public BusinessLocation(@NonNull String address, Location location) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
        this.location = location;
    }

    public static abstract class BusinessLocationBuilder<C extends BusinessLocation, B extends BusinessLocationBuilder<C, B>> {
        private String address;
        private Location location;

        @JsonProperty(value="address")
        public B address(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this.self();
        }

        @JsonProperty(value="location")
        public B location(Location location) {
            this.location = location;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "BusinessLocation.BusinessLocationBuilder(address=" + this.address + ", location=" + this.location + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BusinessLocationBuilderImpl
    extends BusinessLocationBuilder<BusinessLocation, BusinessLocationBuilderImpl> {
        private BusinessLocationBuilderImpl() {
        }

        @Override
        protected BusinessLocationBuilderImpl self() {
            return this;
        }

        @Override
        public BusinessLocation build() {
            return new BusinessLocation(this);
        }
    }
}

