/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultMpeg4GifBuilderImpl.class)
public class InlineQueryResultMpeg4Gif
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String MPEG4URL_FIELD = "mpeg4_url";
    private static final String MPEG4WIDTH_FIELD = "mpeg4_width";
    private static final String MPEG4HEIGHT_FIELD = "mpeg4_height";
    private static final String THUMBNAIL_URL_FIELD = "thumbnail_url";
    private static final String THUMBNAIL_MIMETYPE_FIELD = "thumbnail_mime_type";
    private static final String TITLE_FIELD = "title";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String MPEG4_DURATION_FIELD = "mpeg4_duration";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "mpeg4_gif";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="mpeg4_url")
    @NonNull
    private String mpeg4Url;
    @JsonProperty(value="mpeg4_width")
    private Integer mpeg4Width;
    @JsonProperty(value="mpeg4_height")
    private Integer mpeg4Height;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="thumbnail_mime_type")
    private String thumbnailMimeType;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="mpeg4_duration")
    private Integer mpeg4Duration;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.mpeg4Url.isEmpty()) {
            throw new TelegramApiValidationException("Mpeg4Url parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.thumbnailMimeType != null && !VALIDTHUMBTYPES.contains(this.thumbnailMimeType)) {
            throw new TelegramApiValidationException("ThumbUrlType parameter must be one of \u201cimage/jpeg\u201d, \u201cimage/gif\u201d, or \u201cvideo/mp4\u201d", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    protected InlineQueryResultMpeg4Gif(InlineQueryResultMpeg4GifBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.mpeg4Url = b.mpeg4Url;
        if (this.mpeg4Url == null) {
            throw new NullPointerException("mpeg4Url is marked non-null but is null");
        }
        this.mpeg4Width = b.mpeg4Width;
        this.mpeg4Height = b.mpeg4Height;
        this.thumbnailUrl = b.thumbnailUrl;
        this.thumbnailMimeType = b.thumbnailMimeType;
        this.title = b.title;
        this.caption = b.caption;
        this.inputMessageContent = b.inputMessageContent;
        this.replyMarkup = b.replyMarkup;
        this.mpeg4Duration = b.mpeg4Duration;
        this.parseMode = b.parseMode;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
    }

    public static InlineQueryResultMpeg4GifBuilder<?, ?> builder() {
        return new InlineQueryResultMpeg4GifBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultMpeg4Gif)) {
            return false;
        }
        InlineQueryResultMpeg4Gif other = (InlineQueryResultMpeg4Gif)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$mpeg4Width = this.getMpeg4Width();
        Integer other$mpeg4Width = other.getMpeg4Width();
        if (this$mpeg4Width == null ? other$mpeg4Width != null : !((Object)this$mpeg4Width).equals(other$mpeg4Width)) {
            return false;
        }
        Integer this$mpeg4Height = this.getMpeg4Height();
        Integer other$mpeg4Height = other.getMpeg4Height();
        if (this$mpeg4Height == null ? other$mpeg4Height != null : !((Object)this$mpeg4Height).equals(other$mpeg4Height)) {
            return false;
        }
        Integer this$mpeg4Duration = this.getMpeg4Duration();
        Integer other$mpeg4Duration = other.getMpeg4Duration();
        if (this$mpeg4Duration == null ? other$mpeg4Duration != null : !((Object)this$mpeg4Duration).equals(other$mpeg4Duration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$mpeg4Url = this.getMpeg4Url();
        String other$mpeg4Url = other.getMpeg4Url();
        if (this$mpeg4Url == null ? other$mpeg4Url != null : !this$mpeg4Url.equals(other$mpeg4Url)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
            return false;
        }
        String this$thumbnailMimeType = this.getThumbnailMimeType();
        String other$thumbnailMimeType = other.getThumbnailMimeType();
        if (this$thumbnailMimeType == null ? other$thumbnailMimeType != null : !this$thumbnailMimeType.equals(other$thumbnailMimeType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultMpeg4Gif;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $mpeg4Width = this.getMpeg4Width();
        result = result * 59 + ($mpeg4Width == null ? 43 : ((Object)$mpeg4Width).hashCode());
        Integer $mpeg4Height = this.getMpeg4Height();
        result = result * 59 + ($mpeg4Height == null ? 43 : ((Object)$mpeg4Height).hashCode());
        Integer $mpeg4Duration = this.getMpeg4Duration();
        result = result * 59 + ($mpeg4Duration == null ? 43 : ((Object)$mpeg4Duration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $mpeg4Url = this.getMpeg4Url();
        result = result * 59 + ($mpeg4Url == null ? 43 : $mpeg4Url.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        String $thumbnailMimeType = this.getThumbnailMimeType();
        result = result * 59 + ($thumbnailMimeType == null ? 43 : $thumbnailMimeType.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getMpeg4Url() {
        return this.mpeg4Url;
    }

    public Integer getMpeg4Width() {
        return this.mpeg4Width;
    }

    public Integer getMpeg4Height() {
        return this.mpeg4Height;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getThumbnailMimeType() {
        return this.thumbnailMimeType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public Integer getMpeg4Duration() {
        return this.mpeg4Duration;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="mpeg4_url")
    public void setMpeg4Url(@NonNull String mpeg4Url) {
        if (mpeg4Url == null) {
            throw new NullPointerException("mpeg4Url is marked non-null but is null");
        }
        this.mpeg4Url = mpeg4Url;
    }

    @JsonProperty(value="mpeg4_width")
    public void setMpeg4Width(Integer mpeg4Width) {
        this.mpeg4Width = mpeg4Width;
    }

    @JsonProperty(value="mpeg4_height")
    public void setMpeg4Height(Integer mpeg4Height) {
        this.mpeg4Height = mpeg4Height;
    }

    @JsonProperty(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="thumbnail_mime_type")
    public void setThumbnailMimeType(String thumbnailMimeType) {
        this.thumbnailMimeType = thumbnailMimeType;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="mpeg4_duration")
    public void setMpeg4Duration(Integer mpeg4Duration) {
        this.mpeg4Duration = mpeg4Duration;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultMpeg4Gif(type=" + this.getType() + ", id=" + this.getId() + ", mpeg4Url=" + this.getMpeg4Url() + ", mpeg4Width=" + this.getMpeg4Width() + ", mpeg4Height=" + this.getMpeg4Height() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", thumbnailMimeType=" + this.getThumbnailMimeType() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", mpeg4Duration=" + this.getMpeg4Duration() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultMpeg4Gif(@NonNull String id, @NonNull String mpeg4Url) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (mpeg4Url == null) {
            throw new NullPointerException("mpeg4Url is marked non-null but is null");
        }
        this.id = id;
        this.mpeg4Url = mpeg4Url;
    }

    public InlineQueryResultMpeg4Gif(@NonNull String id, @NonNull String mpeg4Url, Integer mpeg4Width, Integer mpeg4Height, String thumbnailUrl, String thumbnailMimeType, String title, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, Integer mpeg4Duration, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (mpeg4Url == null) {
            throw new NullPointerException("mpeg4Url is marked non-null but is null");
        }
        this.id = id;
        this.mpeg4Url = mpeg4Url;
        this.mpeg4Width = mpeg4Width;
        this.mpeg4Height = mpeg4Height;
        this.thumbnailUrl = thumbnailUrl;
        this.thumbnailMimeType = thumbnailMimeType;
        this.title = title;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.mpeg4Duration = mpeg4Duration;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static abstract class InlineQueryResultMpeg4GifBuilder<C extends InlineQueryResultMpeg4Gif, B extends InlineQueryResultMpeg4GifBuilder<C, B>> {
        private String id;
        private String mpeg4Url;
        private Integer mpeg4Width;
        private Integer mpeg4Height;
        private String thumbnailUrl;
        private String thumbnailMimeType;
        private String title;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private Integer mpeg4Duration;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="mpeg4_url")
        public B mpeg4Url(@NonNull String mpeg4Url) {
            if (mpeg4Url == null) {
                throw new NullPointerException("mpeg4Url is marked non-null but is null");
            }
            this.mpeg4Url = mpeg4Url;
            return this.self();
        }

        @JsonProperty(value="mpeg4_width")
        public B mpeg4Width(Integer mpeg4Width) {
            this.mpeg4Width = mpeg4Width;
            return this.self();
        }

        @JsonProperty(value="mpeg4_height")
        public B mpeg4Height(Integer mpeg4Height) {
            this.mpeg4Height = mpeg4Height;
            return this.self();
        }

        @JsonProperty(value="thumbnail_url")
        public B thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this.self();
        }

        @JsonProperty(value="thumbnail_mime_type")
        public B thumbnailMimeType(String thumbnailMimeType) {
            this.thumbnailMimeType = thumbnailMimeType;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(String title) {
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="caption")
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="input_message_content")
        public B inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="mpeg4_duration")
        public B mpeg4Duration(Integer mpeg4Duration) {
            this.mpeg4Duration = mpeg4Duration;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this.self();
        }

        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineQueryResultMpeg4Gif.InlineQueryResultMpeg4GifBuilder(id=" + this.id + ", mpeg4Url=" + this.mpeg4Url + ", mpeg4Width=" + this.mpeg4Width + ", mpeg4Height=" + this.mpeg4Height + ", thumbnailUrl=" + this.thumbnailUrl + ", thumbnailMimeType=" + this.thumbnailMimeType + ", title=" + this.title + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", mpeg4Duration=" + this.mpeg4Duration + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineQueryResultMpeg4GifBuilderImpl
    extends InlineQueryResultMpeg4GifBuilder<InlineQueryResultMpeg4Gif, InlineQueryResultMpeg4GifBuilderImpl> {
        private InlineQueryResultMpeg4GifBuilderImpl() {
        }

        @Override
        protected InlineQueryResultMpeg4GifBuilderImpl self() {
            return this;
        }

        @Override
        public InlineQueryResultMpeg4Gif build() {
            return new InlineQueryResultMpeg4Gif(this);
        }
    }
}

