/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=LabeledPriceBuilderImpl.class)
public class LabeledPrice
implements Validable,
BotApiObject {
    private static final String LABEL_FIELD = "label";
    private static final String AMOUNT_FIELD = "amount";
    @JsonProperty(value="label")
    @NonNull
    private String label;
    @JsonProperty(value="amount")
    @NonNull
    private Integer amount;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.label == null || this.label.isEmpty()) {
            throw new TelegramApiValidationException("Label parameter can't be empty", this);
        }
        if (this.amount == null) {
            throw new TelegramApiValidationException("Amount parameter can't be empty", this);
        }
    }

    protected LabeledPrice(LabeledPriceBuilder<?, ?> b) {
        this.label = b.label;
        if (this.label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.amount = b.amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
    }

    public static LabeledPriceBuilder<?, ?> builder() {
        return new LabeledPriceBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabeledPrice)) {
            return false;
        }
        LabeledPrice other = (LabeledPrice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LabeledPrice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    @NonNull
    public Integer getAmount() {
        return this.amount;
    }

    @JsonProperty(value="label")
    public void setLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
    }

    @JsonProperty(value="amount")
    public void setAmount(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    public String toString() {
        return "LabeledPrice(label=" + this.getLabel() + ", amount=" + this.getAmount() + ")";
    }

    public LabeledPrice(@NonNull String label, @NonNull Integer amount) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.label = label;
        this.amount = amount;
    }

    public static abstract class LabeledPriceBuilder<C extends LabeledPrice, B extends LabeledPriceBuilder<C, B>> {
        private String label;
        private Integer amount;

        @JsonProperty(value="label")
        public B label(@NonNull String label) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            return this.self();
        }

        @JsonProperty(value="amount")
        public B amount(@NonNull Integer amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "LabeledPrice.LabeledPriceBuilder(label=" + this.label + ", amount=" + this.amount + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class LabeledPriceBuilderImpl
    extends LabeledPriceBuilder<LabeledPrice, LabeledPriceBuilderImpl> {
        private LabeledPriceBuilderImpl() {
        }

        @Override
        protected LabeledPriceBuilderImpl self() {
            return this;
        }

        @Override
        public LabeledPrice build() {
            return new LabeledPrice(this);
        }
    }
}

