/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardRow;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineKeyboardMarkupBuilderImpl.class)
public class InlineKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "inline_keyboard";
    @JsonProperty(value="inline_keyboard")
    @NonNull
    private List<InlineKeyboardRow> keyboard;

    @Override
    public void validate() throws TelegramApiValidationException {
        for (InlineKeyboardRow inlineKeyboardButtons : this.keyboard) {
            inlineKeyboardButtons.validate();
        }
    }

    protected InlineKeyboardMarkup(InlineKeyboardMarkupBuilder<?, ?> b) {
        List<Object> keyboard = switch (b.keyboard == null ? 0 : b.keyboard.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.keyboard.get(0));
            default -> Collections.unmodifiableList(new ArrayList<InlineKeyboardRow>(b.keyboard));
        };
        this.keyboard = keyboard;
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
    }

    public static InlineKeyboardMarkupBuilder<?, ?> builder() {
        return new InlineKeyboardMarkupBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineKeyboardMarkup)) {
            return false;
        }
        InlineKeyboardMarkup other = (InlineKeyboardMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<InlineKeyboardRow> this$keyboard = this.getKeyboard();
        List<InlineKeyboardRow> other$keyboard = other.getKeyboard();
        return !(this$keyboard == null ? other$keyboard != null : !((Object)this$keyboard).equals(other$keyboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineKeyboardMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<InlineKeyboardRow> $keyboard = this.getKeyboard();
        result = result * 59 + ($keyboard == null ? 43 : ((Object)$keyboard).hashCode());
        return result;
    }

    @NonNull
    public List<InlineKeyboardRow> getKeyboard() {
        return this.keyboard;
    }

    @JsonProperty(value="inline_keyboard")
    public void setKeyboard(@NonNull List<InlineKeyboardRow> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public String toString() {
        return "InlineKeyboardMarkup(keyboard=" + this.getKeyboard() + ")";
    }

    public InlineKeyboardMarkup(@NonNull List<InlineKeyboardRow> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public static abstract class InlineKeyboardMarkupBuilder<C extends InlineKeyboardMarkup, B extends InlineKeyboardMarkupBuilder<C, B>> {
        private ArrayList<InlineKeyboardRow> keyboard;

        public B keyboardRow(InlineKeyboardRow keyboardRow) {
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.add(keyboardRow);
            return this.self();
        }

        @JsonProperty(value="inline_keyboard")
        public B keyboard(Collection<? extends InlineKeyboardRow> keyboard) {
            if (keyboard == null) {
                throw new NullPointerException("keyboard cannot be null");
            }
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.addAll(keyboard);
            return this.self();
        }

        public B clearKeyboard() {
            if (this.keyboard != null) {
                this.keyboard.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InlineKeyboardMarkup.InlineKeyboardMarkupBuilder(keyboard=" + this.keyboard + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InlineKeyboardMarkupBuilderImpl
    extends InlineKeyboardMarkupBuilder<InlineKeyboardMarkup, InlineKeyboardMarkupBuilderImpl> {
        private InlineKeyboardMarkupBuilderImpl() {
        }

        @Override
        protected InlineKeyboardMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public InlineKeyboardMarkup build() {
            return new InlineKeyboardMarkup(this);
        }
    }
}

