/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=CreateChatSubscriptionInviteLinkBuilderImpl.class)
public class CreateChatSubscriptionInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "createChatSubscriptionInviteLink";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String SUBSCRIPTION_PERIOD_FIELD = "subscription_period";
    private static final String SUBSCRIPTION_PRICE_FIELD = "subscription_price";
    private static final String NAME_FIELD = "name";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="subscription_period")
    @NonNull
    private Integer subscriptionPeriod;
    @JsonProperty(value="subscription_price")
    @NonNull
    private Integer subscriptionPrice;
    @JsonProperty(value="name")
    private String name;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, ChatInviteLink.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.name != null && this.name.length() > 32) {
            throw new TelegramApiValidationException("Name must be between 0 and 32 characters", this);
        }
        if (this.subscriptionPeriod != 2592000) {
            throw new TelegramApiValidationException("SubscriptionPeriod must be 2592000", this);
        }
        if (this.subscriptionPrice < 1 || this.subscriptionPrice > 2500) {
            throw new TelegramApiValidationException("SubscriptionPrice must be between 1 and 2500", this);
        }
    }

    @Generated
    private static Integer $default$subscriptionPeriod() {
        return 2592000;
    }

    @Generated
    protected CreateChatSubscriptionInviteLink(CreateChatSubscriptionInviteLinkBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.subscriptionPeriod = b.subscriptionPeriod$set ? b.subscriptionPeriod$value : CreateChatSubscriptionInviteLink.$default$subscriptionPeriod();
        if (this.subscriptionPeriod == null) {
            throw new NullPointerException("subscriptionPeriod is marked non-null but is null");
        }
        this.subscriptionPrice = b.subscriptionPrice;
        if (this.subscriptionPrice == null) {
            throw new NullPointerException("subscriptionPrice is marked non-null but is null");
        }
        this.name = b.name;
    }

    @Generated
    public static CreateChatSubscriptionInviteLinkBuilder<?, ?> builder() {
        return new CreateChatSubscriptionInviteLinkBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateChatSubscriptionInviteLink)) {
            return false;
        }
        CreateChatSubscriptionInviteLink other = (CreateChatSubscriptionInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$subscriptionPeriod = this.getSubscriptionPeriod();
        Integer other$subscriptionPeriod = other.getSubscriptionPeriod();
        if (this$subscriptionPeriod == null ? other$subscriptionPeriod != null : !((Object)this$subscriptionPeriod).equals(other$subscriptionPeriod)) {
            return false;
        }
        Integer this$subscriptionPrice = this.getSubscriptionPrice();
        Integer other$subscriptionPrice = other.getSubscriptionPrice();
        if (this$subscriptionPrice == null ? other$subscriptionPrice != null : !((Object)this$subscriptionPrice).equals(other$subscriptionPrice)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateChatSubscriptionInviteLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $subscriptionPeriod = this.getSubscriptionPeriod();
        result = result * 59 + ($subscriptionPeriod == null ? 43 : ((Object)$subscriptionPeriod).hashCode());
        Integer $subscriptionPrice = this.getSubscriptionPrice();
        result = result * 59 + ($subscriptionPrice == null ? 43 : ((Object)$subscriptionPrice).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getSubscriptionPeriod() {
        return this.subscriptionPeriod;
    }

    @NonNull
    @Generated
    public Integer getSubscriptionPrice() {
        return this.subscriptionPrice;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="subscription_period")
    @Generated
    public void setSubscriptionPeriod(@NonNull Integer subscriptionPeriod) {
        if (subscriptionPeriod == null) {
            throw new NullPointerException("subscriptionPeriod is marked non-null but is null");
        }
        this.subscriptionPeriod = subscriptionPeriod;
    }

    @JsonProperty(value="subscription_price")
    @Generated
    public void setSubscriptionPrice(@NonNull Integer subscriptionPrice) {
        if (subscriptionPrice == null) {
            throw new NullPointerException("subscriptionPrice is marked non-null but is null");
        }
        this.subscriptionPrice = subscriptionPrice;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String toString() {
        return "CreateChatSubscriptionInviteLink(chatId=" + this.getChatId() + ", subscriptionPeriod=" + this.getSubscriptionPeriod() + ", subscriptionPrice=" + this.getSubscriptionPrice() + ", name=" + this.getName() + ")";
    }

    @Generated
    public CreateChatSubscriptionInviteLink(@NonNull String chatId, @NonNull Integer subscriptionPeriod, @NonNull Integer subscriptionPrice, String name) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (subscriptionPeriod == null) {
            throw new NullPointerException("subscriptionPeriod is marked non-null but is null");
        }
        if (subscriptionPrice == null) {
            throw new NullPointerException("subscriptionPrice is marked non-null but is null");
        }
        this.chatId = chatId;
        this.subscriptionPeriod = subscriptionPeriod;
        this.subscriptionPrice = subscriptionPrice;
        this.name = name;
    }

    @Generated
    public CreateChatSubscriptionInviteLink(@NonNull String chatId, @NonNull Integer subscriptionPeriod, @NonNull Integer subscriptionPrice) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (subscriptionPeriod == null) {
            throw new NullPointerException("subscriptionPeriod is marked non-null but is null");
        }
        if (subscriptionPrice == null) {
            throw new NullPointerException("subscriptionPrice is marked non-null but is null");
        }
        this.chatId = chatId;
        this.subscriptionPeriod = subscriptionPeriod;
        this.subscriptionPrice = subscriptionPrice;
    }

    public static abstract class CreateChatSubscriptionInviteLinkBuilder<C extends CreateChatSubscriptionInviteLink, B extends CreateChatSubscriptionInviteLinkBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<ChatInviteLink, C, B> {
        @Generated
        private String chatId;
        @Generated
        private boolean subscriptionPeriod$set;
        @Generated
        private Integer subscriptionPeriod$value;
        @Generated
        private Integer subscriptionPrice;
        @Generated
        private String name;

        public CreateChatSubscriptionInviteLinkBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="subscription_period")
        @Generated
        public B subscriptionPeriod(@NonNull Integer subscriptionPeriod) {
            if (subscriptionPeriod == null) {
                throw new NullPointerException("subscriptionPeriod is marked non-null but is null");
            }
            this.subscriptionPeriod$value = subscriptionPeriod;
            this.subscriptionPeriod$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="subscription_price")
        @Generated
        public B subscriptionPrice(@NonNull Integer subscriptionPrice) {
            if (subscriptionPrice == null) {
                throw new NullPointerException("subscriptionPrice is marked non-null but is null");
            }
            this.subscriptionPrice = subscriptionPrice;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateChatSubscriptionInviteLink.CreateChatSubscriptionInviteLinkBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", subscriptionPeriod$value=" + this.subscriptionPeriod$value + ", subscriptionPrice=" + this.subscriptionPrice + ", name=" + this.name + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CreateChatSubscriptionInviteLinkBuilderImpl
    extends CreateChatSubscriptionInviteLinkBuilder<CreateChatSubscriptionInviteLink, CreateChatSubscriptionInviteLinkBuilderImpl> {
        @Generated
        private CreateChatSubscriptionInviteLinkBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateChatSubscriptionInviteLinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateChatSubscriptionInviteLink build() {
            return new CreateChatSubscriptionInviteLink(this);
        }
    }
}

