/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=CreateNewStickerSetBuilderImpl.class)
public class CreateNewStickerSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "createNewStickerSet";
    public static final String USER_ID_FIELD = "user_id";
    public static final String STICKERS_FIELD = "stickers";
    public static final String NAME_FIELD = "name";
    public static final String TITLE_FIELD = "title";
    public static final String STICKER_TYPE_FIELD = "sticker_type";
    public static final String NEEDS_REPAINTING_FIELD = "needs_repainting";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    @NonNull
    private String title;
    @NonNull
    private List<InputSticker> stickers;
    private Boolean needsRepainting;
    private String stickerType;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Deprecated
    public String getStickerFormat() throws TelegramApiException {
        List<String> formats = this.stickers.stream().map(InputSticker::getFormat).distinct().toList();
        if (formats.size() > 1) {
            throw new TelegramApiException("Multiple format present in strickers");
        }
        return formats.isEmpty() ? null : formats.get(0);
    }

    @Deprecated
    public void setStickerFormat(String stickerFormat) throws TelegramApiException {
        String existingFormat = this.getStickerFormat();
        if (existingFormat == null || !existingFormat.equals(stickerFormat)) {
            this.stickers.forEach(x -> x.setFormat(stickerFormat));
        }
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name.isEmpty() || this.name.length() > 64) {
            throw new TelegramApiValidationException("name must be between 1 and 64 characters", this);
        }
        if (this.title.isEmpty() || this.title.length() > 64) {
            throw new TelegramApiValidationException("title must be between 1 and 64 characters", this);
        }
        if (!Arrays.asList("regular", "mask", "custom_emoji").contains(this.stickerType)) {
            throw new TelegramApiValidationException("Stickertype must be 'regular', 'mask' or 'custom_emoji'", this);
        }
        if (this.needsRepainting != null && !"custom_emoji".equals(this.stickerType)) {
            throw new TelegramApiValidationException("needsRepainting is only allowed with custom emojis", this);
        }
        if (this.stickers.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be empty", this);
        }
        for (InputSticker sticker : this.stickers) {
            sticker.validate();
        }
    }

    @Generated
    private static String $default$stickerType() {
        return "regular";
    }

    @Generated
    protected CreateNewStickerSet(CreateNewStickerSetBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        List<Object> stickers = switch (b.stickers == null ? 0 : b.stickers.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.stickers.get(0));
            default -> Collections.unmodifiableList(new ArrayList<InputSticker>(b.stickers));
        };
        this.stickers = stickers;
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        this.needsRepainting = b.needsRepainting;
        this.stickerType = b.stickerType$set ? b.stickerType$value : CreateNewStickerSet.$default$stickerType();
    }

    @Generated
    public static CreateNewStickerSetBuilder<?, ?> builder() {
        return new CreateNewStickerSetBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateNewStickerSet)) {
            return false;
        }
        CreateNewStickerSet other = (CreateNewStickerSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$needsRepainting = this.getNeedsRepainting();
        Boolean other$needsRepainting = other.getNeedsRepainting();
        if (this$needsRepainting == null ? other$needsRepainting != null : !((Object)this$needsRepainting).equals(other$needsRepainting)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<InputSticker> this$stickers = this.getStickers();
        List<InputSticker> other$stickers = other.getStickers();
        if (this$stickers == null ? other$stickers != null : !((Object)this$stickers).equals(other$stickers)) {
            return false;
        }
        String this$stickerType = this.getStickerType();
        String other$stickerType = other.getStickerType();
        return !(this$stickerType == null ? other$stickerType != null : !this$stickerType.equals(other$stickerType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateNewStickerSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $needsRepainting = this.getNeedsRepainting();
        result = result * 59 + ($needsRepainting == null ? 43 : ((Object)$needsRepainting).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<InputSticker> $stickers = this.getStickers();
        result = result * 59 + ($stickers == null ? 43 : ((Object)$stickers).hashCode());
        String $stickerType = this.getStickerType();
        result = result * 59 + ($stickerType == null ? 43 : $stickerType.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @NonNull
    @Generated
    public List<InputSticker> getStickers() {
        return this.stickers;
    }

    @Generated
    public Boolean getNeedsRepainting() {
        return this.needsRepainting;
    }

    @Generated
    public String getStickerType() {
        return this.stickerType;
    }

    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @Generated
    public void setStickers(@NonNull List<InputSticker> stickers) {
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        this.stickers = stickers;
    }

    @Generated
    public void setNeedsRepainting(Boolean needsRepainting) {
        this.needsRepainting = needsRepainting;
    }

    @Generated
    public void setStickerType(String stickerType) {
        this.stickerType = stickerType;
    }

    @Generated
    public String toString() {
        return "CreateNewStickerSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", stickers=" + this.getStickers() + ", needsRepainting=" + this.getNeedsRepainting() + ", stickerType=" + this.getStickerType() + ")";
    }

    @Generated
    public CreateNewStickerSet(@NonNull Long userId, @NonNull String name, @NonNull String title, @NonNull List<InputSticker> stickers) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.title = title;
        this.stickers = stickers;
        this.stickerType = CreateNewStickerSet.$default$stickerType();
    }

    @Generated
    public CreateNewStickerSet(@NonNull Long userId, @NonNull String name, @NonNull String title, @NonNull List<InputSticker> stickers, Boolean needsRepainting, String stickerType) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.title = title;
        this.stickers = stickers;
        this.needsRepainting = needsRepainting;
        this.stickerType = stickerType;
    }

    @Generated
    public static abstract class CreateNewStickerSetBuilder<C extends CreateNewStickerSet, B extends CreateNewStickerSetBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<Boolean, C, B> {
        @Generated
        private Long userId;
        @Generated
        private String name;
        @Generated
        private String title;
        @Generated
        private ArrayList<InputSticker> stickers;
        @Generated
        private Boolean needsRepainting;
        @Generated
        private boolean stickerType$set;
        @Generated
        private String stickerType$value;

        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return (B)this.self();
        }

        @Generated
        public B sticker(InputSticker sticker) {
            if (this.stickers == null) {
                this.stickers = new ArrayList();
            }
            this.stickers.add(sticker);
            return (B)this.self();
        }

        @Generated
        public B stickers(Collection<? extends InputSticker> stickers) {
            if (stickers == null) {
                throw new NullPointerException("stickers cannot be null");
            }
            if (this.stickers == null) {
                this.stickers = new ArrayList();
            }
            this.stickers.addAll(stickers);
            return (B)this.self();
        }

        @Generated
        public B clearStickers() {
            if (this.stickers != null) {
                this.stickers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B needsRepainting(Boolean needsRepainting) {
            this.needsRepainting = needsRepainting;
            return (B)this.self();
        }

        @Generated
        public B stickerType(String stickerType) {
            this.stickerType$value = stickerType;
            this.stickerType$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateNewStickerSet.CreateNewStickerSetBuilder(super=" + super.toString() + ", userId=" + this.userId + ", name=" + this.name + ", title=" + this.title + ", stickers=" + this.stickers + ", needsRepainting=" + this.needsRepainting + ", stickerType$value=" + this.stickerType$value + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CreateNewStickerSetBuilderImpl
    extends CreateNewStickerSetBuilder<CreateNewStickerSet, CreateNewStickerSetBuilderImpl> {
        @Generated
        private CreateNewStickerSetBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateNewStickerSetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateNewStickerSet build() {
            return new CreateNewStickerSet(this);
        }
    }
}

