/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import lombok.Generated;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;

public class File
implements BotApiObject {
    private static final String FILEID_FIELD = "file_id";
    private static final String FILEUNIQUEID_FIELD = "file_unique_id";
    private static final String FILE_SIZE_FIELD = "file_size";
    private static final String FILE_PATH_FIELD = "file_path";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="file_unique_id")
    private String fileUniqueId;
    @JsonProperty(value="file_size")
    private Long fileSize;
    @JsonProperty(value="file_path")
    private String filePath;

    public String getFileUrl(String botToken) {
        return File.getFileUrl(botToken, this.filePath);
    }

    public static String getFileUrl(String botToken, String filePath) {
        if (botToken == null || botToken.isEmpty()) {
            throw new InvalidParameterException("Bot token can't be empty");
        }
        return MessageFormat.format("https://api.telegram.org/file/bot{0}/{1}", botToken, filePath);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof File)) {
            return false;
        }
        File other = (File)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fileSize = this.getFileSize();
        Long other$fileSize = other.getFileSize();
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        String this$fileId = this.getFileId();
        String other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
            return false;
        }
        String this$fileUniqueId = this.getFileUniqueId();
        String other$fileUniqueId = other.getFileUniqueId();
        if (this$fileUniqueId == null ? other$fileUniqueId != null : !this$fileUniqueId.equals(other$fileUniqueId)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof File;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fileSize = this.getFileSize();
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        String $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        String $fileUniqueId = this.getFileUniqueId();
        result = result * 59 + ($fileUniqueId == null ? 43 : $fileUniqueId.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        return result;
    }

    @Generated
    public String getFileId() {
        return this.fileId;
    }

    @Generated
    public String getFileUniqueId() {
        return this.fileUniqueId;
    }

    @Generated
    public Long getFileSize() {
        return this.fileSize;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @JsonProperty(value="file_id")
    @Generated
    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @JsonProperty(value="file_unique_id")
    @Generated
    public void setFileUniqueId(String fileUniqueId) {
        this.fileUniqueId = fileUniqueId;
    }

    @JsonProperty(value="file_size")
    @Generated
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    @JsonProperty(value="file_path")
    @Generated
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Generated
    public String toString() {
        return "File(fileId=" + this.getFileId() + ", fileUniqueId=" + this.getFileUniqueId() + ", fileSize=" + this.getFileSize() + ", filePath=" + this.getFilePath() + ")";
    }

    @Generated
    public File() {
    }

    @Generated
    public File(String fileId, String fileUniqueId, Long fileSize, String filePath) {
        this.fileId = fileId;
        this.fileUniqueId = fileUniqueId;
        this.fileSize = fileSize;
        this.filePath = filePath;
    }
}

