/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppInfo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InlineQueryResultsButtonBuilderImpl.class)
public class InlineQueryResultsButton
implements Validable,
BotApiObject {
    private static final String TEXT_FIELD = "text";
    private static final String WEB_APP_FIELD = "web_app";
    private static final String START_PARAMETER_FIELD = "start_parameter";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="web_app")
    private WebAppInfo webApp;
    @JsonProperty(value="start_parameter")
    private String startParameter;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text can't be empty", this);
        }
        if (this.startParameter != null && this.webApp != null) {
            throw new TelegramApiValidationException("Only one of Start Parameter or Web App is allowed", this);
        }
        if (this.startParameter != null) {
            if (this.startParameter.isEmpty() || this.startParameter.length() > 64) {
                throw new TelegramApiValidationException("SwitchPmParameter can't be empty or longer than 64 chars", this);
            }
            if (!Pattern.matches("[A-Za-z0-9_\\-]+", this.startParameter.trim())) {
                throw new TelegramApiValidationException("SwitchPmParameter only allows A-Z, a-z, 0-9, _ and - characters", this);
            }
        }
        if (this.webApp != null) {
            this.webApp.validate();
        }
    }

    @Generated
    protected InlineQueryResultsButton(InlineQueryResultsButtonBuilder<?, ?> b) {
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.webApp = b.webApp;
        this.startParameter = b.startParameter;
    }

    @Generated
    public static InlineQueryResultsButtonBuilder<?, ?> builder() {
        return new InlineQueryResultsButtonBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultsButton)) {
            return false;
        }
        InlineQueryResultsButton other = (InlineQueryResultsButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        WebAppInfo this$webApp = this.getWebApp();
        WebAppInfo other$webApp = other.getWebApp();
        if (this$webApp == null ? other$webApp != null : !((Object)this$webApp).equals(other$webApp)) {
            return false;
        }
        String this$startParameter = this.getStartParameter();
        String other$startParameter = other.getStartParameter();
        return !(this$startParameter == null ? other$startParameter != null : !this$startParameter.equals(other$startParameter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultsButton;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        WebAppInfo $webApp = this.getWebApp();
        result = result * 59 + ($webApp == null ? 43 : ((Object)$webApp).hashCode());
        String $startParameter = this.getStartParameter();
        result = result * 59 + ($startParameter == null ? 43 : $startParameter.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public WebAppInfo getWebApp() {
        return this.webApp;
    }

    @Generated
    public String getStartParameter() {
        return this.startParameter;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="web_app")
    @Generated
    public void setWebApp(WebAppInfo webApp) {
        this.webApp = webApp;
    }

    @JsonProperty(value="start_parameter")
    @Generated
    public void setStartParameter(String startParameter) {
        this.startParameter = startParameter;
    }

    @Generated
    public String toString() {
        return "InlineQueryResultsButton(text=" + this.getText() + ", webApp=" + this.getWebApp() + ", startParameter=" + this.getStartParameter() + ")";
    }

    @Generated
    public InlineQueryResultsButton(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @Generated
    public InlineQueryResultsButton(@NonNull String text, WebAppInfo webApp, String startParameter) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.webApp = webApp;
        this.startParameter = startParameter;
    }

    @Generated
    public static abstract class InlineQueryResultsButtonBuilder<C extends InlineQueryResultsButton, B extends InlineQueryResultsButtonBuilder<C, B>> {
        @Generated
        private String text;
        @Generated
        private WebAppInfo webApp;
        @Generated
        private String startParameter;

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="web_app")
        @Generated
        public B webApp(WebAppInfo webApp) {
            this.webApp = webApp;
            return this.self();
        }

        @JsonProperty(value="start_parameter")
        @Generated
        public B startParameter(String startParameter) {
            this.startParameter = startParameter;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InlineQueryResultsButton.InlineQueryResultsButtonBuilder(text=" + this.text + ", webApp=" + this.webApp + ", startParameter=" + this.startParameter + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InlineQueryResultsButtonBuilderImpl
    extends InlineQueryResultsButtonBuilder<InlineQueryResultsButton, InlineQueryResultsButtonBuilderImpl> {
        @Generated
        private InlineQueryResultsButtonBuilderImpl() {
        }

        @Override
        @Generated
        protected InlineQueryResultsButtonBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InlineQueryResultsButton build() {
            return new InlineQueryResultsButton(this);
        }
    }
}

