/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.File;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=UploadStickerFileBuilderImpl.class)
public class UploadStickerFile
extends PartialBotApiMethod<File> {
    public static final String PATH = "uploadStickerFile";
    public static final String USERID_FIELD = "user_id";
    public static final String STICKER_FORMAT_FIELD = "sticker_format";
    public static final String STICKER_FIELD = "sticker";
    @NonNull
    private Long userId;
    @NonNull
    private String stickerFormat;
    @NonNull
    private InputFile sticker;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public File deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, File.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredUserId(this.userId, this);
        if (this.stickerFormat.isEmpty() || !Arrays.asList("static", "animated", "video").contains(this.stickerFormat)) {
            throw new TelegramApiValidationException("Sticker Format must be one of 'static', 'animated', 'video'", this);
        }
        this.sticker.validate();
    }

    @Generated
    protected UploadStickerFile(UploadStickerFileBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.stickerFormat = b.stickerFormat;
        if (this.stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
    }

    @Generated
    public static UploadStickerFileBuilder<?, ?> builder() {
        return new UploadStickerFileBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadStickerFile)) {
            return false;
        }
        UploadStickerFile other = (UploadStickerFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$stickerFormat = this.getStickerFormat();
        String other$stickerFormat = other.getStickerFormat();
        if (this$stickerFormat == null ? other$stickerFormat != null : !this$stickerFormat.equals(other$stickerFormat)) {
            return false;
        }
        InputFile this$sticker = this.getSticker();
        InputFile other$sticker = other.getSticker();
        return !(this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UploadStickerFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $stickerFormat = this.getStickerFormat();
        result = result * 59 + ($stickerFormat == null ? 43 : $stickerFormat.hashCode());
        InputFile $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public String getStickerFormat() {
        return this.stickerFormat;
    }

    @NonNull
    @Generated
    public InputFile getSticker() {
        return this.sticker;
    }

    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public void setStickerFormat(@NonNull String stickerFormat) {
        if (stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        this.stickerFormat = stickerFormat;
    }

    @Generated
    public void setSticker(@NonNull InputFile sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @Generated
    public String toString() {
        return "UploadStickerFile(userId=" + this.getUserId() + ", stickerFormat=" + this.getStickerFormat() + ", sticker=" + this.getSticker() + ")";
    }

    @Generated
    public UploadStickerFile(@NonNull Long userId, @NonNull String stickerFormat, @NonNull InputFile sticker) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.userId = userId;
        this.stickerFormat = stickerFormat;
        this.sticker = sticker;
    }

    @Generated
    public static abstract class UploadStickerFileBuilder<C extends UploadStickerFile, B extends UploadStickerFileBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<File, C, B> {
        @Generated
        private Long userId;
        @Generated
        private String stickerFormat;
        @Generated
        private InputFile sticker;

        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B stickerFormat(@NonNull String stickerFormat) {
            if (stickerFormat == null) {
                throw new NullPointerException("stickerFormat is marked non-null but is null");
            }
            this.stickerFormat = stickerFormat;
            return (B)this.self();
        }

        @Generated
        public B sticker(@NonNull InputFile sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UploadStickerFile.UploadStickerFileBuilder(super=" + super.toString() + ", userId=" + this.userId + ", stickerFormat=" + this.stickerFormat + ", sticker=" + this.sticker + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class UploadStickerFileBuilderImpl
    extends UploadStickerFileBuilder<UploadStickerFile, UploadStickerFileBuilderImpl> {
        @Generated
        private UploadStickerFileBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadStickerFileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadStickerFile build() {
            return new UploadStickerFile(this);
        }
    }
}

