/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.business;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class DeleteBusinessMessages
extends BotApiMethodBoolean {
    public static final String PATH = "deleteBusinessMessages";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty string", this);
        }
        if (this.messageIds.isEmpty()) {
            throw new TelegramApiValidationException("MessageIds parameter can't be empty", this);
        }
        if (this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter can't exceed 100 elements", this);
        }
        for (Integer messageId : this.messageIds) {
            if (messageId != null) continue;
            throw new TelegramApiValidationException("MessageIds parameter can't contain null elements", this);
        }
    }

    @Generated
    public static DeleteBusinessMessagesBuilder builder() {
        return new DeleteBusinessMessagesBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteBusinessMessages)) {
            return false;
        }
        DeleteBusinessMessages other = (DeleteBusinessMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteBusinessMessages;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="message_ids")
    @Generated
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    @Generated
    public String toString() {
        return "DeleteBusinessMessages(businessConnectionId=" + this.getBusinessConnectionId() + ", messageIds=" + this.getMessageIds() + ")";
    }

    @Generated
    public DeleteBusinessMessages() {
    }

    @Generated
    public DeleteBusinessMessages(@NonNull String businessConnectionId, @NonNull List<Integer> messageIds) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.messageIds = messageIds;
    }

    @Generated
    public static class DeleteBusinessMessagesBuilder {
        @Generated
        private String businessConnectionId;
        @Generated
        private List<Integer> messageIds;

        @Generated
        DeleteBusinessMessagesBuilder() {
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public DeleteBusinessMessagesBuilder businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @JsonProperty(value="message_ids")
        @Generated
        public DeleteBusinessMessagesBuilder messageIds(@NonNull List<Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds is marked non-null but is null");
            }
            this.messageIds = messageIds;
            return this;
        }

        @Generated
        public DeleteBusinessMessages build() {
            return new DeleteBusinessMessages(this.businessConnectionId, this.messageIds);
        }

        @Generated
        public String toString() {
            return "DeleteBusinessMessages.DeleteBusinessMessagesBuilder(businessConnectionId=" + this.businessConnectionId + ", messageIds=" + this.messageIds + ")";
        }
    }
}

