/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.business;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class TransferBusinessAccountStars
extends BotApiMethodBoolean {
    public static final String PATH = "transferBusinessAccountStars";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String STAR_COUNT_FIELD = "star_count";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="star_count")
    @NonNull
    private Integer starCount;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty", this);
        }
        if (this.starCount < 1 || this.starCount > 10000) {
            throw new TelegramApiValidationException("StarCount must be between 1 and 10000", this);
        }
    }

    @Generated
    public static TransferBusinessAccountStarsBuilder builder() {
        return new TransferBusinessAccountStarsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferBusinessAccountStars)) {
            return false;
        }
        TransferBusinessAccountStars other = (TransferBusinessAccountStars)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$starCount = this.getStarCount();
        Integer other$starCount = other.getStarCount();
        if (this$starCount == null ? other$starCount != null : !((Object)this$starCount).equals(other$starCount)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransferBusinessAccountStars;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $starCount = this.getStarCount();
        result = result * 59 + ($starCount == null ? 43 : ((Object)$starCount).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public Integer getStarCount() {
        return this.starCount;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="star_count")
    @Generated
    public void setStarCount(@NonNull Integer starCount) {
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.starCount = starCount;
    }

    @Generated
    public String toString() {
        return "TransferBusinessAccountStars(businessConnectionId=" + this.getBusinessConnectionId() + ", starCount=" + this.getStarCount() + ")";
    }

    @Generated
    public TransferBusinessAccountStars() {
    }

    @Generated
    public TransferBusinessAccountStars(@NonNull String businessConnectionId, @NonNull Integer starCount) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.starCount = starCount;
    }

    @Generated
    public static class TransferBusinessAccountStarsBuilder {
        @Generated
        private String businessConnectionId;
        @Generated
        private Integer starCount;

        @Generated
        TransferBusinessAccountStarsBuilder() {
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public TransferBusinessAccountStarsBuilder businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @JsonProperty(value="star_count")
        @Generated
        public TransferBusinessAccountStarsBuilder starCount(@NonNull Integer starCount) {
            if (starCount == null) {
                throw new NullPointerException("starCount is marked non-null but is null");
            }
            this.starCount = starCount;
            return this;
        }

        @Generated
        public TransferBusinessAccountStars build() {
            return new TransferBusinessAccountStars(this.businessConnectionId, this.starCount);
        }

        @Generated
        public String toString() {
            return "TransferBusinessAccountStars.TransferBusinessAccountStarsBuilder(businessConnectionId=" + this.businessConnectionId + ", starCount=" + this.starCount + ")";
        }
    }
}

