/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stories;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.stories.Story;
import org.telegram.telegrambots.meta.api.objects.stories.StoryArea;
import org.telegram.telegrambots.meta.api.objects.stories.input.InputStoryContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class PostStory
extends BotApiMethod<Story> {
    public static final String PATH = "postStory";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String CONTENT_FIELD = "content";
    private static final String ACTIVE_PERIOD_FIELD = "active_period";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    private static final String AREAS_FIELD = "areas";
    private static final String POST_TO_CHAT_PAGE_FIELD = "post_to_chat_page";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="content")
    @NonNull
    private InputStoryContent content;
    @JsonProperty(value="active_period")
    @NonNull
    private Integer activePeriod;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="areas")
    private List<StoryArea> areas;
    @JsonProperty(value="post_to_chat_page")
    private Boolean postToChatPage;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;

    public void setBusinessConnectionId(Long businessConnectionId) {
        this.businessConnectionId = businessConnectionId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Story deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Story.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty", this);
        }
        this.content.validate();
        int sixHours = 21600;
        int twelveHours = 43200;
        int oneDay = 86400;
        int twoDays = 172800;
        if (this.activePeriod != sixHours && this.activePeriod != twelveHours && this.activePeriod != oneDay && this.activePeriod != twoDays) {
            throw new TelegramApiValidationException("ActivePeriod must be one of: 6 hours (21600), 12 hours (43200), 24 hours (86400), or 48 hours (172800)", this);
        }
        if (this.caption != null && this.caption.length() > 2048) {
            throw new TelegramApiValidationException("Caption can't be longer than 2048 characters", this);
        }
        if (this.areas != null) {
            for (StoryArea area : this.areas) {
                area.validate();
            }
        }
    }

    @Generated
    public static PostStoryBuilder builder() {
        return new PostStoryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostStory)) {
            return false;
        }
        PostStory other = (PostStory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$activePeriod = this.getActivePeriod();
        Integer other$activePeriod = other.getActivePeriod();
        if (this$activePeriod == null ? other$activePeriod != null : !((Object)this$activePeriod).equals(other$activePeriod)) {
            return false;
        }
        Boolean this$postToChatPage = this.getPostToChatPage();
        Boolean other$postToChatPage = other.getPostToChatPage();
        if (this$postToChatPage == null ? other$postToChatPage != null : !((Object)this$postToChatPage).equals(other$postToChatPage)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        InputStoryContent this$content = this.getContent();
        InputStoryContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        List<StoryArea> this$areas = this.getAreas();
        List<StoryArea> other$areas = other.getAreas();
        return !(this$areas == null ? other$areas != null : !((Object)this$areas).equals(other$areas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PostStory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $activePeriod = this.getActivePeriod();
        result = result * 59 + ($activePeriod == null ? 43 : ((Object)$activePeriod).hashCode());
        Boolean $postToChatPage = this.getPostToChatPage();
        result = result * 59 + ($postToChatPage == null ? 43 : ((Object)$postToChatPage).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        InputStoryContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        List<StoryArea> $areas = this.getAreas();
        result = result * 59 + ($areas == null ? 43 : ((Object)$areas).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public InputStoryContent getContent() {
        return this.content;
    }

    @NonNull
    @Generated
    public Integer getActivePeriod() {
        return this.activePeriod;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Generated
    public List<StoryArea> getAreas() {
        return this.areas;
    }

    @Generated
    public Boolean getPostToChatPage() {
        return this.postToChatPage;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="content")
    @Generated
    public void setContent(@NonNull InputStoryContent content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    @JsonProperty(value="active_period")
    @Generated
    public void setActivePeriod(@NonNull Integer activePeriod) {
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.activePeriod = activePeriod;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="areas")
    @Generated
    public void setAreas(List<StoryArea> areas) {
        this.areas = areas;
    }

    @JsonProperty(value="post_to_chat_page")
    @Generated
    public void setPostToChatPage(Boolean postToChatPage) {
        this.postToChatPage = postToChatPage;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public String toString() {
        return "PostStory(businessConnectionId=" + this.getBusinessConnectionId() + ", content=" + this.getContent() + ", activePeriod=" + this.getActivePeriod() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", areas=" + this.getAreas() + ", postToChatPage=" + this.getPostToChatPage() + ", protectContent=" + this.getProtectContent() + ")";
    }

    @Generated
    public PostStory() {
    }

    @Generated
    public PostStory(@NonNull String businessConnectionId, @NonNull InputStoryContent content, @NonNull Integer activePeriod) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.content = content;
        this.activePeriod = activePeriod;
    }

    @Generated
    public PostStory(@NonNull String businessConnectionId, @NonNull InputStoryContent content, @NonNull Integer activePeriod, String caption, String parseMode, List<MessageEntity> captionEntities, List<StoryArea> areas, Boolean postToChatPage, Boolean protectContent) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.content = content;
        this.activePeriod = activePeriod;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.areas = areas;
        this.postToChatPage = postToChatPage;
        this.protectContent = protectContent;
    }

    @Generated
    public static class PostStoryBuilder {
        @Generated
        private String businessConnectionId;
        @Generated
        private InputStoryContent content;
        @Generated
        private Integer activePeriod;
        @Generated
        private String caption;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> captionEntities;
        @Generated
        private List<StoryArea> areas;
        @Generated
        private Boolean postToChatPage;
        @Generated
        private Boolean protectContent;

        @Generated
        PostStoryBuilder() {
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public PostStoryBuilder businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @JsonProperty(value="content")
        @Generated
        public PostStoryBuilder content(@NonNull InputStoryContent content) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            return this;
        }

        @JsonProperty(value="active_period")
        @Generated
        public PostStoryBuilder activePeriod(@NonNull Integer activePeriod) {
            if (activePeriod == null) {
                throw new NullPointerException("activePeriod is marked non-null but is null");
            }
            this.activePeriod = activePeriod;
            return this;
        }

        @JsonProperty(value="caption")
        @Generated
        public PostStoryBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public PostStoryBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public PostStoryBuilder captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return this;
        }

        @JsonProperty(value="areas")
        @Generated
        public PostStoryBuilder areas(List<StoryArea> areas) {
            this.areas = areas;
            return this;
        }

        @JsonProperty(value="post_to_chat_page")
        @Generated
        public PostStoryBuilder postToChatPage(Boolean postToChatPage) {
            this.postToChatPage = postToChatPage;
            return this;
        }

        @JsonProperty(value="protect_content")
        @Generated
        public PostStoryBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        @Generated
        public PostStory build() {
            return new PostStory(this.businessConnectionId, this.content, this.activePeriod, this.caption, this.parseMode, this.captionEntities, this.areas, this.postToChatPage, this.protectContent);
        }

        @Generated
        public String toString() {
            return "PostStory.PostStoryBuilder(businessConnectionId=" + this.businessConnectionId + ", content=" + this.content + ", activePeriod=" + this.activePeriod + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", areas=" + this.areas + ", postToChatPage=" + this.postToChatPage + ", protectContent=" + this.protectContent + ")";
        }
    }
}

