/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputMediaAnimationBuilderImpl.class)
public class InputMediaAnimation
extends InputMedia {
    private static final String TYPE = "animation";
    private static final String WIDTH_FIELD = "width";
    private static final String HEIGHT_FIELD = "height";
    private static final String DURATION_FIELD = "duration";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    private static final String HAS_SPOILER_FIELD = "has_spoiler";
    private static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="duration")
    private Integer duration;
    private InputFile thumbnail;
    @JsonProperty(value="has_spoiler")
    private Boolean hasSpoiler;
    @JsonProperty(value="show_caption_above_media")
    private Boolean showCaptionAboveMedia;

    public InputMediaAnimation(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaAnimation(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputMediaAnimation(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputMediaAnimation(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Integer width, Integer height, Integer duration, InputFile thumbnail, Boolean hasSpoiler) {
        super(media, caption, parseMode, captionEntities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.thumbnail = thumbnail;
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    @Generated
    protected InputMediaAnimation(InputMediaAnimationBuilder<?, ?> b) {
        super(b);
        this.width = b.width;
        this.height = b.height;
        this.duration = b.duration;
        this.thumbnail = b.thumbnail;
        this.hasSpoiler = b.hasSpoiler;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
    }

    @Generated
    public static InputMediaAnimationBuilder<?, ?> builder() {
        return new InputMediaAnimationBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaAnimation)) {
            return false;
        }
        InputMediaAnimation other = (InputMediaAnimation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        if (this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaAnimation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @JsonProperty(value="width")
    @Generated
    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonProperty(value="height")
    @Generated
    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonProperty(value="duration")
    @Generated
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Generated
    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @JsonProperty(value="has_spoiler")
    @Generated
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @JsonProperty(value="show_caption_above_media")
    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @Override
    @Generated
    public String toString() {
        return "InputMediaAnimation(width=" + this.getWidth() + ", height=" + this.getHeight() + ", duration=" + this.getDuration() + ", thumbnail=" + this.getThumbnail() + ", hasSpoiler=" + this.getHasSpoiler() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ")";
    }

    @Generated
    public InputMediaAnimation(Integer width, Integer height, Integer duration, InputFile thumbnail, Boolean hasSpoiler, Boolean showCaptionAboveMedia) {
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.thumbnail = thumbnail;
        this.hasSpoiler = hasSpoiler;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @Generated
    public static abstract class InputMediaAnimationBuilder<C extends InputMediaAnimation, B extends InputMediaAnimationBuilder<C, B>>
    extends InputMedia.InputMediaBuilder<C, B> {
        @Generated
        private Integer width;
        @Generated
        private Integer height;
        @Generated
        private Integer duration;
        @Generated
        private InputFile thumbnail;
        @Generated
        private Boolean hasSpoiler;
        @Generated
        private Boolean showCaptionAboveMedia;

        @JsonProperty(value="width")
        @Generated
        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        @JsonProperty(value="height")
        @Generated
        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        @JsonProperty(value="duration")
        @Generated
        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Generated
        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="has_spoiler")
        @Generated
        public B hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return (B)this.self();
        }

        @JsonProperty(value="show_caption_above_media")
        @Generated
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InputMediaAnimation.InputMediaAnimationBuilder(super=" + super.toString() + ", width=" + this.width + ", height=" + this.height + ", duration=" + this.duration + ", thumbnail=" + this.thumbnail + ", hasSpoiler=" + this.hasSpoiler + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputMediaAnimationBuilderImpl
    extends InputMediaAnimationBuilder<InputMediaAnimation, InputMediaAnimationBuilderImpl> {
        @Generated
        private InputMediaAnimationBuilderImpl() {
        }

        @Override
        @Generated
        protected InputMediaAnimationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputMediaAnimation build() {
            return new InputMediaAnimation(this);
        }
    }
}

