/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.telegram.telegrambots.meta.api.objects.Audio;
import org.telegram.telegrambots.meta.api.objects.ChatShared;
import org.telegram.telegrambots.meta.api.objects.Contact;
import org.telegram.telegrambots.meta.api.objects.Dice;
import org.telegram.telegrambots.meta.api.objects.Document;
import org.telegram.telegrambots.meta.api.objects.ExternalReplyInfo;
import org.telegram.telegrambots.meta.api.objects.LinkPreviewOptions;
import org.telegram.telegrambots.meta.api.objects.MessageAutoDeleteTimerChanged;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ProximityAlertTriggered;
import org.telegram.telegrambots.meta.api.objects.TextQuote;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.UserShared;
import org.telegram.telegrambots.meta.api.objects.UsersShared;
import org.telegram.telegrambots.meta.api.objects.Venue;
import org.telegram.telegrambots.meta.api.objects.Video;
import org.telegram.telegrambots.meta.api.objects.VideoNote;
import org.telegram.telegrambots.meta.api.objects.Voice;
import org.telegram.telegrambots.meta.api.objects.WriteAccessAllowed;
import org.telegram.telegrambots.meta.api.objects.boost.ChatBoostAdded;
import org.telegram.telegrambots.meta.api.objects.chat.Chat;
import org.telegram.telegrambots.meta.api.objects.chat.background.ChatBackground;
import org.telegram.telegrambots.meta.api.objects.forum.ForumTopicClosed;
import org.telegram.telegrambots.meta.api.objects.forum.ForumTopicCreated;
import org.telegram.telegrambots.meta.api.objects.forum.ForumTopicEdited;
import org.telegram.telegrambots.meta.api.objects.forum.ForumTopicReopened;
import org.telegram.telegrambots.meta.api.objects.forum.GeneralForumTopicHidden;
import org.telegram.telegrambots.meta.api.objects.forum.GeneralForumTopicUnhidden;
import org.telegram.telegrambots.meta.api.objects.games.Animation;
import org.telegram.telegrambots.meta.api.objects.games.Game;
import org.telegram.telegrambots.meta.api.objects.gifts.GiftInfo;
import org.telegram.telegrambots.meta.api.objects.gifts.UniqueGiftInfo;
import org.telegram.telegrambots.meta.api.objects.giveaway.Giveaway;
import org.telegram.telegrambots.meta.api.objects.giveaway.GiveawayCompleted;
import org.telegram.telegrambots.meta.api.objects.giveaway.GiveawayCreated;
import org.telegram.telegrambots.meta.api.objects.giveaway.GiveawayWinners;
import org.telegram.telegrambots.meta.api.objects.location.Location;
import org.telegram.telegrambots.meta.api.objects.message.MaybeInaccessibleMessage;
import org.telegram.telegrambots.meta.api.objects.message.PaidMessagePriceChanged;
import org.telegram.telegrambots.meta.api.objects.messageorigin.MessageOrigin;
import org.telegram.telegrambots.meta.api.objects.passport.PassportData;
import org.telegram.telegrambots.meta.api.objects.payments.Invoice;
import org.telegram.telegrambots.meta.api.objects.payments.RefundedPayment;
import org.telegram.telegrambots.meta.api.objects.payments.SuccessfulPayment;
import org.telegram.telegrambots.meta.api.objects.payments.paidmedia.PaidMediaInfo;
import org.telegram.telegrambots.meta.api.objects.photo.PhotoSize;
import org.telegram.telegrambots.meta.api.objects.polls.Poll;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.stickers.Sticker;
import org.telegram.telegrambots.meta.api.objects.stories.Story;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatEnded;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatParticipantsInvited;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatScheduled;
import org.telegram.telegrambots.meta.api.objects.videochat.VideoChatStarted;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=MessageBuilderImpl.class)
public class Message
implements MaybeInaccessibleMessage {
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String FROM_FIELD = "from";
    private static final String DATE_FIELD = "date";
    private static final String CHAT_FIELD = "chat";
    private static final String FORWARD_FROM_FIELD = "forward_from";
    private static final String FORWARD_FROM_CHAT_FIELD = "forward_from_chat";
    private static final String FORWARD_DATE_FIELD = "forward_date";
    private static final String TEXT_FIELD = "text";
    private static final String ENTITIES_FIELD = "entities";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    private static final String AUDIO_FIELD = "audio";
    private static final String DOCUMENT_FIELD = "document";
    private static final String PHOTO_FIELD = "photo";
    private static final String STICKER_FIELD = "sticker";
    private static final String VIDEO_FIELD = "video";
    private static final String CONTACT_FIELD = "contact";
    private static final String LOCATION_FIELD = "location";
    private static final String VENUE_FIELD = "venue";
    private static final String ANIMATION_FIELD = "animation";
    private static final String PINNED_MESSAGE_FIELD = "pinned_message";
    private static final String NEW_CHAT_MEMBERS_FIELD = "new_chat_members";
    private static final String LEFT_CHAT_MEMBER_FIELD = "left_chat_member";
    private static final String NEW_CHAT_TITLE_FIELD = "new_chat_title";
    private static final String NEW_CHAT_PHOTO_FIELD = "new_chat_photo";
    private static final String DELETE_CHAT_PHOTO_FIELD = "delete_chat_photo";
    private static final String GROUP_CHAT_CREATED_FIELD = "group_chat_created";
    private static final String REPLY_TO_MESSAGE_FIELD = "reply_to_message";
    private static final String VOICE_FIELD = "voice";
    private static final String CAPTION_FIELD = "caption";
    private static final String SUPER_GROUP_CREATED_FIELD = "supergroup_chat_created";
    private static final String CHANNEL_CHAT_CREATED_FIELD = "channel_chat_created";
    private static final String MIGRATE_TO_CHAT_FIELD = "migrate_to_chat_id";
    private static final String MIGRATE_FROM_CHAT_FIELD = "migrate_from_chat_id";
    private static final String EDIT_DATE_FIELD = "edit_date";
    private static final String GAME_FIELD = "game";
    private static final String FORWARD_FROM_MESSAGE_ID_FIELD = "forward_from_message_id";
    private static final String INVOICE_FIELD = "invoice";
    private static final String SUCCESSFUL_PAYMENT_FIELD = "successful_payment";
    private static final String VIDEO_NOTE_FIELD = "video_note";
    private static final String AUTHOR_SIGNATURE_FIELD = "author_signature";
    private static final String FORWARD_SIGNATURE_FIELD = "forward_signature";
    private static final String MEDIA_GROUP_ID_FIELD = "media_group_id";
    private static final String CONNECTED_WEBSITE_FIELD = "connected_website";
    private static final String PASSPORT_DATA_FIELD = "passport_data";
    private static final String FORWARD_SENDER_NAME_FIELD = "forward_sender_name";
    private static final String POLL_FIELD = "poll";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String DICE_FIELD = "dice";
    private static final String VIA_BOT_FIELD = "via_bot";
    private static final String SENDER_CHAT_FIELD = "sender_chat";
    private static final String PROXIMITY_ALERT_TRIGGERED_FIELD = "proximity_alert_triggered";
    private static final String MESSAGE_AUTO_DELETE_TIMER_CHANGED_FIELD = "message_auto_delete_timer_changed";
    private static final String IS_AUTOMATIC_FORWARD_FIELD = "is_automatic_forward";
    private static final String HAS_PROTECTED_CONTENT_FIELD = "has_protected_content";
    private static final String WEB_APP_DATA_FIELD = "web_app_data";
    private static final String VIDEO_CHAT_SCHEDULED_FIELD = "video_chat_scheduled";
    private static final String VIDEO_CHAT_STARTED_FIELD = "video_chat_started";
    private static final String VIDEO_CHAT_ENDED_FIELD = "video_chat_ended";
    private static final String VIDEO_CHAT_PARTICIPANTS_INVITED_FIELD = "video_chat_participants_invited";
    private static final String IS_TOPIC_MESSAGE_FIELD = "is_topic_message";
    private static final String FORUM_TOPIC_CREATED_FIELD = "forum_topic_created";
    private static final String FORUM_TOPIC_CLOSED_FIELD = "forum_topic_closed";
    private static final String FORUM_TOPIC_REOPENED_FIELD = "forum_topic_reopened";
    private static final String FORUM_TOPIC_EDITED_FIELD = "forum_topic_edited";
    private static final String GENERAL_FORUM_TOPIC_HIDDEN_FIELD = "general_forum_topic_hidden";
    private static final String GENERAL_FORUM_TOPIC_UNHIDDEN_FIELD = "general_forum_topic_unhidden";
    private static final String WRITE_ACCESS_ALLOWED_FIELD = "write_access_allowed";
    private static final String HAS_MEDIA_SPOILER_FIELD = "has_media_spoiler";
    private static final String USER_SHARED_FIELD = "user_shared";
    private static final String CHAT_SHARED_FIELD = "chat_shared";
    private static final String STORY_FIELD = "story";
    private static final String EXTERNAL_REPLY_FIELD = "external_reply";
    private static final String FORWARD_ORIGIN_FIELD = "forward_origin";
    private static final String LINK_PREVIEW_OPTIONS_FIELD = "link_preview_options";
    private static final String QUOTE_FIELD = "quote";
    private static final String USERS_SHARED_FIELD = "users_shared";
    private static final String GIVEAWAY_CREATED_FIELD = "giveaway_created";
    private static final String GIVEAWAY_FIELD = "giveaway";
    private static final String GIVEAWAY_WINNERS_FIELD = "giveaway_winners";
    private static final String GIVEAWAY_COMPLETED_FIELD = "giveaway_completed";
    private static final String REPLY_TO_STORY_FIELD = "reply_to_story";
    private static final String BOOST_ADDED_FIELD = "boost_added";
    private static final String SENDER_BOOST_COUNT_FIELD = "sender_boost_count";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String SENDER_BUSINESS_BOT_FIELD = "sender_business_bot";
    private static final String IS_FROM_OFFLINE_FIELD = "is_from_offline";
    private static final String CHAT_BACKGROUND_SET_FIELD = "chat_background_set";
    private static final String EFFECT_ID_FIELD = "effect_id";
    private static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    private static final String PAID_MEDIA_FIELD = "paid_media";
    private static final String REFUNDED_PAYMENT_FIELD = "refunded_payment";
    private static final String GIFT_FIELD = "gift";
    private static final String UNIQUE_GIFT_FIELD = "unique_gift";
    private static final String PAID_MESSAGE_PRICE_CHANGED_FIELD = "paid_message_price_changed";
    private static final String PAID_STAR_COUNT_FIELD = "paid_star_count";
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="date")
    private Integer date;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="forward_from")
    private User forwardFrom;
    @JsonProperty(value="forward_from_chat")
    private Chat forwardFromChat;
    @JsonProperty(value="forward_date")
    private Integer forwardDate;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="audio")
    private Audio audio;
    @JsonProperty(value="document")
    private Document document;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="sticker")
    private Sticker sticker;
    @JsonProperty(value="video")
    private Video video;
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="venue")
    private Venue venue;
    @JsonProperty(value="animation")
    private Animation animation;
    @JsonProperty(value="pinned_message")
    private MaybeInaccessibleMessage pinnedMessage;
    @JsonProperty(value="new_chat_members")
    private List<User> newChatMembers;
    @JsonProperty(value="left_chat_member")
    private User leftChatMember;
    @JsonProperty(value="new_chat_title")
    private String newChatTitle;
    @JsonProperty(value="new_chat_photo")
    private List<PhotoSize> newChatPhoto;
    @JsonProperty(value="delete_chat_photo")
    private Boolean deleteChatPhoto;
    @JsonProperty(value="group_chat_created")
    private Boolean groupchatCreated;
    @JsonProperty(value="reply_to_message")
    private Message replyToMessage;
    @JsonProperty(value="voice")
    private Voice voice;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="supergroup_chat_created")
    private Boolean superGroupCreated;
    @JsonProperty(value="channel_chat_created")
    private Boolean channelChatCreated;
    @JsonProperty(value="migrate_to_chat_id")
    private Long migrateToChatId;
    @JsonProperty(value="migrate_from_chat_id")
    private Long migrateFromChatId;
    @JsonProperty(value="edit_date")
    private Integer editDate;
    @JsonProperty(value="game")
    private Game game;
    @JsonProperty(value="forward_from_message_id")
    private Integer forwardFromMessageId;
    @JsonProperty(value="invoice")
    private Invoice invoice;
    @JsonProperty(value="successful_payment")
    private SuccessfulPayment successfulPayment;
    @JsonProperty(value="video_note")
    private VideoNote videoNote;
    @JsonProperty(value="author_signature")
    private String authorSignature;
    @JsonProperty(value="forward_signature")
    private String forwardSignature;
    @JsonProperty(value="media_group_id")
    private String mediaGroupId;
    @JsonProperty(value="connected_website")
    private String connectedWebsite;
    @JsonProperty(value="passport_data")
    private PassportData passportData;
    @JsonProperty(value="forward_sender_name")
    private String forwardSenderName;
    @JsonProperty(value="poll")
    private Poll poll;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="dice")
    private Dice dice;
    @JsonProperty(value="via_bot")
    private User viaBot;
    @JsonProperty(value="sender_chat")
    private Chat senderChat;
    @JsonProperty(value="proximity_alert_triggered")
    private ProximityAlertTriggered proximityAlertTriggered;
    @JsonProperty(value="message_auto_delete_timer_changed")
    private MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged;
    @JsonProperty(value="is_automatic_forward")
    private Boolean isAutomaticForward;
    @JsonProperty(value="has_protected_content")
    private Boolean hasProtectedContent;
    @JsonProperty(value="web_app_data")
    private WebAppData webAppData;
    @JsonProperty(value="video_chat_started")
    private VideoChatStarted videoChatStarted;
    @JsonProperty(value="video_chat_ended")
    private VideoChatEnded videoChatEnded;
    @JsonProperty(value="video_chat_participants_invited")
    private VideoChatParticipantsInvited videoChatParticipantsInvited;
    @JsonProperty(value="video_chat_scheduled")
    private VideoChatScheduled videoChatScheduled;
    @JsonProperty(value="is_topic_message")
    private Boolean isTopicMessage;
    @JsonProperty(value="forum_topic_created")
    private ForumTopicCreated forumTopicCreated;
    @JsonProperty(value="forum_topic_closed")
    private ForumTopicClosed forumTopicClosed;
    @JsonProperty(value="forum_topic_reopened")
    private ForumTopicReopened forumTopicReopened;
    @JsonProperty(value="forum_topic_edited")
    private ForumTopicEdited forumTopicEdited;
    @JsonProperty(value="general_forum_topic_hidden")
    private GeneralForumTopicHidden generalForumTopicHidden;
    @JsonProperty(value="general_forum_topic_unhidden")
    private GeneralForumTopicUnhidden generalForumTopicUnhidden;
    @JsonProperty(value="write_access_allowed")
    private WriteAccessAllowed writeAccessAllowed;
    @JsonProperty(value="has_media_spoiler")
    private Boolean hasMediaSpoiler;
    @JsonProperty(value="user_shared")
    private UserShared userShared;
    @JsonProperty(value="chat_shared")
    private ChatShared chatShared;
    @JsonProperty(value="story")
    private Story story;
    @JsonProperty(value="external_reply")
    private ExternalReplyInfo externalReplyInfo;
    @JsonProperty(value="forward_origin")
    private MessageOrigin forwardOrigin;
    @JsonProperty(value="link_preview_options")
    private LinkPreviewOptions linkPreviewOptions;
    @JsonProperty(value="quote")
    private TextQuote quote;
    @JsonProperty(value="users_shared")
    private UsersShared usersShared;
    @JsonProperty(value="giveaway_created")
    private GiveawayCreated giveawayCreated;
    @JsonProperty(value="giveaway")
    private Giveaway giveaway;
    @JsonProperty(value="giveaway_winners")
    private GiveawayWinners giveawayWinners;
    @JsonProperty(value="giveaway_completed")
    private GiveawayCompleted giveawayCompleted;
    @JsonProperty(value="reply_to_story")
    private Story replyToStory;
    @JsonProperty(value="boost_added")
    private ChatBoostAdded boostAdded;
    @JsonProperty(value="sender_boost_count")
    private Integer senderBoostCount;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;
    @JsonProperty(value="sender_business_bot")
    private User senderBusinessBot;
    @JsonProperty(value="is_from_offline")
    private Boolean isFromOffline;
    @JsonProperty(value="chat_background_set")
    private ChatBackground chatBackgroundSet;
    @JsonProperty(value="effect_id")
    private String effectId;
    @JsonProperty(value="show_caption_above_media")
    private Boolean showCaptionAboveMedia;
    @JsonProperty(value="paid_media")
    private PaidMediaInfo paidMedia;
    @JsonProperty(value="refunded_payment")
    private RefundedPayment refundedPayment;
    @JsonProperty(value="gift")
    private GiftInfo gift;
    @JsonProperty(value="unique_gift")
    private UniqueGiftInfo uniqueGift;
    @JsonProperty(value="paid_message_price_changed")
    private PaidMessagePriceChanged paidMessagePriceChanged;
    @JsonProperty(value="paid_star_count")
    private Integer paidStarCount;

    public List<MessageEntity> getEntities() {
        if (this.entities != null) {
            this.entities.forEach(x -> x.computeText(this.text));
        }
        return this.entities;
    }

    public List<MessageEntity> getCaptionEntities() {
        if (this.captionEntities != null) {
            this.captionEntities.forEach(x -> x.computeText(this.caption));
        }
        return this.captionEntities;
    }

    @JsonIgnore
    public List<User> getNewChatMembers() {
        return this.newChatMembers == null ? new ArrayList() : this.newChatMembers;
    }

    @JsonIgnore
    public boolean hasSticker() {
        return this.sticker != null;
    }

    @JsonIgnore
    public boolean isTopicMessage() {
        return this.isTopicMessage != null && this.isTopicMessage != false;
    }

    @Override
    @JsonIgnore
    public boolean isGroupMessage() {
        return this.chat.isGroupChat();
    }

    @Override
    @JsonIgnore
    public boolean isUserMessage() {
        return this.chat.isUserChat();
    }

    @JsonIgnore
    public boolean isChannelMessage() {
        return this.chat.isChannelChat();
    }

    @Override
    @JsonIgnore
    public boolean isSuperGroupMessage() {
        return this.chat.isSuperGroupChat();
    }

    @Override
    @JsonIgnore
    public Long getChatId() {
        return this.chat.getId();
    }

    @JsonIgnore
    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    @JsonIgnore
    public boolean isCommand() {
        if (this.hasText() && this.entities != null) {
            for (MessageEntity entity : this.entities) {
                if (entity == null || entity.getOffset() != 0 || !"bot_command".equals(entity.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean hasDocument() {
        return this.document != null;
    }

    @JsonIgnore
    public boolean hasVideo() {
        return this.video != null;
    }

    @JsonIgnore
    public boolean hasAudio() {
        return this.audio != null;
    }

    @JsonIgnore
    public boolean hasVoice() {
        return this.voice != null;
    }

    @JsonIgnore
    public boolean isReply() {
        return this.replyToMessage != null;
    }

    @JsonIgnore
    public boolean hasLocation() {
        return this.location != null;
    }

    @JsonIgnore
    public boolean hasGame() {
        return this.game != null;
    }

    @JsonIgnore
    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    @JsonIgnore
    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    @JsonIgnore
    public boolean hasInvoice() {
        return this.invoice != null;
    }

    @JsonIgnore
    public boolean hasSuccessfulPayment() {
        return this.successfulPayment != null;
    }

    @JsonIgnore
    public boolean hasContact() {
        return this.contact != null;
    }

    @JsonIgnore
    public boolean hasVideoNote() {
        return this.videoNote != null;
    }

    @JsonIgnore
    public boolean hasPassportData() {
        return this.passportData != null;
    }

    @JsonIgnore
    public boolean hasAnimation() {
        return this.animation != null;
    }

    @JsonIgnore
    public boolean hasPoll() {
        return this.poll != null;
    }

    @JsonIgnore
    public boolean hasDice() {
        return this.dice != null;
    }

    @JsonIgnore
    public boolean hasViaBot() {
        return this.viaBot != null;
    }

    @JsonIgnore
    public boolean hasReplyMarkup() {
        return this.replyMarkup != null;
    }

    @JsonIgnore
    public boolean hasMessageAutoDeleteTimerChanged() {
        return this.messageAutoDeleteTimerChanged != null;
    }

    @JsonIgnore
    public boolean hasWebAppData() {
        return this.webAppData != null;
    }

    @JsonIgnore
    public boolean hasVideoChatStarted() {
        return this.videoChatStarted != null;
    }

    @JsonIgnore
    public boolean hasVideoChatEnded() {
        return this.videoChatEnded != null;
    }

    @JsonIgnore
    public boolean hasVideoChatScheduled() {
        return this.videoChatScheduled != null;
    }

    @JsonIgnore
    public boolean hasVideoChatParticipantsInvited() {
        return this.videoChatParticipantsInvited != null;
    }

    @JsonIgnore
    public boolean hasForumTopicCreated() {
        return this.forumTopicCreated != null;
    }

    @JsonIgnore
    public boolean hasForumTopicClosed() {
        return this.forumTopicClosed != null;
    }

    @JsonIgnore
    public boolean hasForumTopicReopened() {
        return this.forumTopicReopened != null;
    }

    @JsonIgnore
    public boolean hasUserShared() {
        return this.userShared != null;
    }

    @JsonIgnore
    public boolean hasChatShared() {
        return this.chatShared != null;
    }

    @JsonIgnore
    public boolean hasStory() {
        return this.story != null;
    }

    @JsonIgnore
    public boolean hasWriteAccessAllowed() {
        return this.writeAccessAllowed != null;
    }

    @JsonIgnore
    public boolean hasReplyToStory() {
        return this.replyToStory != null;
    }

    @JsonIgnore
    public boolean hasBoostAdded() {
        return this.boostAdded != null;
    }

    @JsonIgnore
    public boolean hasPaidMedia() {
        return this.paidMedia != null;
    }

    @JsonIgnore
    public boolean hasCaption() {
        return this.caption != null;
    }

    @JsonIgnore
    public boolean hasGift() {
        return this.gift != null;
    }

    @JsonIgnore
    public boolean hasUniqueGift() {
        return this.uniqueGift != null;
    }

    @JsonIgnore
    public boolean hasPaidMessagePriceChanged() {
        return this.paidMessagePriceChanged != null;
    }

    @JsonIgnore
    public boolean hasPaidStarCount() {
        return this.paidStarCount != null;
    }

    @Generated
    protected Message(MessageBuilder<?, ?> b) {
        this.messageId = b.messageId;
        this.messageThreadId = b.messageThreadId;
        this.from = b.from;
        this.date = b.date;
        this.chat = b.chat;
        this.forwardFrom = b.forwardFrom;
        this.forwardFromChat = b.forwardFromChat;
        this.forwardDate = b.forwardDate;
        this.text = b.text;
        this.entities = b.entities;
        this.captionEntities = b.captionEntities;
        this.audio = b.audio;
        this.document = b.document;
        this.photo = b.photo;
        this.sticker = b.sticker;
        this.video = b.video;
        this.contact = b.contact;
        this.location = b.location;
        this.venue = b.venue;
        this.animation = b.animation;
        this.pinnedMessage = b.pinnedMessage;
        this.newChatMembers = b.newChatMembers;
        this.leftChatMember = b.leftChatMember;
        this.newChatTitle = b.newChatTitle;
        this.newChatPhoto = b.newChatPhoto;
        this.deleteChatPhoto = b.deleteChatPhoto;
        this.groupchatCreated = b.groupchatCreated;
        this.replyToMessage = b.replyToMessage;
        this.voice = b.voice;
        this.caption = b.caption;
        this.superGroupCreated = b.superGroupCreated;
        this.channelChatCreated = b.channelChatCreated;
        this.migrateToChatId = b.migrateToChatId;
        this.migrateFromChatId = b.migrateFromChatId;
        this.editDate = b.editDate;
        this.game = b.game;
        this.forwardFromMessageId = b.forwardFromMessageId;
        this.invoice = b.invoice;
        this.successfulPayment = b.successfulPayment;
        this.videoNote = b.videoNote;
        this.authorSignature = b.authorSignature;
        this.forwardSignature = b.forwardSignature;
        this.mediaGroupId = b.mediaGroupId;
        this.connectedWebsite = b.connectedWebsite;
        this.passportData = b.passportData;
        this.forwardSenderName = b.forwardSenderName;
        this.poll = b.poll;
        this.replyMarkup = b.replyMarkup;
        this.dice = b.dice;
        this.viaBot = b.viaBot;
        this.senderChat = b.senderChat;
        this.proximityAlertTriggered = b.proximityAlertTriggered;
        this.messageAutoDeleteTimerChanged = b.messageAutoDeleteTimerChanged;
        this.isAutomaticForward = b.isAutomaticForward;
        this.hasProtectedContent = b.hasProtectedContent;
        this.webAppData = b.webAppData;
        this.videoChatStarted = b.videoChatStarted;
        this.videoChatEnded = b.videoChatEnded;
        this.videoChatParticipantsInvited = b.videoChatParticipantsInvited;
        this.videoChatScheduled = b.videoChatScheduled;
        this.isTopicMessage = b.isTopicMessage;
        this.forumTopicCreated = b.forumTopicCreated;
        this.forumTopicClosed = b.forumTopicClosed;
        this.forumTopicReopened = b.forumTopicReopened;
        this.forumTopicEdited = b.forumTopicEdited;
        this.generalForumTopicHidden = b.generalForumTopicHidden;
        this.generalForumTopicUnhidden = b.generalForumTopicUnhidden;
        this.writeAccessAllowed = b.writeAccessAllowed;
        this.hasMediaSpoiler = b.hasMediaSpoiler;
        this.userShared = b.userShared;
        this.chatShared = b.chatShared;
        this.story = b.story;
        this.externalReplyInfo = b.externalReplyInfo;
        this.forwardOrigin = b.forwardOrigin;
        this.linkPreviewOptions = b.linkPreviewOptions;
        this.quote = b.quote;
        this.usersShared = b.usersShared;
        this.giveawayCreated = b.giveawayCreated;
        this.giveaway = b.giveaway;
        this.giveawayWinners = b.giveawayWinners;
        this.giveawayCompleted = b.giveawayCompleted;
        this.replyToStory = b.replyToStory;
        this.boostAdded = b.boostAdded;
        this.senderBoostCount = b.senderBoostCount;
        this.businessConnectionId = b.businessConnectionId;
        this.senderBusinessBot = b.senderBusinessBot;
        this.isFromOffline = b.isFromOffline;
        this.chatBackgroundSet = b.chatBackgroundSet;
        this.effectId = b.effectId;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
        this.paidMedia = b.paidMedia;
        this.refundedPayment = b.refundedPayment;
        this.gift = b.gift;
        this.uniqueGift = b.uniqueGift;
        this.paidMessagePriceChanged = b.paidMessagePriceChanged;
        this.paidStarCount = b.paidStarCount;
    }

    @Generated
    public static MessageBuilder<?, ?> builder() {
        return new MessageBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$date = this.getDate();
        Integer other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Integer this$forwardDate = this.getForwardDate();
        Integer other$forwardDate = other.getForwardDate();
        if (this$forwardDate == null ? other$forwardDate != null : !((Object)this$forwardDate).equals(other$forwardDate)) {
            return false;
        }
        Boolean this$deleteChatPhoto = this.getDeleteChatPhoto();
        Boolean other$deleteChatPhoto = other.getDeleteChatPhoto();
        if (this$deleteChatPhoto == null ? other$deleteChatPhoto != null : !((Object)this$deleteChatPhoto).equals(other$deleteChatPhoto)) {
            return false;
        }
        Boolean this$groupchatCreated = this.getGroupchatCreated();
        Boolean other$groupchatCreated = other.getGroupchatCreated();
        if (this$groupchatCreated == null ? other$groupchatCreated != null : !((Object)this$groupchatCreated).equals(other$groupchatCreated)) {
            return false;
        }
        Boolean this$superGroupCreated = this.getSuperGroupCreated();
        Boolean other$superGroupCreated = other.getSuperGroupCreated();
        if (this$superGroupCreated == null ? other$superGroupCreated != null : !((Object)this$superGroupCreated).equals(other$superGroupCreated)) {
            return false;
        }
        Boolean this$channelChatCreated = this.getChannelChatCreated();
        Boolean other$channelChatCreated = other.getChannelChatCreated();
        if (this$channelChatCreated == null ? other$channelChatCreated != null : !((Object)this$channelChatCreated).equals(other$channelChatCreated)) {
            return false;
        }
        Long this$migrateToChatId = this.getMigrateToChatId();
        Long other$migrateToChatId = other.getMigrateToChatId();
        if (this$migrateToChatId == null ? other$migrateToChatId != null : !((Object)this$migrateToChatId).equals(other$migrateToChatId)) {
            return false;
        }
        Long this$migrateFromChatId = this.getMigrateFromChatId();
        Long other$migrateFromChatId = other.getMigrateFromChatId();
        if (this$migrateFromChatId == null ? other$migrateFromChatId != null : !((Object)this$migrateFromChatId).equals(other$migrateFromChatId)) {
            return false;
        }
        Integer this$editDate = this.getEditDate();
        Integer other$editDate = other.getEditDate();
        if (this$editDate == null ? other$editDate != null : !((Object)this$editDate).equals(other$editDate)) {
            return false;
        }
        Integer this$forwardFromMessageId = this.getForwardFromMessageId();
        Integer other$forwardFromMessageId = other.getForwardFromMessageId();
        if (this$forwardFromMessageId == null ? other$forwardFromMessageId != null : !((Object)this$forwardFromMessageId).equals(other$forwardFromMessageId)) {
            return false;
        }
        Boolean this$isAutomaticForward = this.getIsAutomaticForward();
        Boolean other$isAutomaticForward = other.getIsAutomaticForward();
        if (this$isAutomaticForward == null ? other$isAutomaticForward != null : !((Object)this$isAutomaticForward).equals(other$isAutomaticForward)) {
            return false;
        }
        Boolean this$hasProtectedContent = this.getHasProtectedContent();
        Boolean other$hasProtectedContent = other.getHasProtectedContent();
        if (this$hasProtectedContent == null ? other$hasProtectedContent != null : !((Object)this$hasProtectedContent).equals(other$hasProtectedContent)) {
            return false;
        }
        Boolean this$isTopicMessage = this.getIsTopicMessage();
        Boolean other$isTopicMessage = other.getIsTopicMessage();
        if (this$isTopicMessage == null ? other$isTopicMessage != null : !((Object)this$isTopicMessage).equals(other$isTopicMessage)) {
            return false;
        }
        Boolean this$hasMediaSpoiler = this.getHasMediaSpoiler();
        Boolean other$hasMediaSpoiler = other.getHasMediaSpoiler();
        if (this$hasMediaSpoiler == null ? other$hasMediaSpoiler != null : !((Object)this$hasMediaSpoiler).equals(other$hasMediaSpoiler)) {
            return false;
        }
        Integer this$senderBoostCount = this.getSenderBoostCount();
        Integer other$senderBoostCount = other.getSenderBoostCount();
        if (this$senderBoostCount == null ? other$senderBoostCount != null : !((Object)this$senderBoostCount).equals(other$senderBoostCount)) {
            return false;
        }
        Boolean this$isFromOffline = this.getIsFromOffline();
        Boolean other$isFromOffline = other.getIsFromOffline();
        if (this$isFromOffline == null ? other$isFromOffline != null : !((Object)this$isFromOffline).equals(other$isFromOffline)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        Integer this$paidStarCount = this.getPaidStarCount();
        Integer other$paidStarCount = other.getPaidStarCount();
        if (this$paidStarCount == null ? other$paidStarCount != null : !((Object)this$paidStarCount).equals(other$paidStarCount)) {
            return false;
        }
        User this$from = this.getFrom();
        User other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Chat this$chat = this.getChat();
        Chat other$chat = other.getChat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        User this$forwardFrom = this.getForwardFrom();
        User other$forwardFrom = other.getForwardFrom();
        if (this$forwardFrom == null ? other$forwardFrom != null : !((Object)this$forwardFrom).equals(other$forwardFrom)) {
            return false;
        }
        Chat this$forwardFromChat = this.getForwardFromChat();
        Chat other$forwardFromChat = other.getForwardFromChat();
        if (this$forwardFromChat == null ? other$forwardFromChat != null : !((Object)this$forwardFromChat).equals(other$forwardFromChat)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        Audio this$audio = this.getAudio();
        Audio other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
            return false;
        }
        List<PhotoSize> this$photo = this.getPhoto();
        List<PhotoSize> other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !((Object)this$photo).equals(other$photo)) {
            return false;
        }
        Sticker this$sticker = this.getSticker();
        Sticker other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        Video this$video = this.getVideo();
        Video other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        Contact this$contact = this.getContact();
        Contact other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !((Object)this$contact).equals(other$contact)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Venue this$venue = this.getVenue();
        Venue other$venue = other.getVenue();
        if (this$venue == null ? other$venue != null : !((Object)this$venue).equals(other$venue)) {
            return false;
        }
        Animation this$animation = this.getAnimation();
        Animation other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        MaybeInaccessibleMessage this$pinnedMessage = this.getPinnedMessage();
        MaybeInaccessibleMessage other$pinnedMessage = other.getPinnedMessage();
        if (this$pinnedMessage == null ? other$pinnedMessage != null : !this$pinnedMessage.equals(other$pinnedMessage)) {
            return false;
        }
        List<User> this$newChatMembers = this.getNewChatMembers();
        List<User> other$newChatMembers = other.getNewChatMembers();
        if (this$newChatMembers == null ? other$newChatMembers != null : !((Object)this$newChatMembers).equals(other$newChatMembers)) {
            return false;
        }
        User this$leftChatMember = this.getLeftChatMember();
        User other$leftChatMember = other.getLeftChatMember();
        if (this$leftChatMember == null ? other$leftChatMember != null : !((Object)this$leftChatMember).equals(other$leftChatMember)) {
            return false;
        }
        String this$newChatTitle = this.getNewChatTitle();
        String other$newChatTitle = other.getNewChatTitle();
        if (this$newChatTitle == null ? other$newChatTitle != null : !this$newChatTitle.equals(other$newChatTitle)) {
            return false;
        }
        List<PhotoSize> this$newChatPhoto = this.getNewChatPhoto();
        List<PhotoSize> other$newChatPhoto = other.getNewChatPhoto();
        if (this$newChatPhoto == null ? other$newChatPhoto != null : !((Object)this$newChatPhoto).equals(other$newChatPhoto)) {
            return false;
        }
        Message this$replyToMessage = this.getReplyToMessage();
        Message other$replyToMessage = other.getReplyToMessage();
        if (this$replyToMessage == null ? other$replyToMessage != null : !((Object)this$replyToMessage).equals(other$replyToMessage)) {
            return false;
        }
        Voice this$voice = this.getVoice();
        Voice other$voice = other.getVoice();
        if (this$voice == null ? other$voice != null : !((Object)this$voice).equals(other$voice)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        Game this$game = this.getGame();
        Game other$game = other.getGame();
        if (this$game == null ? other$game != null : !((Object)this$game).equals(other$game)) {
            return false;
        }
        Invoice this$invoice = this.getInvoice();
        Invoice other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !((Object)this$invoice).equals(other$invoice)) {
            return false;
        }
        SuccessfulPayment this$successfulPayment = this.getSuccessfulPayment();
        SuccessfulPayment other$successfulPayment = other.getSuccessfulPayment();
        if (this$successfulPayment == null ? other$successfulPayment != null : !((Object)this$successfulPayment).equals(other$successfulPayment)) {
            return false;
        }
        VideoNote this$videoNote = this.getVideoNote();
        VideoNote other$videoNote = other.getVideoNote();
        if (this$videoNote == null ? other$videoNote != null : !((Object)this$videoNote).equals(other$videoNote)) {
            return false;
        }
        String this$authorSignature = this.getAuthorSignature();
        String other$authorSignature = other.getAuthorSignature();
        if (this$authorSignature == null ? other$authorSignature != null : !this$authorSignature.equals(other$authorSignature)) {
            return false;
        }
        String this$forwardSignature = this.getForwardSignature();
        String other$forwardSignature = other.getForwardSignature();
        if (this$forwardSignature == null ? other$forwardSignature != null : !this$forwardSignature.equals(other$forwardSignature)) {
            return false;
        }
        String this$mediaGroupId = this.getMediaGroupId();
        String other$mediaGroupId = other.getMediaGroupId();
        if (this$mediaGroupId == null ? other$mediaGroupId != null : !this$mediaGroupId.equals(other$mediaGroupId)) {
            return false;
        }
        String this$connectedWebsite = this.getConnectedWebsite();
        String other$connectedWebsite = other.getConnectedWebsite();
        if (this$connectedWebsite == null ? other$connectedWebsite != null : !this$connectedWebsite.equals(other$connectedWebsite)) {
            return false;
        }
        PassportData this$passportData = this.getPassportData();
        PassportData other$passportData = other.getPassportData();
        if (this$passportData == null ? other$passportData != null : !((Object)this$passportData).equals(other$passportData)) {
            return false;
        }
        String this$forwardSenderName = this.getForwardSenderName();
        String other$forwardSenderName = other.getForwardSenderName();
        if (this$forwardSenderName == null ? other$forwardSenderName != null : !this$forwardSenderName.equals(other$forwardSenderName)) {
            return false;
        }
        Poll this$poll = this.getPoll();
        Poll other$poll = other.getPoll();
        if (this$poll == null ? other$poll != null : !((Object)this$poll).equals(other$poll)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        Dice this$dice = this.getDice();
        Dice other$dice = other.getDice();
        if (this$dice == null ? other$dice != null : !((Object)this$dice).equals(other$dice)) {
            return false;
        }
        User this$viaBot = this.getViaBot();
        User other$viaBot = other.getViaBot();
        if (this$viaBot == null ? other$viaBot != null : !((Object)this$viaBot).equals(other$viaBot)) {
            return false;
        }
        Chat this$senderChat = this.getSenderChat();
        Chat other$senderChat = other.getSenderChat();
        if (this$senderChat == null ? other$senderChat != null : !((Object)this$senderChat).equals(other$senderChat)) {
            return false;
        }
        ProximityAlertTriggered this$proximityAlertTriggered = this.getProximityAlertTriggered();
        ProximityAlertTriggered other$proximityAlertTriggered = other.getProximityAlertTriggered();
        if (this$proximityAlertTriggered == null ? other$proximityAlertTriggered != null : !((Object)this$proximityAlertTriggered).equals(other$proximityAlertTriggered)) {
            return false;
        }
        MessageAutoDeleteTimerChanged this$messageAutoDeleteTimerChanged = this.getMessageAutoDeleteTimerChanged();
        MessageAutoDeleteTimerChanged other$messageAutoDeleteTimerChanged = other.getMessageAutoDeleteTimerChanged();
        if (this$messageAutoDeleteTimerChanged == null ? other$messageAutoDeleteTimerChanged != null : !((Object)this$messageAutoDeleteTimerChanged).equals(other$messageAutoDeleteTimerChanged)) {
            return false;
        }
        WebAppData this$webAppData = this.getWebAppData();
        WebAppData other$webAppData = other.getWebAppData();
        if (this$webAppData == null ? other$webAppData != null : !((Object)this$webAppData).equals(other$webAppData)) {
            return false;
        }
        VideoChatStarted this$videoChatStarted = this.getVideoChatStarted();
        VideoChatStarted other$videoChatStarted = other.getVideoChatStarted();
        if (this$videoChatStarted == null ? other$videoChatStarted != null : !((Object)this$videoChatStarted).equals(other$videoChatStarted)) {
            return false;
        }
        VideoChatEnded this$videoChatEnded = this.getVideoChatEnded();
        VideoChatEnded other$videoChatEnded = other.getVideoChatEnded();
        if (this$videoChatEnded == null ? other$videoChatEnded != null : !((Object)this$videoChatEnded).equals(other$videoChatEnded)) {
            return false;
        }
        VideoChatParticipantsInvited this$videoChatParticipantsInvited = this.getVideoChatParticipantsInvited();
        VideoChatParticipantsInvited other$videoChatParticipantsInvited = other.getVideoChatParticipantsInvited();
        if (this$videoChatParticipantsInvited == null ? other$videoChatParticipantsInvited != null : !((Object)this$videoChatParticipantsInvited).equals(other$videoChatParticipantsInvited)) {
            return false;
        }
        VideoChatScheduled this$videoChatScheduled = this.getVideoChatScheduled();
        VideoChatScheduled other$videoChatScheduled = other.getVideoChatScheduled();
        if (this$videoChatScheduled == null ? other$videoChatScheduled != null : !((Object)this$videoChatScheduled).equals(other$videoChatScheduled)) {
            return false;
        }
        ForumTopicCreated this$forumTopicCreated = this.getForumTopicCreated();
        ForumTopicCreated other$forumTopicCreated = other.getForumTopicCreated();
        if (this$forumTopicCreated == null ? other$forumTopicCreated != null : !((Object)this$forumTopicCreated).equals(other$forumTopicCreated)) {
            return false;
        }
        ForumTopicClosed this$forumTopicClosed = this.getForumTopicClosed();
        ForumTopicClosed other$forumTopicClosed = other.getForumTopicClosed();
        if (this$forumTopicClosed == null ? other$forumTopicClosed != null : !((Object)this$forumTopicClosed).equals(other$forumTopicClosed)) {
            return false;
        }
        ForumTopicReopened this$forumTopicReopened = this.getForumTopicReopened();
        ForumTopicReopened other$forumTopicReopened = other.getForumTopicReopened();
        if (this$forumTopicReopened == null ? other$forumTopicReopened != null : !((Object)this$forumTopicReopened).equals(other$forumTopicReopened)) {
            return false;
        }
        ForumTopicEdited this$forumTopicEdited = this.getForumTopicEdited();
        ForumTopicEdited other$forumTopicEdited = other.getForumTopicEdited();
        if (this$forumTopicEdited == null ? other$forumTopicEdited != null : !((Object)this$forumTopicEdited).equals(other$forumTopicEdited)) {
            return false;
        }
        GeneralForumTopicHidden this$generalForumTopicHidden = this.getGeneralForumTopicHidden();
        GeneralForumTopicHidden other$generalForumTopicHidden = other.getGeneralForumTopicHidden();
        if (this$generalForumTopicHidden == null ? other$generalForumTopicHidden != null : !((Object)this$generalForumTopicHidden).equals(other$generalForumTopicHidden)) {
            return false;
        }
        GeneralForumTopicUnhidden this$generalForumTopicUnhidden = this.getGeneralForumTopicUnhidden();
        GeneralForumTopicUnhidden other$generalForumTopicUnhidden = other.getGeneralForumTopicUnhidden();
        if (this$generalForumTopicUnhidden == null ? other$generalForumTopicUnhidden != null : !((Object)this$generalForumTopicUnhidden).equals(other$generalForumTopicUnhidden)) {
            return false;
        }
        WriteAccessAllowed this$writeAccessAllowed = this.getWriteAccessAllowed();
        WriteAccessAllowed other$writeAccessAllowed = other.getWriteAccessAllowed();
        if (this$writeAccessAllowed == null ? other$writeAccessAllowed != null : !((Object)this$writeAccessAllowed).equals(other$writeAccessAllowed)) {
            return false;
        }
        UserShared this$userShared = this.getUserShared();
        UserShared other$userShared = other.getUserShared();
        if (this$userShared == null ? other$userShared != null : !((Object)this$userShared).equals(other$userShared)) {
            return false;
        }
        ChatShared this$chatShared = this.getChatShared();
        ChatShared other$chatShared = other.getChatShared();
        if (this$chatShared == null ? other$chatShared != null : !((Object)this$chatShared).equals(other$chatShared)) {
            return false;
        }
        Story this$story = this.getStory();
        Story other$story = other.getStory();
        if (this$story == null ? other$story != null : !((Object)this$story).equals(other$story)) {
            return false;
        }
        ExternalReplyInfo this$externalReplyInfo = this.getExternalReplyInfo();
        ExternalReplyInfo other$externalReplyInfo = other.getExternalReplyInfo();
        if (this$externalReplyInfo == null ? other$externalReplyInfo != null : !((Object)this$externalReplyInfo).equals(other$externalReplyInfo)) {
            return false;
        }
        MessageOrigin this$forwardOrigin = this.getForwardOrigin();
        MessageOrigin other$forwardOrigin = other.getForwardOrigin();
        if (this$forwardOrigin == null ? other$forwardOrigin != null : !this$forwardOrigin.equals(other$forwardOrigin)) {
            return false;
        }
        LinkPreviewOptions this$linkPreviewOptions = this.getLinkPreviewOptions();
        LinkPreviewOptions other$linkPreviewOptions = other.getLinkPreviewOptions();
        if (this$linkPreviewOptions == null ? other$linkPreviewOptions != null : !((Object)this$linkPreviewOptions).equals(other$linkPreviewOptions)) {
            return false;
        }
        TextQuote this$quote = this.getQuote();
        TextQuote other$quote = other.getQuote();
        if (this$quote == null ? other$quote != null : !((Object)this$quote).equals(other$quote)) {
            return false;
        }
        UsersShared this$usersShared = this.getUsersShared();
        UsersShared other$usersShared = other.getUsersShared();
        if (this$usersShared == null ? other$usersShared != null : !((Object)this$usersShared).equals(other$usersShared)) {
            return false;
        }
        GiveawayCreated this$giveawayCreated = this.getGiveawayCreated();
        GiveawayCreated other$giveawayCreated = other.getGiveawayCreated();
        if (this$giveawayCreated == null ? other$giveawayCreated != null : !((Object)this$giveawayCreated).equals(other$giveawayCreated)) {
            return false;
        }
        Giveaway this$giveaway = this.getGiveaway();
        Giveaway other$giveaway = other.getGiveaway();
        if (this$giveaway == null ? other$giveaway != null : !((Object)this$giveaway).equals(other$giveaway)) {
            return false;
        }
        GiveawayWinners this$giveawayWinners = this.getGiveawayWinners();
        GiveawayWinners other$giveawayWinners = other.getGiveawayWinners();
        if (this$giveawayWinners == null ? other$giveawayWinners != null : !((Object)this$giveawayWinners).equals(other$giveawayWinners)) {
            return false;
        }
        GiveawayCompleted this$giveawayCompleted = this.getGiveawayCompleted();
        GiveawayCompleted other$giveawayCompleted = other.getGiveawayCompleted();
        if (this$giveawayCompleted == null ? other$giveawayCompleted != null : !((Object)this$giveawayCompleted).equals(other$giveawayCompleted)) {
            return false;
        }
        Story this$replyToStory = this.getReplyToStory();
        Story other$replyToStory = other.getReplyToStory();
        if (this$replyToStory == null ? other$replyToStory != null : !((Object)this$replyToStory).equals(other$replyToStory)) {
            return false;
        }
        ChatBoostAdded this$boostAdded = this.getBoostAdded();
        ChatBoostAdded other$boostAdded = other.getBoostAdded();
        if (this$boostAdded == null ? other$boostAdded != null : !((Object)this$boostAdded).equals(other$boostAdded)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        User this$senderBusinessBot = this.getSenderBusinessBot();
        User other$senderBusinessBot = other.getSenderBusinessBot();
        if (this$senderBusinessBot == null ? other$senderBusinessBot != null : !((Object)this$senderBusinessBot).equals(other$senderBusinessBot)) {
            return false;
        }
        ChatBackground this$chatBackgroundSet = this.getChatBackgroundSet();
        ChatBackground other$chatBackgroundSet = other.getChatBackgroundSet();
        if (this$chatBackgroundSet == null ? other$chatBackgroundSet != null : !((Object)this$chatBackgroundSet).equals(other$chatBackgroundSet)) {
            return false;
        }
        String this$effectId = this.getEffectId();
        String other$effectId = other.getEffectId();
        if (this$effectId == null ? other$effectId != null : !this$effectId.equals(other$effectId)) {
            return false;
        }
        PaidMediaInfo this$paidMedia = this.getPaidMedia();
        PaidMediaInfo other$paidMedia = other.getPaidMedia();
        if (this$paidMedia == null ? other$paidMedia != null : !((Object)this$paidMedia).equals(other$paidMedia)) {
            return false;
        }
        RefundedPayment this$refundedPayment = this.getRefundedPayment();
        RefundedPayment other$refundedPayment = other.getRefundedPayment();
        if (this$refundedPayment == null ? other$refundedPayment != null : !((Object)this$refundedPayment).equals(other$refundedPayment)) {
            return false;
        }
        GiftInfo this$gift = this.getGift();
        GiftInfo other$gift = other.getGift();
        if (this$gift == null ? other$gift != null : !((Object)this$gift).equals(other$gift)) {
            return false;
        }
        UniqueGiftInfo this$uniqueGift = this.getUniqueGift();
        UniqueGiftInfo other$uniqueGift = other.getUniqueGift();
        if (this$uniqueGift == null ? other$uniqueGift != null : !((Object)this$uniqueGift).equals(other$uniqueGift)) {
            return false;
        }
        PaidMessagePriceChanged this$paidMessagePriceChanged = this.getPaidMessagePriceChanged();
        PaidMessagePriceChanged other$paidMessagePriceChanged = other.getPaidMessagePriceChanged();
        return !(this$paidMessagePriceChanged == null ? other$paidMessagePriceChanged != null : !((Object)this$paidMessagePriceChanged).equals(other$paidMessagePriceChanged));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Integer $forwardDate = this.getForwardDate();
        result = result * 59 + ($forwardDate == null ? 43 : ((Object)$forwardDate).hashCode());
        Boolean $deleteChatPhoto = this.getDeleteChatPhoto();
        result = result * 59 + ($deleteChatPhoto == null ? 43 : ((Object)$deleteChatPhoto).hashCode());
        Boolean $groupchatCreated = this.getGroupchatCreated();
        result = result * 59 + ($groupchatCreated == null ? 43 : ((Object)$groupchatCreated).hashCode());
        Boolean $superGroupCreated = this.getSuperGroupCreated();
        result = result * 59 + ($superGroupCreated == null ? 43 : ((Object)$superGroupCreated).hashCode());
        Boolean $channelChatCreated = this.getChannelChatCreated();
        result = result * 59 + ($channelChatCreated == null ? 43 : ((Object)$channelChatCreated).hashCode());
        Long $migrateToChatId = this.getMigrateToChatId();
        result = result * 59 + ($migrateToChatId == null ? 43 : ((Object)$migrateToChatId).hashCode());
        Long $migrateFromChatId = this.getMigrateFromChatId();
        result = result * 59 + ($migrateFromChatId == null ? 43 : ((Object)$migrateFromChatId).hashCode());
        Integer $editDate = this.getEditDate();
        result = result * 59 + ($editDate == null ? 43 : ((Object)$editDate).hashCode());
        Integer $forwardFromMessageId = this.getForwardFromMessageId();
        result = result * 59 + ($forwardFromMessageId == null ? 43 : ((Object)$forwardFromMessageId).hashCode());
        Boolean $isAutomaticForward = this.getIsAutomaticForward();
        result = result * 59 + ($isAutomaticForward == null ? 43 : ((Object)$isAutomaticForward).hashCode());
        Boolean $hasProtectedContent = this.getHasProtectedContent();
        result = result * 59 + ($hasProtectedContent == null ? 43 : ((Object)$hasProtectedContent).hashCode());
        Boolean $isTopicMessage = this.getIsTopicMessage();
        result = result * 59 + ($isTopicMessage == null ? 43 : ((Object)$isTopicMessage).hashCode());
        Boolean $hasMediaSpoiler = this.getHasMediaSpoiler();
        result = result * 59 + ($hasMediaSpoiler == null ? 43 : ((Object)$hasMediaSpoiler).hashCode());
        Integer $senderBoostCount = this.getSenderBoostCount();
        result = result * 59 + ($senderBoostCount == null ? 43 : ((Object)$senderBoostCount).hashCode());
        Boolean $isFromOffline = this.getIsFromOffline();
        result = result * 59 + ($isFromOffline == null ? 43 : ((Object)$isFromOffline).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        Integer $paidStarCount = this.getPaidStarCount();
        result = result * 59 + ($paidStarCount == null ? 43 : ((Object)$paidStarCount).hashCode());
        User $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Chat $chat = this.getChat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        User $forwardFrom = this.getForwardFrom();
        result = result * 59 + ($forwardFrom == null ? 43 : ((Object)$forwardFrom).hashCode());
        Chat $forwardFromChat = this.getForwardFromChat();
        result = result * 59 + ($forwardFromChat == null ? 43 : ((Object)$forwardFromChat).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        Audio $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
        List<PhotoSize> $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : ((Object)$photo).hashCode());
        Sticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        Video $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : ((Object)$video).hashCode());
        Contact $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : ((Object)$contact).hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Venue $venue = this.getVenue();
        result = result * 59 + ($venue == null ? 43 : ((Object)$venue).hashCode());
        Animation $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        MaybeInaccessibleMessage $pinnedMessage = this.getPinnedMessage();
        result = result * 59 + ($pinnedMessage == null ? 43 : $pinnedMessage.hashCode());
        List<User> $newChatMembers = this.getNewChatMembers();
        result = result * 59 + ($newChatMembers == null ? 43 : ((Object)$newChatMembers).hashCode());
        User $leftChatMember = this.getLeftChatMember();
        result = result * 59 + ($leftChatMember == null ? 43 : ((Object)$leftChatMember).hashCode());
        String $newChatTitle = this.getNewChatTitle();
        result = result * 59 + ($newChatTitle == null ? 43 : $newChatTitle.hashCode());
        List<PhotoSize> $newChatPhoto = this.getNewChatPhoto();
        result = result * 59 + ($newChatPhoto == null ? 43 : ((Object)$newChatPhoto).hashCode());
        Message $replyToMessage = this.getReplyToMessage();
        result = result * 59 + ($replyToMessage == null ? 43 : ((Object)$replyToMessage).hashCode());
        Voice $voice = this.getVoice();
        result = result * 59 + ($voice == null ? 43 : ((Object)$voice).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        Game $game = this.getGame();
        result = result * 59 + ($game == null ? 43 : ((Object)$game).hashCode());
        Invoice $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : ((Object)$invoice).hashCode());
        SuccessfulPayment $successfulPayment = this.getSuccessfulPayment();
        result = result * 59 + ($successfulPayment == null ? 43 : ((Object)$successfulPayment).hashCode());
        VideoNote $videoNote = this.getVideoNote();
        result = result * 59 + ($videoNote == null ? 43 : ((Object)$videoNote).hashCode());
        String $authorSignature = this.getAuthorSignature();
        result = result * 59 + ($authorSignature == null ? 43 : $authorSignature.hashCode());
        String $forwardSignature = this.getForwardSignature();
        result = result * 59 + ($forwardSignature == null ? 43 : $forwardSignature.hashCode());
        String $mediaGroupId = this.getMediaGroupId();
        result = result * 59 + ($mediaGroupId == null ? 43 : $mediaGroupId.hashCode());
        String $connectedWebsite = this.getConnectedWebsite();
        result = result * 59 + ($connectedWebsite == null ? 43 : $connectedWebsite.hashCode());
        PassportData $passportData = this.getPassportData();
        result = result * 59 + ($passportData == null ? 43 : ((Object)$passportData).hashCode());
        String $forwardSenderName = this.getForwardSenderName();
        result = result * 59 + ($forwardSenderName == null ? 43 : $forwardSenderName.hashCode());
        Poll $poll = this.getPoll();
        result = result * 59 + ($poll == null ? 43 : ((Object)$poll).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        Dice $dice = this.getDice();
        result = result * 59 + ($dice == null ? 43 : ((Object)$dice).hashCode());
        User $viaBot = this.getViaBot();
        result = result * 59 + ($viaBot == null ? 43 : ((Object)$viaBot).hashCode());
        Chat $senderChat = this.getSenderChat();
        result = result * 59 + ($senderChat == null ? 43 : ((Object)$senderChat).hashCode());
        ProximityAlertTriggered $proximityAlertTriggered = this.getProximityAlertTriggered();
        result = result * 59 + ($proximityAlertTriggered == null ? 43 : ((Object)$proximityAlertTriggered).hashCode());
        MessageAutoDeleteTimerChanged $messageAutoDeleteTimerChanged = this.getMessageAutoDeleteTimerChanged();
        result = result * 59 + ($messageAutoDeleteTimerChanged == null ? 43 : ((Object)$messageAutoDeleteTimerChanged).hashCode());
        WebAppData $webAppData = this.getWebAppData();
        result = result * 59 + ($webAppData == null ? 43 : ((Object)$webAppData).hashCode());
        VideoChatStarted $videoChatStarted = this.getVideoChatStarted();
        result = result * 59 + ($videoChatStarted == null ? 43 : ((Object)$videoChatStarted).hashCode());
        VideoChatEnded $videoChatEnded = this.getVideoChatEnded();
        result = result * 59 + ($videoChatEnded == null ? 43 : ((Object)$videoChatEnded).hashCode());
        VideoChatParticipantsInvited $videoChatParticipantsInvited = this.getVideoChatParticipantsInvited();
        result = result * 59 + ($videoChatParticipantsInvited == null ? 43 : ((Object)$videoChatParticipantsInvited).hashCode());
        VideoChatScheduled $videoChatScheduled = this.getVideoChatScheduled();
        result = result * 59 + ($videoChatScheduled == null ? 43 : ((Object)$videoChatScheduled).hashCode());
        ForumTopicCreated $forumTopicCreated = this.getForumTopicCreated();
        result = result * 59 + ($forumTopicCreated == null ? 43 : ((Object)$forumTopicCreated).hashCode());
        ForumTopicClosed $forumTopicClosed = this.getForumTopicClosed();
        result = result * 59 + ($forumTopicClosed == null ? 43 : ((Object)$forumTopicClosed).hashCode());
        ForumTopicReopened $forumTopicReopened = this.getForumTopicReopened();
        result = result * 59 + ($forumTopicReopened == null ? 43 : ((Object)$forumTopicReopened).hashCode());
        ForumTopicEdited $forumTopicEdited = this.getForumTopicEdited();
        result = result * 59 + ($forumTopicEdited == null ? 43 : ((Object)$forumTopicEdited).hashCode());
        GeneralForumTopicHidden $generalForumTopicHidden = this.getGeneralForumTopicHidden();
        result = result * 59 + ($generalForumTopicHidden == null ? 43 : ((Object)$generalForumTopicHidden).hashCode());
        GeneralForumTopicUnhidden $generalForumTopicUnhidden = this.getGeneralForumTopicUnhidden();
        result = result * 59 + ($generalForumTopicUnhidden == null ? 43 : ((Object)$generalForumTopicUnhidden).hashCode());
        WriteAccessAllowed $writeAccessAllowed = this.getWriteAccessAllowed();
        result = result * 59 + ($writeAccessAllowed == null ? 43 : ((Object)$writeAccessAllowed).hashCode());
        UserShared $userShared = this.getUserShared();
        result = result * 59 + ($userShared == null ? 43 : ((Object)$userShared).hashCode());
        ChatShared $chatShared = this.getChatShared();
        result = result * 59 + ($chatShared == null ? 43 : ((Object)$chatShared).hashCode());
        Story $story = this.getStory();
        result = result * 59 + ($story == null ? 43 : ((Object)$story).hashCode());
        ExternalReplyInfo $externalReplyInfo = this.getExternalReplyInfo();
        result = result * 59 + ($externalReplyInfo == null ? 43 : ((Object)$externalReplyInfo).hashCode());
        MessageOrigin $forwardOrigin = this.getForwardOrigin();
        result = result * 59 + ($forwardOrigin == null ? 43 : $forwardOrigin.hashCode());
        LinkPreviewOptions $linkPreviewOptions = this.getLinkPreviewOptions();
        result = result * 59 + ($linkPreviewOptions == null ? 43 : ((Object)$linkPreviewOptions).hashCode());
        TextQuote $quote = this.getQuote();
        result = result * 59 + ($quote == null ? 43 : ((Object)$quote).hashCode());
        UsersShared $usersShared = this.getUsersShared();
        result = result * 59 + ($usersShared == null ? 43 : ((Object)$usersShared).hashCode());
        GiveawayCreated $giveawayCreated = this.getGiveawayCreated();
        result = result * 59 + ($giveawayCreated == null ? 43 : ((Object)$giveawayCreated).hashCode());
        Giveaway $giveaway = this.getGiveaway();
        result = result * 59 + ($giveaway == null ? 43 : ((Object)$giveaway).hashCode());
        GiveawayWinners $giveawayWinners = this.getGiveawayWinners();
        result = result * 59 + ($giveawayWinners == null ? 43 : ((Object)$giveawayWinners).hashCode());
        GiveawayCompleted $giveawayCompleted = this.getGiveawayCompleted();
        result = result * 59 + ($giveawayCompleted == null ? 43 : ((Object)$giveawayCompleted).hashCode());
        Story $replyToStory = this.getReplyToStory();
        result = result * 59 + ($replyToStory == null ? 43 : ((Object)$replyToStory).hashCode());
        ChatBoostAdded $boostAdded = this.getBoostAdded();
        result = result * 59 + ($boostAdded == null ? 43 : ((Object)$boostAdded).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        User $senderBusinessBot = this.getSenderBusinessBot();
        result = result * 59 + ($senderBusinessBot == null ? 43 : ((Object)$senderBusinessBot).hashCode());
        ChatBackground $chatBackgroundSet = this.getChatBackgroundSet();
        result = result * 59 + ($chatBackgroundSet == null ? 43 : ((Object)$chatBackgroundSet).hashCode());
        String $effectId = this.getEffectId();
        result = result * 59 + ($effectId == null ? 43 : $effectId.hashCode());
        PaidMediaInfo $paidMedia = this.getPaidMedia();
        result = result * 59 + ($paidMedia == null ? 43 : ((Object)$paidMedia).hashCode());
        RefundedPayment $refundedPayment = this.getRefundedPayment();
        result = result * 59 + ($refundedPayment == null ? 43 : ((Object)$refundedPayment).hashCode());
        GiftInfo $gift = this.getGift();
        result = result * 59 + ($gift == null ? 43 : ((Object)$gift).hashCode());
        UniqueGiftInfo $uniqueGift = this.getUniqueGift();
        result = result * 59 + ($uniqueGift == null ? 43 : ((Object)$uniqueGift).hashCode());
        PaidMessagePriceChanged $paidMessagePriceChanged = this.getPaidMessagePriceChanged();
        result = result * 59 + ($paidMessagePriceChanged == null ? 43 : ((Object)$paidMessagePriceChanged).hashCode());
        return result;
    }

    @Override
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @Generated
    public User getFrom() {
        return this.from;
    }

    @Override
    @Generated
    public Integer getDate() {
        return this.date;
    }

    @Override
    @Generated
    public Chat getChat() {
        return this.chat;
    }

    @Generated
    public User getForwardFrom() {
        return this.forwardFrom;
    }

    @Generated
    public Chat getForwardFromChat() {
        return this.forwardFromChat;
    }

    @Generated
    public Integer getForwardDate() {
        return this.forwardDate;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public Audio getAudio() {
        return this.audio;
    }

    @Generated
    public Document getDocument() {
        return this.document;
    }

    @Generated
    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    @Generated
    public Sticker getSticker() {
        return this.sticker;
    }

    @Generated
    public Video getVideo() {
        return this.video;
    }

    @Generated
    public Contact getContact() {
        return this.contact;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public Venue getVenue() {
        return this.venue;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }

    @Generated
    public MaybeInaccessibleMessage getPinnedMessage() {
        return this.pinnedMessage;
    }

    @Generated
    public User getLeftChatMember() {
        return this.leftChatMember;
    }

    @Generated
    public String getNewChatTitle() {
        return this.newChatTitle;
    }

    @Generated
    public List<PhotoSize> getNewChatPhoto() {
        return this.newChatPhoto;
    }

    @Generated
    public Boolean getDeleteChatPhoto() {
        return this.deleteChatPhoto;
    }

    @Generated
    public Boolean getGroupchatCreated() {
        return this.groupchatCreated;
    }

    @Generated
    public Message getReplyToMessage() {
        return this.replyToMessage;
    }

    @Generated
    public Voice getVoice() {
        return this.voice;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public Boolean getSuperGroupCreated() {
        return this.superGroupCreated;
    }

    @Generated
    public Boolean getChannelChatCreated() {
        return this.channelChatCreated;
    }

    @Generated
    public Long getMigrateToChatId() {
        return this.migrateToChatId;
    }

    @Generated
    public Long getMigrateFromChatId() {
        return this.migrateFromChatId;
    }

    @Generated
    public Integer getEditDate() {
        return this.editDate;
    }

    @Generated
    public Game getGame() {
        return this.game;
    }

    @Generated
    public Integer getForwardFromMessageId() {
        return this.forwardFromMessageId;
    }

    @Generated
    public Invoice getInvoice() {
        return this.invoice;
    }

    @Generated
    public SuccessfulPayment getSuccessfulPayment() {
        return this.successfulPayment;
    }

    @Generated
    public VideoNote getVideoNote() {
        return this.videoNote;
    }

    @Generated
    public String getAuthorSignature() {
        return this.authorSignature;
    }

    @Generated
    public String getForwardSignature() {
        return this.forwardSignature;
    }

    @Generated
    public String getMediaGroupId() {
        return this.mediaGroupId;
    }

    @Generated
    public String getConnectedWebsite() {
        return this.connectedWebsite;
    }

    @Generated
    public PassportData getPassportData() {
        return this.passportData;
    }

    @Generated
    public String getForwardSenderName() {
        return this.forwardSenderName;
    }

    @Generated
    public Poll getPoll() {
        return this.poll;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public Dice getDice() {
        return this.dice;
    }

    @Generated
    public User getViaBot() {
        return this.viaBot;
    }

    @Generated
    public Chat getSenderChat() {
        return this.senderChat;
    }

    @Generated
    public ProximityAlertTriggered getProximityAlertTriggered() {
        return this.proximityAlertTriggered;
    }

    @Generated
    public MessageAutoDeleteTimerChanged getMessageAutoDeleteTimerChanged() {
        return this.messageAutoDeleteTimerChanged;
    }

    @Generated
    public Boolean getIsAutomaticForward() {
        return this.isAutomaticForward;
    }

    @Generated
    public Boolean getHasProtectedContent() {
        return this.hasProtectedContent;
    }

    @Generated
    public WebAppData getWebAppData() {
        return this.webAppData;
    }

    @Generated
    public VideoChatStarted getVideoChatStarted() {
        return this.videoChatStarted;
    }

    @Generated
    public VideoChatEnded getVideoChatEnded() {
        return this.videoChatEnded;
    }

    @Generated
    public VideoChatParticipantsInvited getVideoChatParticipantsInvited() {
        return this.videoChatParticipantsInvited;
    }

    @Generated
    public VideoChatScheduled getVideoChatScheduled() {
        return this.videoChatScheduled;
    }

    @Generated
    public Boolean getIsTopicMessage() {
        return this.isTopicMessage;
    }

    @Generated
    public ForumTopicCreated getForumTopicCreated() {
        return this.forumTopicCreated;
    }

    @Generated
    public ForumTopicClosed getForumTopicClosed() {
        return this.forumTopicClosed;
    }

    @Generated
    public ForumTopicReopened getForumTopicReopened() {
        return this.forumTopicReopened;
    }

    @Generated
    public ForumTopicEdited getForumTopicEdited() {
        return this.forumTopicEdited;
    }

    @Generated
    public GeneralForumTopicHidden getGeneralForumTopicHidden() {
        return this.generalForumTopicHidden;
    }

    @Generated
    public GeneralForumTopicUnhidden getGeneralForumTopicUnhidden() {
        return this.generalForumTopicUnhidden;
    }

    @Generated
    public WriteAccessAllowed getWriteAccessAllowed() {
        return this.writeAccessAllowed;
    }

    @Generated
    public Boolean getHasMediaSpoiler() {
        return this.hasMediaSpoiler;
    }

    @Generated
    public UserShared getUserShared() {
        return this.userShared;
    }

    @Generated
    public ChatShared getChatShared() {
        return this.chatShared;
    }

    @Generated
    public Story getStory() {
        return this.story;
    }

    @Generated
    public ExternalReplyInfo getExternalReplyInfo() {
        return this.externalReplyInfo;
    }

    @Generated
    public MessageOrigin getForwardOrigin() {
        return this.forwardOrigin;
    }

    @Generated
    public LinkPreviewOptions getLinkPreviewOptions() {
        return this.linkPreviewOptions;
    }

    @Generated
    public TextQuote getQuote() {
        return this.quote;
    }

    @Generated
    public UsersShared getUsersShared() {
        return this.usersShared;
    }

    @Generated
    public GiveawayCreated getGiveawayCreated() {
        return this.giveawayCreated;
    }

    @Generated
    public Giveaway getGiveaway() {
        return this.giveaway;
    }

    @Generated
    public GiveawayWinners getGiveawayWinners() {
        return this.giveawayWinners;
    }

    @Generated
    public GiveawayCompleted getGiveawayCompleted() {
        return this.giveawayCompleted;
    }

    @Generated
    public Story getReplyToStory() {
        return this.replyToStory;
    }

    @Generated
    public ChatBoostAdded getBoostAdded() {
        return this.boostAdded;
    }

    @Generated
    public Integer getSenderBoostCount() {
        return this.senderBoostCount;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Generated
    public User getSenderBusinessBot() {
        return this.senderBusinessBot;
    }

    @Generated
    public Boolean getIsFromOffline() {
        return this.isFromOffline;
    }

    @Generated
    public ChatBackground getChatBackgroundSet() {
        return this.chatBackgroundSet;
    }

    @Generated
    public String getEffectId() {
        return this.effectId;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @Generated
    public PaidMediaInfo getPaidMedia() {
        return this.paidMedia;
    }

    @Generated
    public RefundedPayment getRefundedPayment() {
        return this.refundedPayment;
    }

    @Generated
    public GiftInfo getGift() {
        return this.gift;
    }

    @Generated
    public UniqueGiftInfo getUniqueGift() {
        return this.uniqueGift;
    }

    @Generated
    public PaidMessagePriceChanged getPaidMessagePriceChanged() {
        return this.paidMessagePriceChanged;
    }

    @Generated
    public Integer getPaidStarCount() {
        return this.paidStarCount;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="from")
    @Generated
    public void setFrom(User from) {
        this.from = from;
    }

    @JsonProperty(value="date")
    @Generated
    public void setDate(Integer date) {
        this.date = date;
    }

    @JsonProperty(value="chat")
    @Generated
    public void setChat(Chat chat) {
        this.chat = chat;
    }

    @JsonProperty(value="forward_from")
    @Generated
    public void setForwardFrom(User forwardFrom) {
        this.forwardFrom = forwardFrom;
    }

    @JsonProperty(value="forward_from_chat")
    @Generated
    public void setForwardFromChat(Chat forwardFromChat) {
        this.forwardFromChat = forwardFromChat;
    }

    @JsonProperty(value="forward_date")
    @Generated
    public void setForwardDate(Integer forwardDate) {
        this.forwardDate = forwardDate;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="entities")
    @Generated
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="audio")
    @Generated
    public void setAudio(Audio audio) {
        this.audio = audio;
    }

    @JsonProperty(value="document")
    @Generated
    public void setDocument(Document document) {
        this.document = document;
    }

    @JsonProperty(value="photo")
    @Generated
    public void setPhoto(List<PhotoSize> photo) {
        this.photo = photo;
    }

    @JsonProperty(value="sticker")
    @Generated
    public void setSticker(Sticker sticker) {
        this.sticker = sticker;
    }

    @JsonProperty(value="video")
    @Generated
    public void setVideo(Video video) {
        this.video = video;
    }

    @JsonProperty(value="contact")
    @Generated
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @JsonProperty(value="location")
    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }

    @JsonProperty(value="venue")
    @Generated
    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    @JsonProperty(value="animation")
    @Generated
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @JsonProperty(value="pinned_message")
    @Generated
    public void setPinnedMessage(MaybeInaccessibleMessage pinnedMessage) {
        this.pinnedMessage = pinnedMessage;
    }

    @JsonProperty(value="new_chat_members")
    @Generated
    public void setNewChatMembers(List<User> newChatMembers) {
        this.newChatMembers = newChatMembers;
    }

    @JsonProperty(value="left_chat_member")
    @Generated
    public void setLeftChatMember(User leftChatMember) {
        this.leftChatMember = leftChatMember;
    }

    @JsonProperty(value="new_chat_title")
    @Generated
    public void setNewChatTitle(String newChatTitle) {
        this.newChatTitle = newChatTitle;
    }

    @JsonProperty(value="new_chat_photo")
    @Generated
    public void setNewChatPhoto(List<PhotoSize> newChatPhoto) {
        this.newChatPhoto = newChatPhoto;
    }

    @JsonProperty(value="delete_chat_photo")
    @Generated
    public void setDeleteChatPhoto(Boolean deleteChatPhoto) {
        this.deleteChatPhoto = deleteChatPhoto;
    }

    @JsonProperty(value="group_chat_created")
    @Generated
    public void setGroupchatCreated(Boolean groupchatCreated) {
        this.groupchatCreated = groupchatCreated;
    }

    @JsonProperty(value="reply_to_message")
    @Generated
    public void setReplyToMessage(Message replyToMessage) {
        this.replyToMessage = replyToMessage;
    }

    @JsonProperty(value="voice")
    @Generated
    public void setVoice(Voice voice) {
        this.voice = voice;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="supergroup_chat_created")
    @Generated
    public void setSuperGroupCreated(Boolean superGroupCreated) {
        this.superGroupCreated = superGroupCreated;
    }

    @JsonProperty(value="channel_chat_created")
    @Generated
    public void setChannelChatCreated(Boolean channelChatCreated) {
        this.channelChatCreated = channelChatCreated;
    }

    @JsonProperty(value="migrate_to_chat_id")
    @Generated
    public void setMigrateToChatId(Long migrateToChatId) {
        this.migrateToChatId = migrateToChatId;
    }

    @JsonProperty(value="migrate_from_chat_id")
    @Generated
    public void setMigrateFromChatId(Long migrateFromChatId) {
        this.migrateFromChatId = migrateFromChatId;
    }

    @JsonProperty(value="edit_date")
    @Generated
    public void setEditDate(Integer editDate) {
        this.editDate = editDate;
    }

    @JsonProperty(value="game")
    @Generated
    public void setGame(Game game) {
        this.game = game;
    }

    @JsonProperty(value="forward_from_message_id")
    @Generated
    public void setForwardFromMessageId(Integer forwardFromMessageId) {
        this.forwardFromMessageId = forwardFromMessageId;
    }

    @JsonProperty(value="invoice")
    @Generated
    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    @JsonProperty(value="successful_payment")
    @Generated
    public void setSuccessfulPayment(SuccessfulPayment successfulPayment) {
        this.successfulPayment = successfulPayment;
    }

    @JsonProperty(value="video_note")
    @Generated
    public void setVideoNote(VideoNote videoNote) {
        this.videoNote = videoNote;
    }

    @JsonProperty(value="author_signature")
    @Generated
    public void setAuthorSignature(String authorSignature) {
        this.authorSignature = authorSignature;
    }

    @JsonProperty(value="forward_signature")
    @Generated
    public void setForwardSignature(String forwardSignature) {
        this.forwardSignature = forwardSignature;
    }

    @JsonProperty(value="media_group_id")
    @Generated
    public void setMediaGroupId(String mediaGroupId) {
        this.mediaGroupId = mediaGroupId;
    }

    @JsonProperty(value="connected_website")
    @Generated
    public void setConnectedWebsite(String connectedWebsite) {
        this.connectedWebsite = connectedWebsite;
    }

    @JsonProperty(value="passport_data")
    @Generated
    public void setPassportData(PassportData passportData) {
        this.passportData = passportData;
    }

    @JsonProperty(value="forward_sender_name")
    @Generated
    public void setForwardSenderName(String forwardSenderName) {
        this.forwardSenderName = forwardSenderName;
    }

    @JsonProperty(value="poll")
    @Generated
    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="dice")
    @Generated
    public void setDice(Dice dice) {
        this.dice = dice;
    }

    @JsonProperty(value="via_bot")
    @Generated
    public void setViaBot(User viaBot) {
        this.viaBot = viaBot;
    }

    @JsonProperty(value="sender_chat")
    @Generated
    public void setSenderChat(Chat senderChat) {
        this.senderChat = senderChat;
    }

    @JsonProperty(value="proximity_alert_triggered")
    @Generated
    public void setProximityAlertTriggered(ProximityAlertTriggered proximityAlertTriggered) {
        this.proximityAlertTriggered = proximityAlertTriggered;
    }

    @JsonProperty(value="message_auto_delete_timer_changed")
    @Generated
    public void setMessageAutoDeleteTimerChanged(MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged) {
        this.messageAutoDeleteTimerChanged = messageAutoDeleteTimerChanged;
    }

    @JsonProperty(value="is_automatic_forward")
    @Generated
    public void setIsAutomaticForward(Boolean isAutomaticForward) {
        this.isAutomaticForward = isAutomaticForward;
    }

    @JsonProperty(value="has_protected_content")
    @Generated
    public void setHasProtectedContent(Boolean hasProtectedContent) {
        this.hasProtectedContent = hasProtectedContent;
    }

    @JsonProperty(value="web_app_data")
    @Generated
    public void setWebAppData(WebAppData webAppData) {
        this.webAppData = webAppData;
    }

    @JsonProperty(value="video_chat_started")
    @Generated
    public void setVideoChatStarted(VideoChatStarted videoChatStarted) {
        this.videoChatStarted = videoChatStarted;
    }

    @JsonProperty(value="video_chat_ended")
    @Generated
    public void setVideoChatEnded(VideoChatEnded videoChatEnded) {
        this.videoChatEnded = videoChatEnded;
    }

    @JsonProperty(value="video_chat_participants_invited")
    @Generated
    public void setVideoChatParticipantsInvited(VideoChatParticipantsInvited videoChatParticipantsInvited) {
        this.videoChatParticipantsInvited = videoChatParticipantsInvited;
    }

    @JsonProperty(value="video_chat_scheduled")
    @Generated
    public void setVideoChatScheduled(VideoChatScheduled videoChatScheduled) {
        this.videoChatScheduled = videoChatScheduled;
    }

    @JsonProperty(value="is_topic_message")
    @Generated
    public void setIsTopicMessage(Boolean isTopicMessage) {
        this.isTopicMessage = isTopicMessage;
    }

    @JsonProperty(value="forum_topic_created")
    @Generated
    public void setForumTopicCreated(ForumTopicCreated forumTopicCreated) {
        this.forumTopicCreated = forumTopicCreated;
    }

    @JsonProperty(value="forum_topic_closed")
    @Generated
    public void setForumTopicClosed(ForumTopicClosed forumTopicClosed) {
        this.forumTopicClosed = forumTopicClosed;
    }

    @JsonProperty(value="forum_topic_reopened")
    @Generated
    public void setForumTopicReopened(ForumTopicReopened forumTopicReopened) {
        this.forumTopicReopened = forumTopicReopened;
    }

    @JsonProperty(value="forum_topic_edited")
    @Generated
    public void setForumTopicEdited(ForumTopicEdited forumTopicEdited) {
        this.forumTopicEdited = forumTopicEdited;
    }

    @JsonProperty(value="general_forum_topic_hidden")
    @Generated
    public void setGeneralForumTopicHidden(GeneralForumTopicHidden generalForumTopicHidden) {
        this.generalForumTopicHidden = generalForumTopicHidden;
    }

    @JsonProperty(value="general_forum_topic_unhidden")
    @Generated
    public void setGeneralForumTopicUnhidden(GeneralForumTopicUnhidden generalForumTopicUnhidden) {
        this.generalForumTopicUnhidden = generalForumTopicUnhidden;
    }

    @JsonProperty(value="write_access_allowed")
    @Generated
    public void setWriteAccessAllowed(WriteAccessAllowed writeAccessAllowed) {
        this.writeAccessAllowed = writeAccessAllowed;
    }

    @JsonProperty(value="has_media_spoiler")
    @Generated
    public void setHasMediaSpoiler(Boolean hasMediaSpoiler) {
        this.hasMediaSpoiler = hasMediaSpoiler;
    }

    @JsonProperty(value="user_shared")
    @Generated
    public void setUserShared(UserShared userShared) {
        this.userShared = userShared;
    }

    @JsonProperty(value="chat_shared")
    @Generated
    public void setChatShared(ChatShared chatShared) {
        this.chatShared = chatShared;
    }

    @JsonProperty(value="story")
    @Generated
    public void setStory(Story story) {
        this.story = story;
    }

    @JsonProperty(value="external_reply")
    @Generated
    public void setExternalReplyInfo(ExternalReplyInfo externalReplyInfo) {
        this.externalReplyInfo = externalReplyInfo;
    }

    @JsonProperty(value="forward_origin")
    @Generated
    public void setForwardOrigin(MessageOrigin forwardOrigin) {
        this.forwardOrigin = forwardOrigin;
    }

    @JsonProperty(value="link_preview_options")
    @Generated
    public void setLinkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
        this.linkPreviewOptions = linkPreviewOptions;
    }

    @JsonProperty(value="quote")
    @Generated
    public void setQuote(TextQuote quote) {
        this.quote = quote;
    }

    @JsonProperty(value="users_shared")
    @Generated
    public void setUsersShared(UsersShared usersShared) {
        this.usersShared = usersShared;
    }

    @JsonProperty(value="giveaway_created")
    @Generated
    public void setGiveawayCreated(GiveawayCreated giveawayCreated) {
        this.giveawayCreated = giveawayCreated;
    }

    @JsonProperty(value="giveaway")
    @Generated
    public void setGiveaway(Giveaway giveaway) {
        this.giveaway = giveaway;
    }

    @JsonProperty(value="giveaway_winners")
    @Generated
    public void setGiveawayWinners(GiveawayWinners giveawayWinners) {
        this.giveawayWinners = giveawayWinners;
    }

    @JsonProperty(value="giveaway_completed")
    @Generated
    public void setGiveawayCompleted(GiveawayCompleted giveawayCompleted) {
        this.giveawayCompleted = giveawayCompleted;
    }

    @JsonProperty(value="reply_to_story")
    @Generated
    public void setReplyToStory(Story replyToStory) {
        this.replyToStory = replyToStory;
    }

    @JsonProperty(value="boost_added")
    @Generated
    public void setBoostAdded(ChatBoostAdded boostAdded) {
        this.boostAdded = boostAdded;
    }

    @JsonProperty(value="sender_boost_count")
    @Generated
    public void setSenderBoostCount(Integer senderBoostCount) {
        this.senderBoostCount = senderBoostCount;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="sender_business_bot")
    @Generated
    public void setSenderBusinessBot(User senderBusinessBot) {
        this.senderBusinessBot = senderBusinessBot;
    }

    @JsonProperty(value="is_from_offline")
    @Generated
    public void setIsFromOffline(Boolean isFromOffline) {
        this.isFromOffline = isFromOffline;
    }

    @JsonProperty(value="chat_background_set")
    @Generated
    public void setChatBackgroundSet(ChatBackground chatBackgroundSet) {
        this.chatBackgroundSet = chatBackgroundSet;
    }

    @JsonProperty(value="effect_id")
    @Generated
    public void setEffectId(String effectId) {
        this.effectId = effectId;
    }

    @JsonProperty(value="show_caption_above_media")
    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @JsonProperty(value="paid_media")
    @Generated
    public void setPaidMedia(PaidMediaInfo paidMedia) {
        this.paidMedia = paidMedia;
    }

    @JsonProperty(value="refunded_payment")
    @Generated
    public void setRefundedPayment(RefundedPayment refundedPayment) {
        this.refundedPayment = refundedPayment;
    }

    @JsonProperty(value="gift")
    @Generated
    public void setGift(GiftInfo gift) {
        this.gift = gift;
    }

    @JsonProperty(value="unique_gift")
    @Generated
    public void setUniqueGift(UniqueGiftInfo uniqueGift) {
        this.uniqueGift = uniqueGift;
    }

    @JsonProperty(value="paid_message_price_changed")
    @Generated
    public void setPaidMessagePriceChanged(PaidMessagePriceChanged paidMessagePriceChanged) {
        this.paidMessagePriceChanged = paidMessagePriceChanged;
    }

    @JsonProperty(value="paid_star_count")
    @Generated
    public void setPaidStarCount(Integer paidStarCount) {
        this.paidStarCount = paidStarCount;
    }

    @Generated
    public String toString() {
        return "Message(messageId=" + this.getMessageId() + ", messageThreadId=" + this.getMessageThreadId() + ", from=" + this.getFrom() + ", date=" + this.getDate() + ", chat=" + this.getChat() + ", forwardFrom=" + this.getForwardFrom() + ", forwardFromChat=" + this.getForwardFromChat() + ", forwardDate=" + this.getForwardDate() + ", text=" + this.getText() + ", entities=" + this.getEntities() + ", captionEntities=" + this.getCaptionEntities() + ", audio=" + this.getAudio() + ", document=" + this.getDocument() + ", photo=" + this.getPhoto() + ", sticker=" + this.getSticker() + ", video=" + this.getVideo() + ", contact=" + this.getContact() + ", location=" + this.getLocation() + ", venue=" + this.getVenue() + ", animation=" + this.getAnimation() + ", pinnedMessage=" + this.getPinnedMessage() + ", newChatMembers=" + this.getNewChatMembers() + ", leftChatMember=" + this.getLeftChatMember() + ", newChatTitle=" + this.getNewChatTitle() + ", newChatPhoto=" + this.getNewChatPhoto() + ", deleteChatPhoto=" + this.getDeleteChatPhoto() + ", groupchatCreated=" + this.getGroupchatCreated() + ", replyToMessage=" + this.getReplyToMessage() + ", voice=" + this.getVoice() + ", caption=" + this.getCaption() + ", superGroupCreated=" + this.getSuperGroupCreated() + ", channelChatCreated=" + this.getChannelChatCreated() + ", migrateToChatId=" + this.getMigrateToChatId() + ", migrateFromChatId=" + this.getMigrateFromChatId() + ", editDate=" + this.getEditDate() + ", game=" + this.getGame() + ", forwardFromMessageId=" + this.getForwardFromMessageId() + ", invoice=" + this.getInvoice() + ", successfulPayment=" + this.getSuccessfulPayment() + ", videoNote=" + this.getVideoNote() + ", authorSignature=" + this.getAuthorSignature() + ", forwardSignature=" + this.getForwardSignature() + ", mediaGroupId=" + this.getMediaGroupId() + ", connectedWebsite=" + this.getConnectedWebsite() + ", passportData=" + this.getPassportData() + ", forwardSenderName=" + this.getForwardSenderName() + ", poll=" + this.getPoll() + ", replyMarkup=" + this.getReplyMarkup() + ", dice=" + this.getDice() + ", viaBot=" + this.getViaBot() + ", senderChat=" + this.getSenderChat() + ", proximityAlertTriggered=" + this.getProximityAlertTriggered() + ", messageAutoDeleteTimerChanged=" + this.getMessageAutoDeleteTimerChanged() + ", isAutomaticForward=" + this.getIsAutomaticForward() + ", hasProtectedContent=" + this.getHasProtectedContent() + ", webAppData=" + this.getWebAppData() + ", videoChatStarted=" + this.getVideoChatStarted() + ", videoChatEnded=" + this.getVideoChatEnded() + ", videoChatParticipantsInvited=" + this.getVideoChatParticipantsInvited() + ", videoChatScheduled=" + this.getVideoChatScheduled() + ", isTopicMessage=" + this.getIsTopicMessage() + ", forumTopicCreated=" + this.getForumTopicCreated() + ", forumTopicClosed=" + this.getForumTopicClosed() + ", forumTopicReopened=" + this.getForumTopicReopened() + ", forumTopicEdited=" + this.getForumTopicEdited() + ", generalForumTopicHidden=" + this.getGeneralForumTopicHidden() + ", generalForumTopicUnhidden=" + this.getGeneralForumTopicUnhidden() + ", writeAccessAllowed=" + this.getWriteAccessAllowed() + ", hasMediaSpoiler=" + this.getHasMediaSpoiler() + ", userShared=" + this.getUserShared() + ", chatShared=" + this.getChatShared() + ", story=" + this.getStory() + ", externalReplyInfo=" + this.getExternalReplyInfo() + ", forwardOrigin=" + this.getForwardOrigin() + ", linkPreviewOptions=" + this.getLinkPreviewOptions() + ", quote=" + this.getQuote() + ", usersShared=" + this.getUsersShared() + ", giveawayCreated=" + this.getGiveawayCreated() + ", giveaway=" + this.getGiveaway() + ", giveawayWinners=" + this.getGiveawayWinners() + ", giveawayCompleted=" + this.getGiveawayCompleted() + ", replyToStory=" + this.getReplyToStory() + ", boostAdded=" + this.getBoostAdded() + ", senderBoostCount=" + this.getSenderBoostCount() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", senderBusinessBot=" + this.getSenderBusinessBot() + ", isFromOffline=" + this.getIsFromOffline() + ", chatBackgroundSet=" + this.getChatBackgroundSet() + ", effectId=" + this.getEffectId() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", paidMedia=" + this.getPaidMedia() + ", refundedPayment=" + this.getRefundedPayment() + ", gift=" + this.getGift() + ", uniqueGift=" + this.getUniqueGift() + ", paidMessagePriceChanged=" + this.getPaidMessagePriceChanged() + ", paidStarCount=" + this.getPaidStarCount() + ")";
    }

    @Generated
    public Message() {
    }

    @Generated
    public Message(Integer messageId, Integer messageThreadId, User from, Integer date, Chat chat, User forwardFrom, Chat forwardFromChat, Integer forwardDate, String text, List<MessageEntity> entities, List<MessageEntity> captionEntities, Audio audio, Document document, List<PhotoSize> photo, Sticker sticker, Video video, Contact contact, Location location, Venue venue, Animation animation, MaybeInaccessibleMessage pinnedMessage, List<User> newChatMembers, User leftChatMember, String newChatTitle, List<PhotoSize> newChatPhoto, Boolean deleteChatPhoto, Boolean groupchatCreated, Message replyToMessage, Voice voice, String caption, Boolean superGroupCreated, Boolean channelChatCreated, Long migrateToChatId, Long migrateFromChatId, Integer editDate, Game game, Integer forwardFromMessageId, Invoice invoice, SuccessfulPayment successfulPayment, VideoNote videoNote, String authorSignature, String forwardSignature, String mediaGroupId, String connectedWebsite, PassportData passportData, String forwardSenderName, Poll poll, InlineKeyboardMarkup replyMarkup, Dice dice, User viaBot, Chat senderChat, ProximityAlertTriggered proximityAlertTriggered, MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged, Boolean isAutomaticForward, Boolean hasProtectedContent, WebAppData webAppData, VideoChatStarted videoChatStarted, VideoChatEnded videoChatEnded, VideoChatParticipantsInvited videoChatParticipantsInvited, VideoChatScheduled videoChatScheduled, Boolean isTopicMessage, ForumTopicCreated forumTopicCreated, ForumTopicClosed forumTopicClosed, ForumTopicReopened forumTopicReopened, ForumTopicEdited forumTopicEdited, GeneralForumTopicHidden generalForumTopicHidden, GeneralForumTopicUnhidden generalForumTopicUnhidden, WriteAccessAllowed writeAccessAllowed, Boolean hasMediaSpoiler, UserShared userShared, ChatShared chatShared, Story story, ExternalReplyInfo externalReplyInfo, MessageOrigin forwardOrigin, LinkPreviewOptions linkPreviewOptions, TextQuote quote, UsersShared usersShared, GiveawayCreated giveawayCreated, Giveaway giveaway, GiveawayWinners giveawayWinners, GiveawayCompleted giveawayCompleted, Story replyToStory, ChatBoostAdded boostAdded, Integer senderBoostCount, String businessConnectionId, User senderBusinessBot, Boolean isFromOffline, ChatBackground chatBackgroundSet, String effectId, Boolean showCaptionAboveMedia, PaidMediaInfo paidMedia, RefundedPayment refundedPayment, GiftInfo gift, UniqueGiftInfo uniqueGift, PaidMessagePriceChanged paidMessagePriceChanged, Integer paidStarCount) {
        this.messageId = messageId;
        this.messageThreadId = messageThreadId;
        this.from = from;
        this.date = date;
        this.chat = chat;
        this.forwardFrom = forwardFrom;
        this.forwardFromChat = forwardFromChat;
        this.forwardDate = forwardDate;
        this.text = text;
        this.entities = entities;
        this.captionEntities = captionEntities;
        this.audio = audio;
        this.document = document;
        this.photo = photo;
        this.sticker = sticker;
        this.video = video;
        this.contact = contact;
        this.location = location;
        this.venue = venue;
        this.animation = animation;
        this.pinnedMessage = pinnedMessage;
        this.newChatMembers = newChatMembers;
        this.leftChatMember = leftChatMember;
        this.newChatTitle = newChatTitle;
        this.newChatPhoto = newChatPhoto;
        this.deleteChatPhoto = deleteChatPhoto;
        this.groupchatCreated = groupchatCreated;
        this.replyToMessage = replyToMessage;
        this.voice = voice;
        this.caption = caption;
        this.superGroupCreated = superGroupCreated;
        this.channelChatCreated = channelChatCreated;
        this.migrateToChatId = migrateToChatId;
        this.migrateFromChatId = migrateFromChatId;
        this.editDate = editDate;
        this.game = game;
        this.forwardFromMessageId = forwardFromMessageId;
        this.invoice = invoice;
        this.successfulPayment = successfulPayment;
        this.videoNote = videoNote;
        this.authorSignature = authorSignature;
        this.forwardSignature = forwardSignature;
        this.mediaGroupId = mediaGroupId;
        this.connectedWebsite = connectedWebsite;
        this.passportData = passportData;
        this.forwardSenderName = forwardSenderName;
        this.poll = poll;
        this.replyMarkup = replyMarkup;
        this.dice = dice;
        this.viaBot = viaBot;
        this.senderChat = senderChat;
        this.proximityAlertTriggered = proximityAlertTriggered;
        this.messageAutoDeleteTimerChanged = messageAutoDeleteTimerChanged;
        this.isAutomaticForward = isAutomaticForward;
        this.hasProtectedContent = hasProtectedContent;
        this.webAppData = webAppData;
        this.videoChatStarted = videoChatStarted;
        this.videoChatEnded = videoChatEnded;
        this.videoChatParticipantsInvited = videoChatParticipantsInvited;
        this.videoChatScheduled = videoChatScheduled;
        this.isTopicMessage = isTopicMessage;
        this.forumTopicCreated = forumTopicCreated;
        this.forumTopicClosed = forumTopicClosed;
        this.forumTopicReopened = forumTopicReopened;
        this.forumTopicEdited = forumTopicEdited;
        this.generalForumTopicHidden = generalForumTopicHidden;
        this.generalForumTopicUnhidden = generalForumTopicUnhidden;
        this.writeAccessAllowed = writeAccessAllowed;
        this.hasMediaSpoiler = hasMediaSpoiler;
        this.userShared = userShared;
        this.chatShared = chatShared;
        this.story = story;
        this.externalReplyInfo = externalReplyInfo;
        this.forwardOrigin = forwardOrigin;
        this.linkPreviewOptions = linkPreviewOptions;
        this.quote = quote;
        this.usersShared = usersShared;
        this.giveawayCreated = giveawayCreated;
        this.giveaway = giveaway;
        this.giveawayWinners = giveawayWinners;
        this.giveawayCompleted = giveawayCompleted;
        this.replyToStory = replyToStory;
        this.boostAdded = boostAdded;
        this.senderBoostCount = senderBoostCount;
        this.businessConnectionId = businessConnectionId;
        this.senderBusinessBot = senderBusinessBot;
        this.isFromOffline = isFromOffline;
        this.chatBackgroundSet = chatBackgroundSet;
        this.effectId = effectId;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.paidMedia = paidMedia;
        this.refundedPayment = refundedPayment;
        this.gift = gift;
        this.uniqueGift = uniqueGift;
        this.paidMessagePriceChanged = paidMessagePriceChanged;
        this.paidStarCount = paidStarCount;
    }

    @Generated
    public static abstract class MessageBuilder<C extends Message, B extends MessageBuilder<C, B>> {
        @Generated
        private Integer messageId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private User from;
        @Generated
        private Integer date;
        @Generated
        private Chat chat;
        @Generated
        private User forwardFrom;
        @Generated
        private Chat forwardFromChat;
        @Generated
        private Integer forwardDate;
        @Generated
        private String text;
        @Generated
        private List<MessageEntity> entities;
        @Generated
        private List<MessageEntity> captionEntities;
        @Generated
        private Audio audio;
        @Generated
        private Document document;
        @Generated
        private List<PhotoSize> photo;
        @Generated
        private Sticker sticker;
        @Generated
        private Video video;
        @Generated
        private Contact contact;
        @Generated
        private Location location;
        @Generated
        private Venue venue;
        @Generated
        private Animation animation;
        @Generated
        private MaybeInaccessibleMessage pinnedMessage;
        @Generated
        private List<User> newChatMembers;
        @Generated
        private User leftChatMember;
        @Generated
        private String newChatTitle;
        @Generated
        private List<PhotoSize> newChatPhoto;
        @Generated
        private Boolean deleteChatPhoto;
        @Generated
        private Boolean groupchatCreated;
        @Generated
        private Message replyToMessage;
        @Generated
        private Voice voice;
        @Generated
        private String caption;
        @Generated
        private Boolean superGroupCreated;
        @Generated
        private Boolean channelChatCreated;
        @Generated
        private Long migrateToChatId;
        @Generated
        private Long migrateFromChatId;
        @Generated
        private Integer editDate;
        @Generated
        private Game game;
        @Generated
        private Integer forwardFromMessageId;
        @Generated
        private Invoice invoice;
        @Generated
        private SuccessfulPayment successfulPayment;
        @Generated
        private VideoNote videoNote;
        @Generated
        private String authorSignature;
        @Generated
        private String forwardSignature;
        @Generated
        private String mediaGroupId;
        @Generated
        private String connectedWebsite;
        @Generated
        private PassportData passportData;
        @Generated
        private String forwardSenderName;
        @Generated
        private Poll poll;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private Dice dice;
        @Generated
        private User viaBot;
        @Generated
        private Chat senderChat;
        @Generated
        private ProximityAlertTriggered proximityAlertTriggered;
        @Generated
        private MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged;
        @Generated
        private Boolean isAutomaticForward;
        @Generated
        private Boolean hasProtectedContent;
        @Generated
        private WebAppData webAppData;
        @Generated
        private VideoChatStarted videoChatStarted;
        @Generated
        private VideoChatEnded videoChatEnded;
        @Generated
        private VideoChatParticipantsInvited videoChatParticipantsInvited;
        @Generated
        private VideoChatScheduled videoChatScheduled;
        @Generated
        private Boolean isTopicMessage;
        @Generated
        private ForumTopicCreated forumTopicCreated;
        @Generated
        private ForumTopicClosed forumTopicClosed;
        @Generated
        private ForumTopicReopened forumTopicReopened;
        @Generated
        private ForumTopicEdited forumTopicEdited;
        @Generated
        private GeneralForumTopicHidden generalForumTopicHidden;
        @Generated
        private GeneralForumTopicUnhidden generalForumTopicUnhidden;
        @Generated
        private WriteAccessAllowed writeAccessAllowed;
        @Generated
        private Boolean hasMediaSpoiler;
        @Generated
        private UserShared userShared;
        @Generated
        private ChatShared chatShared;
        @Generated
        private Story story;
        @Generated
        private ExternalReplyInfo externalReplyInfo;
        @Generated
        private MessageOrigin forwardOrigin;
        @Generated
        private LinkPreviewOptions linkPreviewOptions;
        @Generated
        private TextQuote quote;
        @Generated
        private UsersShared usersShared;
        @Generated
        private GiveawayCreated giveawayCreated;
        @Generated
        private Giveaway giveaway;
        @Generated
        private GiveawayWinners giveawayWinners;
        @Generated
        private GiveawayCompleted giveawayCompleted;
        @Generated
        private Story replyToStory;
        @Generated
        private ChatBoostAdded boostAdded;
        @Generated
        private Integer senderBoostCount;
        @Generated
        private String businessConnectionId;
        @Generated
        private User senderBusinessBot;
        @Generated
        private Boolean isFromOffline;
        @Generated
        private ChatBackground chatBackgroundSet;
        @Generated
        private String effectId;
        @Generated
        private Boolean showCaptionAboveMedia;
        @Generated
        private PaidMediaInfo paidMedia;
        @Generated
        private RefundedPayment refundedPayment;
        @Generated
        private GiftInfo gift;
        @Generated
        private UniqueGiftInfo uniqueGift;
        @Generated
        private PaidMessagePriceChanged paidMessagePriceChanged;
        @Generated
        private Integer paidStarCount;

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this.self();
        }

        @JsonProperty(value="from")
        @Generated
        public B from(User from) {
            this.from = from;
            return this.self();
        }

        @JsonProperty(value="date")
        @Generated
        public B date(Integer date) {
            this.date = date;
            return this.self();
        }

        @JsonProperty(value="chat")
        @Generated
        public B chat(Chat chat) {
            this.chat = chat;
            return this.self();
        }

        @JsonProperty(value="forward_from")
        @Generated
        public B forwardFrom(User forwardFrom) {
            this.forwardFrom = forwardFrom;
            return this.self();
        }

        @JsonProperty(value="forward_from_chat")
        @Generated
        public B forwardFromChat(Chat forwardFromChat) {
            this.forwardFromChat = forwardFromChat;
            return this.self();
        }

        @JsonProperty(value="forward_date")
        @Generated
        public B forwardDate(Integer forwardDate) {
            this.forwardDate = forwardDate;
            return this.self();
        }

        @JsonProperty(value="text")
        @Generated
        public B text(String text) {
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="entities")
        @Generated
        public B entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this.self();
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public B captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return this.self();
        }

        @JsonProperty(value="audio")
        @Generated
        public B audio(Audio audio) {
            this.audio = audio;
            return this.self();
        }

        @JsonProperty(value="document")
        @Generated
        public B document(Document document) {
            this.document = document;
            return this.self();
        }

        @JsonProperty(value="photo")
        @Generated
        public B photo(List<PhotoSize> photo) {
            this.photo = photo;
            return this.self();
        }

        @JsonProperty(value="sticker")
        @Generated
        public B sticker(Sticker sticker) {
            this.sticker = sticker;
            return this.self();
        }

        @JsonProperty(value="video")
        @Generated
        public B video(Video video) {
            this.video = video;
            return this.self();
        }

        @JsonProperty(value="contact")
        @Generated
        public B contact(Contact contact) {
            this.contact = contact;
            return this.self();
        }

        @JsonProperty(value="location")
        @Generated
        public B location(Location location) {
            this.location = location;
            return this.self();
        }

        @JsonProperty(value="venue")
        @Generated
        public B venue(Venue venue) {
            this.venue = venue;
            return this.self();
        }

        @JsonProperty(value="animation")
        @Generated
        public B animation(Animation animation) {
            this.animation = animation;
            return this.self();
        }

        @JsonProperty(value="pinned_message")
        @Generated
        public B pinnedMessage(MaybeInaccessibleMessage pinnedMessage) {
            this.pinnedMessage = pinnedMessage;
            return this.self();
        }

        @JsonProperty(value="new_chat_members")
        @Generated
        public B newChatMembers(List<User> newChatMembers) {
            this.newChatMembers = newChatMembers;
            return this.self();
        }

        @JsonProperty(value="left_chat_member")
        @Generated
        public B leftChatMember(User leftChatMember) {
            this.leftChatMember = leftChatMember;
            return this.self();
        }

        @JsonProperty(value="new_chat_title")
        @Generated
        public B newChatTitle(String newChatTitle) {
            this.newChatTitle = newChatTitle;
            return this.self();
        }

        @JsonProperty(value="new_chat_photo")
        @Generated
        public B newChatPhoto(List<PhotoSize> newChatPhoto) {
            this.newChatPhoto = newChatPhoto;
            return this.self();
        }

        @JsonProperty(value="delete_chat_photo")
        @Generated
        public B deleteChatPhoto(Boolean deleteChatPhoto) {
            this.deleteChatPhoto = deleteChatPhoto;
            return this.self();
        }

        @JsonProperty(value="group_chat_created")
        @Generated
        public B groupchatCreated(Boolean groupchatCreated) {
            this.groupchatCreated = groupchatCreated;
            return this.self();
        }

        @JsonProperty(value="reply_to_message")
        @Generated
        public B replyToMessage(Message replyToMessage) {
            this.replyToMessage = replyToMessage;
            return this.self();
        }

        @JsonProperty(value="voice")
        @Generated
        public B voice(Voice voice) {
            this.voice = voice;
            return this.self();
        }

        @JsonProperty(value="caption")
        @Generated
        public B caption(String caption) {
            this.caption = caption;
            return this.self();
        }

        @JsonProperty(value="supergroup_chat_created")
        @Generated
        public B superGroupCreated(Boolean superGroupCreated) {
            this.superGroupCreated = superGroupCreated;
            return this.self();
        }

        @JsonProperty(value="channel_chat_created")
        @Generated
        public B channelChatCreated(Boolean channelChatCreated) {
            this.channelChatCreated = channelChatCreated;
            return this.self();
        }

        @JsonProperty(value="migrate_to_chat_id")
        @Generated
        public B migrateToChatId(Long migrateToChatId) {
            this.migrateToChatId = migrateToChatId;
            return this.self();
        }

        @JsonProperty(value="migrate_from_chat_id")
        @Generated
        public B migrateFromChatId(Long migrateFromChatId) {
            this.migrateFromChatId = migrateFromChatId;
            return this.self();
        }

        @JsonProperty(value="edit_date")
        @Generated
        public B editDate(Integer editDate) {
            this.editDate = editDate;
            return this.self();
        }

        @JsonProperty(value="game")
        @Generated
        public B game(Game game) {
            this.game = game;
            return this.self();
        }

        @JsonProperty(value="forward_from_message_id")
        @Generated
        public B forwardFromMessageId(Integer forwardFromMessageId) {
            this.forwardFromMessageId = forwardFromMessageId;
            return this.self();
        }

        @JsonProperty(value="invoice")
        @Generated
        public B invoice(Invoice invoice) {
            this.invoice = invoice;
            return this.self();
        }

        @JsonProperty(value="successful_payment")
        @Generated
        public B successfulPayment(SuccessfulPayment successfulPayment) {
            this.successfulPayment = successfulPayment;
            return this.self();
        }

        @JsonProperty(value="video_note")
        @Generated
        public B videoNote(VideoNote videoNote) {
            this.videoNote = videoNote;
            return this.self();
        }

        @JsonProperty(value="author_signature")
        @Generated
        public B authorSignature(String authorSignature) {
            this.authorSignature = authorSignature;
            return this.self();
        }

        @JsonProperty(value="forward_signature")
        @Generated
        public B forwardSignature(String forwardSignature) {
            this.forwardSignature = forwardSignature;
            return this.self();
        }

        @JsonProperty(value="media_group_id")
        @Generated
        public B mediaGroupId(String mediaGroupId) {
            this.mediaGroupId = mediaGroupId;
            return this.self();
        }

        @JsonProperty(value="connected_website")
        @Generated
        public B connectedWebsite(String connectedWebsite) {
            this.connectedWebsite = connectedWebsite;
            return this.self();
        }

        @JsonProperty(value="passport_data")
        @Generated
        public B passportData(PassportData passportData) {
            this.passportData = passportData;
            return this.self();
        }

        @JsonProperty(value="forward_sender_name")
        @Generated
        public B forwardSenderName(String forwardSenderName) {
            this.forwardSenderName = forwardSenderName;
            return this.self();
        }

        @JsonProperty(value="poll")
        @Generated
        public B poll(Poll poll) {
            this.poll = poll;
            return this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this.self();
        }

        @JsonProperty(value="dice")
        @Generated
        public B dice(Dice dice) {
            this.dice = dice;
            return this.self();
        }

        @JsonProperty(value="via_bot")
        @Generated
        public B viaBot(User viaBot) {
            this.viaBot = viaBot;
            return this.self();
        }

        @JsonProperty(value="sender_chat")
        @Generated
        public B senderChat(Chat senderChat) {
            this.senderChat = senderChat;
            return this.self();
        }

        @JsonProperty(value="proximity_alert_triggered")
        @Generated
        public B proximityAlertTriggered(ProximityAlertTriggered proximityAlertTriggered) {
            this.proximityAlertTriggered = proximityAlertTriggered;
            return this.self();
        }

        @JsonProperty(value="message_auto_delete_timer_changed")
        @Generated
        public B messageAutoDeleteTimerChanged(MessageAutoDeleteTimerChanged messageAutoDeleteTimerChanged) {
            this.messageAutoDeleteTimerChanged = messageAutoDeleteTimerChanged;
            return this.self();
        }

        @JsonProperty(value="is_automatic_forward")
        @Generated
        public B isAutomaticForward(Boolean isAutomaticForward) {
            this.isAutomaticForward = isAutomaticForward;
            return this.self();
        }

        @JsonProperty(value="has_protected_content")
        @Generated
        public B hasProtectedContent(Boolean hasProtectedContent) {
            this.hasProtectedContent = hasProtectedContent;
            return this.self();
        }

        @JsonProperty(value="web_app_data")
        @Generated
        public B webAppData(WebAppData webAppData) {
            this.webAppData = webAppData;
            return this.self();
        }

        @JsonProperty(value="video_chat_started")
        @Generated
        public B videoChatStarted(VideoChatStarted videoChatStarted) {
            this.videoChatStarted = videoChatStarted;
            return this.self();
        }

        @JsonProperty(value="video_chat_ended")
        @Generated
        public B videoChatEnded(VideoChatEnded videoChatEnded) {
            this.videoChatEnded = videoChatEnded;
            return this.self();
        }

        @JsonProperty(value="video_chat_participants_invited")
        @Generated
        public B videoChatParticipantsInvited(VideoChatParticipantsInvited videoChatParticipantsInvited) {
            this.videoChatParticipantsInvited = videoChatParticipantsInvited;
            return this.self();
        }

        @JsonProperty(value="video_chat_scheduled")
        @Generated
        public B videoChatScheduled(VideoChatScheduled videoChatScheduled) {
            this.videoChatScheduled = videoChatScheduled;
            return this.self();
        }

        @JsonProperty(value="is_topic_message")
        @Generated
        public B isTopicMessage(Boolean isTopicMessage) {
            this.isTopicMessage = isTopicMessage;
            return this.self();
        }

        @JsonProperty(value="forum_topic_created")
        @Generated
        public B forumTopicCreated(ForumTopicCreated forumTopicCreated) {
            this.forumTopicCreated = forumTopicCreated;
            return this.self();
        }

        @JsonProperty(value="forum_topic_closed")
        @Generated
        public B forumTopicClosed(ForumTopicClosed forumTopicClosed) {
            this.forumTopicClosed = forumTopicClosed;
            return this.self();
        }

        @JsonProperty(value="forum_topic_reopened")
        @Generated
        public B forumTopicReopened(ForumTopicReopened forumTopicReopened) {
            this.forumTopicReopened = forumTopicReopened;
            return this.self();
        }

        @JsonProperty(value="forum_topic_edited")
        @Generated
        public B forumTopicEdited(ForumTopicEdited forumTopicEdited) {
            this.forumTopicEdited = forumTopicEdited;
            return this.self();
        }

        @JsonProperty(value="general_forum_topic_hidden")
        @Generated
        public B generalForumTopicHidden(GeneralForumTopicHidden generalForumTopicHidden) {
            this.generalForumTopicHidden = generalForumTopicHidden;
            return this.self();
        }

        @JsonProperty(value="general_forum_topic_unhidden")
        @Generated
        public B generalForumTopicUnhidden(GeneralForumTopicUnhidden generalForumTopicUnhidden) {
            this.generalForumTopicUnhidden = generalForumTopicUnhidden;
            return this.self();
        }

        @JsonProperty(value="write_access_allowed")
        @Generated
        public B writeAccessAllowed(WriteAccessAllowed writeAccessAllowed) {
            this.writeAccessAllowed = writeAccessAllowed;
            return this.self();
        }

        @JsonProperty(value="has_media_spoiler")
        @Generated
        public B hasMediaSpoiler(Boolean hasMediaSpoiler) {
            this.hasMediaSpoiler = hasMediaSpoiler;
            return this.self();
        }

        @JsonProperty(value="user_shared")
        @Generated
        public B userShared(UserShared userShared) {
            this.userShared = userShared;
            return this.self();
        }

        @JsonProperty(value="chat_shared")
        @Generated
        public B chatShared(ChatShared chatShared) {
            this.chatShared = chatShared;
            return this.self();
        }

        @JsonProperty(value="story")
        @Generated
        public B story(Story story) {
            this.story = story;
            return this.self();
        }

        @JsonProperty(value="external_reply")
        @Generated
        public B externalReplyInfo(ExternalReplyInfo externalReplyInfo) {
            this.externalReplyInfo = externalReplyInfo;
            return this.self();
        }

        @JsonProperty(value="forward_origin")
        @Generated
        public B forwardOrigin(MessageOrigin forwardOrigin) {
            this.forwardOrigin = forwardOrigin;
            return this.self();
        }

        @JsonProperty(value="link_preview_options")
        @Generated
        public B linkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
            this.linkPreviewOptions = linkPreviewOptions;
            return this.self();
        }

        @JsonProperty(value="quote")
        @Generated
        public B quote(TextQuote quote) {
            this.quote = quote;
            return this.self();
        }

        @JsonProperty(value="users_shared")
        @Generated
        public B usersShared(UsersShared usersShared) {
            this.usersShared = usersShared;
            return this.self();
        }

        @JsonProperty(value="giveaway_created")
        @Generated
        public B giveawayCreated(GiveawayCreated giveawayCreated) {
            this.giveawayCreated = giveawayCreated;
            return this.self();
        }

        @JsonProperty(value="giveaway")
        @Generated
        public B giveaway(Giveaway giveaway) {
            this.giveaway = giveaway;
            return this.self();
        }

        @JsonProperty(value="giveaway_winners")
        @Generated
        public B giveawayWinners(GiveawayWinners giveawayWinners) {
            this.giveawayWinners = giveawayWinners;
            return this.self();
        }

        @JsonProperty(value="giveaway_completed")
        @Generated
        public B giveawayCompleted(GiveawayCompleted giveawayCompleted) {
            this.giveawayCompleted = giveawayCompleted;
            return this.self();
        }

        @JsonProperty(value="reply_to_story")
        @Generated
        public B replyToStory(Story replyToStory) {
            this.replyToStory = replyToStory;
            return this.self();
        }

        @JsonProperty(value="boost_added")
        @Generated
        public B boostAdded(ChatBoostAdded boostAdded) {
            this.boostAdded = boostAdded;
            return this.self();
        }

        @JsonProperty(value="sender_boost_count")
        @Generated
        public B senderBoostCount(Integer senderBoostCount) {
            this.senderBoostCount = senderBoostCount;
            return this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return this.self();
        }

        @JsonProperty(value="sender_business_bot")
        @Generated
        public B senderBusinessBot(User senderBusinessBot) {
            this.senderBusinessBot = senderBusinessBot;
            return this.self();
        }

        @JsonProperty(value="is_from_offline")
        @Generated
        public B isFromOffline(Boolean isFromOffline) {
            this.isFromOffline = isFromOffline;
            return this.self();
        }

        @JsonProperty(value="chat_background_set")
        @Generated
        public B chatBackgroundSet(ChatBackground chatBackgroundSet) {
            this.chatBackgroundSet = chatBackgroundSet;
            return this.self();
        }

        @JsonProperty(value="effect_id")
        @Generated
        public B effectId(String effectId) {
            this.effectId = effectId;
            return this.self();
        }

        @JsonProperty(value="show_caption_above_media")
        @Generated
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return this.self();
        }

        @JsonProperty(value="paid_media")
        @Generated
        public B paidMedia(PaidMediaInfo paidMedia) {
            this.paidMedia = paidMedia;
            return this.self();
        }

        @JsonProperty(value="refunded_payment")
        @Generated
        public B refundedPayment(RefundedPayment refundedPayment) {
            this.refundedPayment = refundedPayment;
            return this.self();
        }

        @JsonProperty(value="gift")
        @Generated
        public B gift(GiftInfo gift) {
            this.gift = gift;
            return this.self();
        }

        @JsonProperty(value="unique_gift")
        @Generated
        public B uniqueGift(UniqueGiftInfo uniqueGift) {
            this.uniqueGift = uniqueGift;
            return this.self();
        }

        @JsonProperty(value="paid_message_price_changed")
        @Generated
        public B paidMessagePriceChanged(PaidMessagePriceChanged paidMessagePriceChanged) {
            this.paidMessagePriceChanged = paidMessagePriceChanged;
            return this.self();
        }

        @JsonProperty(value="paid_star_count")
        @Generated
        public B paidStarCount(Integer paidStarCount) {
            this.paidStarCount = paidStarCount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Message.MessageBuilder(messageId=" + this.messageId + ", messageThreadId=" + this.messageThreadId + ", from=" + this.from + ", date=" + this.date + ", chat=" + this.chat + ", forwardFrom=" + this.forwardFrom + ", forwardFromChat=" + this.forwardFromChat + ", forwardDate=" + this.forwardDate + ", text=" + this.text + ", entities=" + this.entities + ", captionEntities=" + this.captionEntities + ", audio=" + this.audio + ", document=" + this.document + ", photo=" + this.photo + ", sticker=" + this.sticker + ", video=" + this.video + ", contact=" + this.contact + ", location=" + this.location + ", venue=" + this.venue + ", animation=" + this.animation + ", pinnedMessage=" + this.pinnedMessage + ", newChatMembers=" + this.newChatMembers + ", leftChatMember=" + this.leftChatMember + ", newChatTitle=" + this.newChatTitle + ", newChatPhoto=" + this.newChatPhoto + ", deleteChatPhoto=" + this.deleteChatPhoto + ", groupchatCreated=" + this.groupchatCreated + ", replyToMessage=" + this.replyToMessage + ", voice=" + this.voice + ", caption=" + this.caption + ", superGroupCreated=" + this.superGroupCreated + ", channelChatCreated=" + this.channelChatCreated + ", migrateToChatId=" + this.migrateToChatId + ", migrateFromChatId=" + this.migrateFromChatId + ", editDate=" + this.editDate + ", game=" + this.game + ", forwardFromMessageId=" + this.forwardFromMessageId + ", invoice=" + this.invoice + ", successfulPayment=" + this.successfulPayment + ", videoNote=" + this.videoNote + ", authorSignature=" + this.authorSignature + ", forwardSignature=" + this.forwardSignature + ", mediaGroupId=" + this.mediaGroupId + ", connectedWebsite=" + this.connectedWebsite + ", passportData=" + this.passportData + ", forwardSenderName=" + this.forwardSenderName + ", poll=" + this.poll + ", replyMarkup=" + this.replyMarkup + ", dice=" + this.dice + ", viaBot=" + this.viaBot + ", senderChat=" + this.senderChat + ", proximityAlertTriggered=" + this.proximityAlertTriggered + ", messageAutoDeleteTimerChanged=" + this.messageAutoDeleteTimerChanged + ", isAutomaticForward=" + this.isAutomaticForward + ", hasProtectedContent=" + this.hasProtectedContent + ", webAppData=" + this.webAppData + ", videoChatStarted=" + this.videoChatStarted + ", videoChatEnded=" + this.videoChatEnded + ", videoChatParticipantsInvited=" + this.videoChatParticipantsInvited + ", videoChatScheduled=" + this.videoChatScheduled + ", isTopicMessage=" + this.isTopicMessage + ", forumTopicCreated=" + this.forumTopicCreated + ", forumTopicClosed=" + this.forumTopicClosed + ", forumTopicReopened=" + this.forumTopicReopened + ", forumTopicEdited=" + this.forumTopicEdited + ", generalForumTopicHidden=" + this.generalForumTopicHidden + ", generalForumTopicUnhidden=" + this.generalForumTopicUnhidden + ", writeAccessAllowed=" + this.writeAccessAllowed + ", hasMediaSpoiler=" + this.hasMediaSpoiler + ", userShared=" + this.userShared + ", chatShared=" + this.chatShared + ", story=" + this.story + ", externalReplyInfo=" + this.externalReplyInfo + ", forwardOrigin=" + this.forwardOrigin + ", linkPreviewOptions=" + this.linkPreviewOptions + ", quote=" + this.quote + ", usersShared=" + this.usersShared + ", giveawayCreated=" + this.giveawayCreated + ", giveaway=" + this.giveaway + ", giveawayWinners=" + this.giveawayWinners + ", giveawayCompleted=" + this.giveawayCompleted + ", replyToStory=" + this.replyToStory + ", boostAdded=" + this.boostAdded + ", senderBoostCount=" + this.senderBoostCount + ", businessConnectionId=" + this.businessConnectionId + ", senderBusinessBot=" + this.senderBusinessBot + ", isFromOffline=" + this.isFromOffline + ", chatBackgroundSet=" + this.chatBackgroundSet + ", effectId=" + this.effectId + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", paidMedia=" + this.paidMedia + ", refundedPayment=" + this.refundedPayment + ", gift=" + this.gift + ", uniqueGift=" + this.uniqueGift + ", paidMessagePriceChanged=" + this.paidMessagePriceChanged + ", paidStarCount=" + this.paidStarCount + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class MessageBuilderImpl
    extends MessageBuilder<Message, MessageBuilderImpl> {
        @Generated
        private MessageBuilderImpl() {
        }

        @Override
        @Generated
        protected MessageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Message build() {
            return new Message(this);
        }
    }
}

