/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.payments.star;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StarAmount
implements BotApiObject,
Validable {
    private static final String AMOUNT_FIELD = "amount";
    private static final String NANOSTAR_AMOUNT_FIELD = "nanostar_amount";
    @JsonProperty(value="amount")
    @NonNull
    private Integer amount;
    @JsonProperty(value="nanostar_amount")
    private Integer nanostarAmount;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.nanostarAmount != null) {
            if (this.nanostarAmount < -999999999 || this.nanostarAmount > 999999999) {
                throw new TelegramApiValidationException("NanostarAmount must be between -999999999 and 999999999", this);
            }
            if (this.nanostarAmount < 0 && this.amount > 0) {
                throw new TelegramApiValidationException("NanostarAmount can be negative only if amount is non-positive", this);
            }
        }
    }

    @Generated
    public static StarAmountBuilder builder() {
        return new StarAmountBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarAmount)) {
            return false;
        }
        StarAmount other = (StarAmount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$amount = this.getAmount();
        Integer other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Integer this$nanostarAmount = this.getNanostarAmount();
        Integer other$nanostarAmount = other.getNanostarAmount();
        return !(this$nanostarAmount == null ? other$nanostarAmount != null : !((Object)this$nanostarAmount).equals(other$nanostarAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StarAmount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Integer $nanostarAmount = this.getNanostarAmount();
        result = result * 59 + ($nanostarAmount == null ? 43 : ((Object)$nanostarAmount).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Integer getAmount() {
        return this.amount;
    }

    @Generated
    public Integer getNanostarAmount() {
        return this.nanostarAmount;
    }

    @JsonProperty(value="amount")
    @Generated
    public void setAmount(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    @JsonProperty(value="nanostar_amount")
    @Generated
    public void setNanostarAmount(Integer nanostarAmount) {
        this.nanostarAmount = nanostarAmount;
    }

    @Generated
    public String toString() {
        return "StarAmount(amount=" + this.getAmount() + ", nanostarAmount=" + this.getNanostarAmount() + ")";
    }

    @Generated
    public StarAmount() {
    }

    @Generated
    public StarAmount(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    @Generated
    public StarAmount(@NonNull Integer amount, Integer nanostarAmount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
        this.nanostarAmount = nanostarAmount;
    }

    @Generated
    public static class StarAmountBuilder {
        @Generated
        private Integer amount;
        @Generated
        private Integer nanostarAmount;

        @Generated
        StarAmountBuilder() {
        }

        @JsonProperty(value="amount")
        @Generated
        public StarAmountBuilder amount(@NonNull Integer amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @JsonProperty(value="nanostar_amount")
        @Generated
        public StarAmountBuilder nanostarAmount(Integer nanostarAmount) {
            this.nanostarAmount = nanostarAmount;
            return this;
        }

        @Generated
        public StarAmount build() {
            return new StarAmount(this.amount, this.nanostarAmount);
        }

        @Generated
        public String toString() {
            return "StarAmount.StarAmountBuilder(amount=" + this.amount + ", nanostarAmount=" + this.nanostarAmount + ")";
        }
    }
}

