/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonPollType;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonRequestChat;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonRequestUser;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonRequestUsers;
import org.telegram.telegrambots.meta.api.objects.webapp.WebAppInfo;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KeyboardButtonBuilderImpl.class)
public class KeyboardButton
implements Validable,
BotApiObject {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    private static final String REQUEST_POLL_FIELD = "request_poll";
    private static final String WEBAPP_FIELD = "web_app";
    private static final String REQUESTUSER_FIELD = "request_user";
    private static final String REQUESTCHAT_FIELD = "request_chat";
    private static final String REQUEST_USERS_FIELD = "request_users";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;
    @JsonProperty(value="request_poll")
    private KeyboardButtonPollType requestPoll;
    @JsonProperty(value="web_app")
    private WebAppInfo webApp;
    @JsonProperty(value="request_user")
    private KeyboardButtonRequestUser requestUser;
    @JsonProperty(value="request_chat")
    private KeyboardButtonRequestChat requestChat;
    @JsonProperty(value="request_users")
    private KeyboardButtonRequestUsers requestUsers;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        int requestsProvided = 0;
        requestsProvided += this.requestContact == null ? 0 : 1;
        requestsProvided += this.requestLocation == null ? 0 : 1;
        requestsProvided += this.requestPoll == null ? 0 : 1;
        requestsProvided += this.webApp == null ? 0 : 1;
        requestsProvided += this.requestUser == null ? 0 : 1;
        requestsProvided += this.requestChat == null ? 0 : 1;
        if ((requestsProvided += this.requestUsers == null ? 0 : 1) > 1) {
            throw new TelegramApiValidationException("The optional fields web_app, request_user, request_users, request_chat, request_contact, request_location, and request_poll are mutually exclusive", this);
        }
        if (this.webApp != null) {
            this.webApp.validate();
        }
        if (this.requestPoll != null) {
            this.requestPoll.validate();
        }
        if (this.requestUser != null) {
            this.requestUser.validate();
        }
        if (this.requestChat != null) {
            this.requestChat.validate();
        }
        if (this.requestUsers != null) {
            this.requestUsers.validate();
        }
    }

    @Generated
    protected KeyboardButton(KeyboardButtonBuilder<?, ?> b) {
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.requestContact = b.requestContact;
        this.requestLocation = b.requestLocation;
        this.requestPoll = b.requestPoll;
        this.webApp = b.webApp;
        this.requestUser = b.requestUser;
        this.requestChat = b.requestChat;
        this.requestUsers = b.requestUsers;
    }

    @Generated
    public static KeyboardButtonBuilder<?, ?> builder() {
        return new KeyboardButtonBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButton)) {
            return false;
        }
        KeyboardButton other = (KeyboardButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$requestContact = this.getRequestContact();
        Boolean other$requestContact = other.getRequestContact();
        if (this$requestContact == null ? other$requestContact != null : !((Object)this$requestContact).equals(other$requestContact)) {
            return false;
        }
        Boolean this$requestLocation = this.getRequestLocation();
        Boolean other$requestLocation = other.getRequestLocation();
        if (this$requestLocation == null ? other$requestLocation != null : !((Object)this$requestLocation).equals(other$requestLocation)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        KeyboardButtonPollType this$requestPoll = this.getRequestPoll();
        KeyboardButtonPollType other$requestPoll = other.getRequestPoll();
        if (this$requestPoll == null ? other$requestPoll != null : !((Object)this$requestPoll).equals(other$requestPoll)) {
            return false;
        }
        WebAppInfo this$webApp = this.getWebApp();
        WebAppInfo other$webApp = other.getWebApp();
        if (this$webApp == null ? other$webApp != null : !((Object)this$webApp).equals(other$webApp)) {
            return false;
        }
        KeyboardButtonRequestUser this$requestUser = this.getRequestUser();
        KeyboardButtonRequestUser other$requestUser = other.getRequestUser();
        if (this$requestUser == null ? other$requestUser != null : !((Object)this$requestUser).equals(other$requestUser)) {
            return false;
        }
        KeyboardButtonRequestChat this$requestChat = this.getRequestChat();
        KeyboardButtonRequestChat other$requestChat = other.getRequestChat();
        if (this$requestChat == null ? other$requestChat != null : !((Object)this$requestChat).equals(other$requestChat)) {
            return false;
        }
        KeyboardButtonRequestUsers this$requestUsers = this.getRequestUsers();
        KeyboardButtonRequestUsers other$requestUsers = other.getRequestUsers();
        return !(this$requestUsers == null ? other$requestUsers != null : !((Object)this$requestUsers).equals(other$requestUsers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButton;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $requestContact = this.getRequestContact();
        result = result * 59 + ($requestContact == null ? 43 : ((Object)$requestContact).hashCode());
        Boolean $requestLocation = this.getRequestLocation();
        result = result * 59 + ($requestLocation == null ? 43 : ((Object)$requestLocation).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        KeyboardButtonPollType $requestPoll = this.getRequestPoll();
        result = result * 59 + ($requestPoll == null ? 43 : ((Object)$requestPoll).hashCode());
        WebAppInfo $webApp = this.getWebApp();
        result = result * 59 + ($webApp == null ? 43 : ((Object)$webApp).hashCode());
        KeyboardButtonRequestUser $requestUser = this.getRequestUser();
        result = result * 59 + ($requestUser == null ? 43 : ((Object)$requestUser).hashCode());
        KeyboardButtonRequestChat $requestChat = this.getRequestChat();
        result = result * 59 + ($requestChat == null ? 43 : ((Object)$requestChat).hashCode());
        KeyboardButtonRequestUsers $requestUsers = this.getRequestUsers();
        result = result * 59 + ($requestUsers == null ? 43 : ((Object)$requestUsers).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public Boolean getRequestContact() {
        return this.requestContact;
    }

    @Generated
    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    @Generated
    public KeyboardButtonPollType getRequestPoll() {
        return this.requestPoll;
    }

    @Generated
    public WebAppInfo getWebApp() {
        return this.webApp;
    }

    @Generated
    public KeyboardButtonRequestUser getRequestUser() {
        return this.requestUser;
    }

    @Generated
    public KeyboardButtonRequestChat getRequestChat() {
        return this.requestChat;
    }

    @Generated
    public KeyboardButtonRequestUsers getRequestUsers() {
        return this.requestUsers;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="request_contact")
    @Generated
    public void setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
    }

    @JsonProperty(value="request_location")
    @Generated
    public void setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
    }

    @JsonProperty(value="request_poll")
    @Generated
    public void setRequestPoll(KeyboardButtonPollType requestPoll) {
        this.requestPoll = requestPoll;
    }

    @JsonProperty(value="web_app")
    @Generated
    public void setWebApp(WebAppInfo webApp) {
        this.webApp = webApp;
    }

    @JsonProperty(value="request_user")
    @Generated
    public void setRequestUser(KeyboardButtonRequestUser requestUser) {
        this.requestUser = requestUser;
    }

    @JsonProperty(value="request_chat")
    @Generated
    public void setRequestChat(KeyboardButtonRequestChat requestChat) {
        this.requestChat = requestChat;
    }

    @JsonProperty(value="request_users")
    @Generated
    public void setRequestUsers(KeyboardButtonRequestUsers requestUsers) {
        this.requestUsers = requestUsers;
    }

    @Generated
    public String toString() {
        return "KeyboardButton(text=" + this.getText() + ", requestContact=" + this.getRequestContact() + ", requestLocation=" + this.getRequestLocation() + ", requestPoll=" + this.getRequestPoll() + ", webApp=" + this.getWebApp() + ", requestUser=" + this.getRequestUser() + ", requestChat=" + this.getRequestChat() + ", requestUsers=" + this.getRequestUsers() + ")";
    }

    @Generated
    public KeyboardButton(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @Generated
    public KeyboardButton(@NonNull String text, Boolean requestContact, Boolean requestLocation, KeyboardButtonPollType requestPoll, WebAppInfo webApp, KeyboardButtonRequestUser requestUser, KeyboardButtonRequestChat requestChat, KeyboardButtonRequestUsers requestUsers) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.requestContact = requestContact;
        this.requestLocation = requestLocation;
        this.requestPoll = requestPoll;
        this.webApp = webApp;
        this.requestUser = requestUser;
        this.requestChat = requestChat;
        this.requestUsers = requestUsers;
    }

    @Generated
    public static abstract class KeyboardButtonBuilder<C extends KeyboardButton, B extends KeyboardButtonBuilder<C, B>> {
        @Generated
        private String text;
        @Generated
        private Boolean requestContact;
        @Generated
        private Boolean requestLocation;
        @Generated
        private KeyboardButtonPollType requestPoll;
        @Generated
        private WebAppInfo webApp;
        @Generated
        private KeyboardButtonRequestUser requestUser;
        @Generated
        private KeyboardButtonRequestChat requestChat;
        @Generated
        private KeyboardButtonRequestUsers requestUsers;

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="request_contact")
        @Generated
        public B requestContact(Boolean requestContact) {
            this.requestContact = requestContact;
            return this.self();
        }

        @JsonProperty(value="request_location")
        @Generated
        public B requestLocation(Boolean requestLocation) {
            this.requestLocation = requestLocation;
            return this.self();
        }

        @JsonProperty(value="request_poll")
        @Generated
        public B requestPoll(KeyboardButtonPollType requestPoll) {
            this.requestPoll = requestPoll;
            return this.self();
        }

        @JsonProperty(value="web_app")
        @Generated
        public B webApp(WebAppInfo webApp) {
            this.webApp = webApp;
            return this.self();
        }

        @JsonProperty(value="request_user")
        @Generated
        public B requestUser(KeyboardButtonRequestUser requestUser) {
            this.requestUser = requestUser;
            return this.self();
        }

        @JsonProperty(value="request_chat")
        @Generated
        public B requestChat(KeyboardButtonRequestChat requestChat) {
            this.requestChat = requestChat;
            return this.self();
        }

        @JsonProperty(value="request_users")
        @Generated
        public B requestUsers(KeyboardButtonRequestUsers requestUsers) {
            this.requestUsers = requestUsers;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "KeyboardButton.KeyboardButtonBuilder(text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + ", requestPoll=" + this.requestPoll + ", webApp=" + this.webApp + ", requestUser=" + this.requestUser + ", requestChat=" + this.requestChat + ", requestUsers=" + this.requestUsers + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class KeyboardButtonBuilderImpl
    extends KeyboardButtonBuilder<KeyboardButton, KeyboardButtonBuilderImpl> {
        @Generated
        private KeyboardButtonBuilderImpl() {
        }

        @Override
        @Generated
        protected KeyboardButtonBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KeyboardButton build() {
            return new KeyboardButton(this);
        }
    }
}

