/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.MessageId;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.suggestedpost.SuggestedPostParameters;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=CopyMessageBuilderImpl.class)
public class CopyMessage
extends BotApiMethod<MessageId> {
    public static final String PATH = "copyMessage";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String DIRECT_MESSAGES_TOPIC_ID_FIELD = "direct_messages_topic_id";
    private static final String FROM_CHAT_ID_FIELD = "from_chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    private static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    private static final String ALLOW_PAID_BROADCAST_FIELD = "allow_paid_broadcast";
    private static final String VIDEO_START_TIMESTAMP_FIELD = "video_start_timestamp";
    private static final String SUGGESTED_POST_PARAMETERS_FIELD = "suggested_post_parameters";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="direct_messages_topic_id")
    private Integer directMessagesTopicId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private String fromChatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="show_caption_above_media")
    private Boolean showCaptionAboveMedia;
    @JsonProperty(value="allow_paid_broadcast")
    private Boolean allowPaidBroadcast;
    @JsonProperty(value="video_start_timestamp")
    private Boolean videoStartTimestamp;
    @JsonProperty(value="suggested_post_parameters")
    private SuggestedPostParameters suggestedPostParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = null;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    public void enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
    }

    public void enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
    }

    public void enableMarkdownV2(boolean enable) {
        this.parseMode = enable ? "MarkdownV2" : null;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public MessageId deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, MessageId.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Generated
    protected CopyMessage(CopyMessageBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.directMessagesTopicId = b.directMessagesTopicId;
        this.fromChatId = b.fromChatId;
        if (this.fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.caption = b.caption;
        this.parseMode = b.parseMode;
        this.captionEntities = b.captionEntities;
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.replyMarkup = b.replyMarkup;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
        this.videoStartTimestamp = b.videoStartTimestamp;
        this.suggestedPostParameters = b.suggestedPostParameters;
    }

    @Generated
    public static CopyMessageBuilder<?, ?> builder() {
        return new CopyMessageBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyMessage)) {
            return false;
        }
        CopyMessage other = (CopyMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$directMessagesTopicId = this.getDirectMessagesTopicId();
        Integer other$directMessagesTopicId = other.getDirectMessagesTopicId();
        if (this$directMessagesTopicId == null ? other$directMessagesTopicId != null : !((Object)this$directMessagesTopicId).equals(other$directMessagesTopicId)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        Boolean this$videoStartTimestamp = this.getVideoStartTimestamp();
        Boolean other$videoStartTimestamp = other.getVideoStartTimestamp();
        if (this$videoStartTimestamp == null ? other$videoStartTimestamp != null : !((Object)this$videoStartTimestamp).equals(other$videoStartTimestamp)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$fromChatId = this.getFromChatId();
        String other$fromChatId = other.getFromChatId();
        if (this$fromChatId == null ? other$fromChatId != null : !this$fromChatId.equals(other$fromChatId)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        SuggestedPostParameters this$suggestedPostParameters = this.getSuggestedPostParameters();
        SuggestedPostParameters other$suggestedPostParameters = other.getSuggestedPostParameters();
        return !(this$suggestedPostParameters == null ? other$suggestedPostParameters != null : !((Object)this$suggestedPostParameters).equals(other$suggestedPostParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopyMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $directMessagesTopicId = this.getDirectMessagesTopicId();
        result = result * 59 + ($directMessagesTopicId == null ? 43 : ((Object)$directMessagesTopicId).hashCode());
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        Boolean $videoStartTimestamp = this.getVideoStartTimestamp();
        result = result * 59 + ($videoStartTimestamp == null ? 43 : ((Object)$videoStartTimestamp).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : $fromChatId.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        SuggestedPostParameters $suggestedPostParameters = this.getSuggestedPostParameters();
        result = result * 59 + ($suggestedPostParameters == null ? 43 : ((Object)$suggestedPostParameters).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @Generated
    public Integer getDirectMessagesTopicId() {
        return this.directMessagesTopicId;
    }

    @NonNull
    @Generated
    public String getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @Generated
    public Boolean getVideoStartTimestamp() {
        return this.videoStartTimestamp;
    }

    @Generated
    public SuggestedPostParameters getSuggestedPostParameters() {
        return this.suggestedPostParameters;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="direct_messages_topic_id")
    @Generated
    public void setDirectMessagesTopicId(Integer directMessagesTopicId) {
        this.directMessagesTopicId = directMessagesTopicId;
    }

    @JsonProperty(value="from_chat_id")
    @Generated
    public void setFromChatId(@NonNull String fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="allow_sending_without_reply")
    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="show_caption_above_media")
    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @JsonProperty(value="allow_paid_broadcast")
    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @JsonProperty(value="video_start_timestamp")
    @Generated
    public void setVideoStartTimestamp(Boolean videoStartTimestamp) {
        this.videoStartTimestamp = videoStartTimestamp;
    }

    @JsonProperty(value="suggested_post_parameters")
    @Generated
    public void setSuggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
        this.suggestedPostParameters = suggestedPostParameters;
    }

    @Generated
    public String toString() {
        return "CopyMessage(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", directMessagesTopicId=" + this.getDirectMessagesTopicId() + ", fromChatId=" + this.getFromChatId() + ", messageId=" + this.getMessageId() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", replyMarkup=" + this.getReplyMarkup() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ", videoStartTimestamp=" + this.getVideoStartTimestamp() + ", suggestedPostParameters=" + this.getSuggestedPostParameters() + ")";
    }

    @Generated
    public CopyMessage(@NonNull String chatId, @NonNull String fromChatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageId = messageId;
    }

    @Generated
    public CopyMessage(@NonNull String chatId, Integer messageThreadId, Integer directMessagesTopicId, @NonNull String fromChatId, @NonNull Integer messageId, String caption, String parseMode, List<MessageEntity> captionEntities, Boolean disableNotification, Integer replyToMessageId, Boolean allowSendingWithoutReply, ReplyKeyboard replyMarkup, Boolean protectContent, ReplyParameters replyParameters, Boolean showCaptionAboveMedia, Boolean allowPaidBroadcast, Boolean videoStartTimestamp, SuggestedPostParameters suggestedPostParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.directMessagesTopicId = directMessagesTopicId;
        this.fromChatId = fromChatId;
        this.messageId = messageId;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.replyMarkup = replyMarkup;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.allowPaidBroadcast = allowPaidBroadcast;
        this.videoStartTimestamp = videoStartTimestamp;
        this.suggestedPostParameters = suggestedPostParameters;
    }

    public static abstract class CopyMessageBuilder<C extends CopyMessage, B extends CopyMessageBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<MessageId, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private Integer directMessagesTopicId;
        @Generated
        private String fromChatId;
        @Generated
        private Integer messageId;
        @Generated
        private String caption;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> captionEntities;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private Boolean protectContent;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private Boolean showCaptionAboveMedia;
        @Generated
        private Boolean allowPaidBroadcast;
        @Generated
        private Boolean videoStartTimestamp;
        @Generated
        private SuggestedPostParameters suggestedPostParameters;

        public CopyMessageBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public CopyMessageBuilder<C, B> fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="direct_messages_topic_id")
        @Generated
        public B directMessagesTopicId(Integer directMessagesTopicId) {
            this.directMessagesTopicId = directMessagesTopicId;
            return (B)this.self();
        }

        @JsonProperty(value="from_chat_id")
        @Generated
        public B fromChatId(@NonNull String fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="caption")
        @Generated
        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public B captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="show_caption_above_media")
        @Generated
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        @JsonProperty(value="allow_paid_broadcast")
        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @JsonProperty(value="video_start_timestamp")
        @Generated
        public B videoStartTimestamp(Boolean videoStartTimestamp) {
            this.videoStartTimestamp = videoStartTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="suggested_post_parameters")
        @Generated
        public B suggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
            this.suggestedPostParameters = suggestedPostParameters;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CopyMessage.CopyMessageBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", directMessagesTopicId=" + this.directMessagesTopicId + ", fromChatId=" + this.fromChatId + ", messageId=" + this.messageId + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", replyMarkup=" + this.replyMarkup + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ", videoStartTimestamp=" + this.videoStartTimestamp + ", suggestedPostParameters=" + this.suggestedPostParameters + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class CopyMessageBuilderImpl
    extends CopyMessageBuilder<CopyMessage, CopyMessageBuilderImpl> {
        @Generated
        private CopyMessageBuilderImpl() {
        }

        @Override
        @Generated
        protected CopyMessageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CopyMessage build() {
            return new CopyMessage(this);
        }
    }
}

