/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.gifts;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=GiftPremiumSubscriptionBuilderImpl.class)
public class GiftPremiumSubscription
extends BotApiMethodBoolean {
    public static final String PATH = "giftPremiumSubscription";
    private static final String USER_ID_FIELD = "user_id";
    private static final String MONTH_COUNT_FIELD = "month_count";
    private static final String STAR_COUNT_FIELD = "star_count";
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_PARSE_MODE_FIELD = "text_parse_mode";
    private static final String TEXT_ENTITIES_FIELD = "text_entities";
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="month_count")
    @NonNull
    private Integer monthCount;
    @JsonProperty(value="star_count")
    @NonNull
    private Integer starCount;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="text_parse_mode")
    private String textParseMode;
    @JsonProperty(value="text_entities")
    private List<MessageEntity> textEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredUserId(this.userId, this);
        if (this.text != null && (this.text.isEmpty() || this.text.length() > 128)) {
            throw new TelegramApiValidationException("Text must be between 0 and 128 characters", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Generated
    protected GiftPremiumSubscription(GiftPremiumSubscriptionBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.monthCount = b.monthCount;
        if (this.monthCount == null) {
            throw new NullPointerException("monthCount is marked non-null but is null");
        }
        this.starCount = b.starCount;
        if (this.starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.text = b.text;
        this.textParseMode = b.textParseMode;
        this.textEntities = switch (b.textEntities == null ? 0 : b.textEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.textEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.textEntities));
        };
    }

    @Generated
    public static GiftPremiumSubscriptionBuilder<?, ?> builder() {
        return new GiftPremiumSubscriptionBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GiftPremiumSubscription)) {
            return false;
        }
        GiftPremiumSubscription other = (GiftPremiumSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$monthCount = this.getMonthCount();
        Integer other$monthCount = other.getMonthCount();
        if (this$monthCount == null ? other$monthCount != null : !((Object)this$monthCount).equals(other$monthCount)) {
            return false;
        }
        Integer this$starCount = this.getStarCount();
        Integer other$starCount = other.getStarCount();
        if (this$starCount == null ? other$starCount != null : !((Object)this$starCount).equals(other$starCount)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$textParseMode = this.getTextParseMode();
        String other$textParseMode = other.getTextParseMode();
        if (this$textParseMode == null ? other$textParseMode != null : !this$textParseMode.equals(other$textParseMode)) {
            return false;
        }
        List<MessageEntity> this$textEntities = this.getTextEntities();
        List<MessageEntity> other$textEntities = other.getTextEntities();
        return !(this$textEntities == null ? other$textEntities != null : !((Object)this$textEntities).equals(other$textEntities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GiftPremiumSubscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $monthCount = this.getMonthCount();
        result = result * 59 + ($monthCount == null ? 43 : ((Object)$monthCount).hashCode());
        Integer $starCount = this.getStarCount();
        result = result * 59 + ($starCount == null ? 43 : ((Object)$starCount).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $textParseMode = this.getTextParseMode();
        result = result * 59 + ($textParseMode == null ? 43 : $textParseMode.hashCode());
        List<MessageEntity> $textEntities = this.getTextEntities();
        result = result * 59 + ($textEntities == null ? 43 : ((Object)$textEntities).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public Integer getMonthCount() {
        return this.monthCount;
    }

    @NonNull
    @Generated
    public Integer getStarCount() {
        return this.starCount;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getTextParseMode() {
        return this.textParseMode;
    }

    @Generated
    public List<MessageEntity> getTextEntities() {
        return this.textEntities;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="month_count")
    @Generated
    public void setMonthCount(@NonNull Integer monthCount) {
        if (monthCount == null) {
            throw new NullPointerException("monthCount is marked non-null but is null");
        }
        this.monthCount = monthCount;
    }

    @JsonProperty(value="star_count")
    @Generated
    public void setStarCount(@NonNull Integer starCount) {
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.starCount = starCount;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @JsonProperty(value="text_parse_mode")
    @Generated
    public void setTextParseMode(String textParseMode) {
        this.textParseMode = textParseMode;
    }

    @JsonProperty(value="text_entities")
    @Generated
    public void setTextEntities(List<MessageEntity> textEntities) {
        this.textEntities = textEntities;
    }

    @Generated
    public String toString() {
        return "GiftPremiumSubscription(userId=" + this.getUserId() + ", monthCount=" + this.getMonthCount() + ", starCount=" + this.getStarCount() + ", text=" + this.getText() + ", textParseMode=" + this.getTextParseMode() + ", textEntities=" + this.getTextEntities() + ")";
    }

    @Generated
    public GiftPremiumSubscription(@NonNull Long userId, @NonNull Integer monthCount, @NonNull Integer starCount) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (monthCount == null) {
            throw new NullPointerException("monthCount is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.userId = userId;
        this.monthCount = monthCount;
        this.starCount = starCount;
    }

    @Generated
    public GiftPremiumSubscription(@NonNull Long userId, @NonNull Integer monthCount, @NonNull Integer starCount, String text, String textParseMode, List<MessageEntity> textEntities) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (monthCount == null) {
            throw new NullPointerException("monthCount is marked non-null but is null");
        }
        if (starCount == null) {
            throw new NullPointerException("starCount is marked non-null but is null");
        }
        this.userId = userId;
        this.monthCount = monthCount;
        this.starCount = starCount;
        this.text = text;
        this.textParseMode = textParseMode;
        this.textEntities = textEntities;
    }

    @Generated
    public static abstract class GiftPremiumSubscriptionBuilder<C extends GiftPremiumSubscription, B extends GiftPremiumSubscriptionBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private Long userId;
        @Generated
        private Integer monthCount;
        @Generated
        private Integer starCount;
        @Generated
        private String text;
        @Generated
        private String textParseMode;
        @Generated
        private ArrayList<MessageEntity> textEntities;

        @JsonProperty(value="user_id")
        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="month_count")
        @Generated
        public B monthCount(@NonNull Integer monthCount) {
            if (monthCount == null) {
                throw new NullPointerException("monthCount is marked non-null but is null");
            }
            this.monthCount = monthCount;
            return (B)this.self();
        }

        @JsonProperty(value="star_count")
        @Generated
        public B starCount(@NonNull Integer starCount) {
            if (starCount == null) {
                throw new NullPointerException("starCount is marked non-null but is null");
            }
            this.starCount = starCount;
            return (B)this.self();
        }

        @JsonProperty(value="text")
        @Generated
        public B text(String text) {
            this.text = text;
            return (B)this.self();
        }

        @JsonProperty(value="text_parse_mode")
        @Generated
        public B textParseMode(String textParseMode) {
            this.textParseMode = textParseMode;
            return (B)this.self();
        }

        @Generated
        public B textEntity(MessageEntity textEntity) {
            if (this.textEntities == null) {
                this.textEntities = new ArrayList();
            }
            this.textEntities.add(textEntity);
            return (B)this.self();
        }

        @JsonProperty(value="text_entities")
        @Generated
        public B textEntities(Collection<? extends MessageEntity> textEntities) {
            if (textEntities == null) {
                throw new NullPointerException("textEntities cannot be null");
            }
            if (this.textEntities == null) {
                this.textEntities = new ArrayList();
            }
            this.textEntities.addAll(textEntities);
            return (B)this.self();
        }

        @Generated
        public B clearTextEntities() {
            if (this.textEntities != null) {
                this.textEntities.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GiftPremiumSubscription.GiftPremiumSubscriptionBuilder(super=" + super.toString() + ", userId=" + this.userId + ", monthCount=" + this.monthCount + ", starCount=" + this.starCount + ", text=" + this.text + ", textParseMode=" + this.textParseMode + ", textEntities=" + this.textEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class GiftPremiumSubscriptionBuilderImpl
    extends GiftPremiumSubscriptionBuilder<GiftPremiumSubscription, GiftPremiumSubscriptionBuilderImpl> {
        @Generated
        private GiftPremiumSubscriptionBuilderImpl() {
        }

        @Override
        @Generated
        protected GiftPremiumSubscriptionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GiftPremiumSubscription build() {
            return new GiftPremiumSubscription(this);
        }
    }
}

