/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.polls.input.InputPollOption;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendPollBuilderImpl.class)
public class SendPoll
extends BotApiMethodMessage {
    public static final String PATH = "sendPoll";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String QUESTION_FIELD = "question";
    private static final String OPTIONS_FIELD = "options";
    private static final String IS_ANONYMOUS_FIELD = "is_anonymous";
    private static final String TYPE_FIELD = "type";
    private static final String ALLOW_MULTIPLE_ANSWERS_FIELD = "allows_multiple_answers";
    private static final String CORRECT_OPTION_ID_FIELD = "correct_option_id";
    private static final String IS_CLOSED_FIELD = "is_closed";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String OPEN_PERIOD_FIELD = "open_period";
    private static final String CLOSE_DATE_FIELD = "close_date";
    private static final String EXPLANATION_FIELD = "explanation";
    private static final String EXPLANATION_PARSE_MODE_FIELD = "explanation_parse_mode";
    private static final String EXPLANATION_ENTITIES_FIELD = "explanation_entities";
    private static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String QUESTION_PARSE_MODE_FIELD = "question_parse_mode";
    private static final String QUESTION_ENTITIES_FIELD = "question_entities";
    private static final String MESSAGE_EFFECT_ID_FIELD = "message_effect_id";
    private static final String ALLOW_PAID_BROADCAST_FIELD = "allow_paid_broadcast";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="question")
    @NonNull
    private String question;
    @JsonProperty(value="options")
    @NonNull
    private List<InputPollOption> options;
    @JsonProperty(value="is_anonymous")
    private Boolean isAnonymous;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="allows_multiple_answers")
    private Boolean allowMultipleAnswers;
    @JsonProperty(value="correct_option_id")
    private Integer correctOptionId;
    @JsonProperty(value="is_closed")
    private Boolean isClosed;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="open_period")
    private Integer openPeriod;
    @JsonProperty(value="close_date")
    private Integer closeDate;
    @JsonProperty(value="explanation")
    private String explanation;
    @JsonProperty(value="explanation_parse_mode")
    private String explanationParseMode;
    @JsonProperty(value="explanation_entities")
    private List<MessageEntity> explanationEntities;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;
    @JsonProperty(value="question_parse_mode")
    private String questionParseMode;
    @JsonProperty(value="question_entities")
    private List<MessageEntity> questionEntities;
    @JsonProperty(value="message_effect_id")
    private String messageEffectId;
    @JsonProperty(value="allow_paid_broadcast")
    private Boolean allowPaidBroadcast;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = null;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.question.isEmpty()) {
            throw new TelegramApiValidationException("Question parameter can't be empty", this);
        }
        if (this.openPeriod != null && this.closeDate != null) {
            throw new TelegramApiValidationException("Only one of Open Period and Close Date are allowed", this);
        }
        if (this.openPeriod != null && (this.openPeriod < 5 || this.openPeriod > 600)) {
            throw new TelegramApiValidationException("Open period can only be between 5 and 600", this);
        }
        if (this.explanation != null && this.explanation.length() > 200) {
            throw new TelegramApiValidationException("Explanation can only have up to 200 characters", this);
        }
        if (this.options.size() < 2 || this.options.size() > 12) {
            throw new TelegramApiValidationException("Options parameter must be between 2 and 12 item", this);
        }
        for (InputPollOption option : this.options) {
            option.validate();
        }
        if (this.explanationParseMode != null && this.explanationEntities != null && !this.explanationEntities.isEmpty()) {
            throw new TelegramApiValidationException("Explanation Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.questionParseMode != null && this.questionEntities != null && !this.questionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Question Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Generated
    protected SendPoll(SendPollBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.question = b.question;
        if (this.question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        List<Object> options = switch (b.options == null ? 0 : b.options.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.options.get(0));
            default -> Collections.unmodifiableList(new ArrayList<InputPollOption>(b.options));
        };
        this.options = options;
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.isAnonymous = b.isAnonymous;
        this.type = b.type;
        this.allowMultipleAnswers = b.allowMultipleAnswers;
        this.correctOptionId = b.correctOptionId;
        this.isClosed = b.isClosed;
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.openPeriod = b.openPeriod;
        this.closeDate = b.closeDate;
        this.explanation = b.explanation;
        this.explanationParseMode = b.explanationParseMode;
        this.explanationEntities = b.explanationEntities;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.protectContent = b.protectContent;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
        this.questionParseMode = b.questionParseMode;
        this.questionEntities = b.questionEntities;
        this.messageEffectId = b.messageEffectId;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
    }

    @Generated
    public static SendPollBuilder<?, ?> builder() {
        return new SendPollBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPoll)) {
            return false;
        }
        SendPoll other = (SendPoll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$isAnonymous = this.getIsAnonymous();
        Boolean other$isAnonymous = other.getIsAnonymous();
        if (this$isAnonymous == null ? other$isAnonymous != null : !((Object)this$isAnonymous).equals(other$isAnonymous)) {
            return false;
        }
        Boolean this$allowMultipleAnswers = this.getAllowMultipleAnswers();
        Boolean other$allowMultipleAnswers = other.getAllowMultipleAnswers();
        if (this$allowMultipleAnswers == null ? other$allowMultipleAnswers != null : !((Object)this$allowMultipleAnswers).equals(other$allowMultipleAnswers)) {
            return false;
        }
        Integer this$correctOptionId = this.getCorrectOptionId();
        Integer other$correctOptionId = other.getCorrectOptionId();
        if (this$correctOptionId == null ? other$correctOptionId != null : !((Object)this$correctOptionId).equals(other$correctOptionId)) {
            return false;
        }
        Boolean this$isClosed = this.getIsClosed();
        Boolean other$isClosed = other.getIsClosed();
        if (this$isClosed == null ? other$isClosed != null : !((Object)this$isClosed).equals(other$isClosed)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Integer this$openPeriod = this.getOpenPeriod();
        Integer other$openPeriod = other.getOpenPeriod();
        if (this$openPeriod == null ? other$openPeriod != null : !((Object)this$openPeriod).equals(other$openPeriod)) {
            return false;
        }
        Integer this$closeDate = this.getCloseDate();
        Integer other$closeDate = other.getCloseDate();
        if (this$closeDate == null ? other$closeDate != null : !((Object)this$closeDate).equals(other$closeDate)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        List<InputPollOption> this$options = this.getOptions();
        List<InputPollOption> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$explanation = this.getExplanation();
        String other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
            return false;
        }
        String this$explanationParseMode = this.getExplanationParseMode();
        String other$explanationParseMode = other.getExplanationParseMode();
        if (this$explanationParseMode == null ? other$explanationParseMode != null : !this$explanationParseMode.equals(other$explanationParseMode)) {
            return false;
        }
        List<MessageEntity> this$explanationEntities = this.getExplanationEntities();
        List<MessageEntity> other$explanationEntities = other.getExplanationEntities();
        if (this$explanationEntities == null ? other$explanationEntities != null : !((Object)this$explanationEntities).equals(other$explanationEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$questionParseMode = this.getQuestionParseMode();
        String other$questionParseMode = other.getQuestionParseMode();
        if (this$questionParseMode == null ? other$questionParseMode != null : !this$questionParseMode.equals(other$questionParseMode)) {
            return false;
        }
        List<MessageEntity> this$questionEntities = this.getQuestionEntities();
        List<MessageEntity> other$questionEntities = other.getQuestionEntities();
        if (this$questionEntities == null ? other$questionEntities != null : !((Object)this$questionEntities).equals(other$questionEntities)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        return !(this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendPoll;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $isAnonymous = this.getIsAnonymous();
        result = result * 59 + ($isAnonymous == null ? 43 : ((Object)$isAnonymous).hashCode());
        Boolean $allowMultipleAnswers = this.getAllowMultipleAnswers();
        result = result * 59 + ($allowMultipleAnswers == null ? 43 : ((Object)$allowMultipleAnswers).hashCode());
        Integer $correctOptionId = this.getCorrectOptionId();
        result = result * 59 + ($correctOptionId == null ? 43 : ((Object)$correctOptionId).hashCode());
        Boolean $isClosed = this.getIsClosed();
        result = result * 59 + ($isClosed == null ? 43 : ((Object)$isClosed).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Integer $openPeriod = this.getOpenPeriod();
        result = result * 59 + ($openPeriod == null ? 43 : ((Object)$openPeriod).hashCode());
        Integer $closeDate = this.getCloseDate();
        result = result * 59 + ($closeDate == null ? 43 : ((Object)$closeDate).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        List<InputPollOption> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $explanation = this.getExplanation();
        result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
        String $explanationParseMode = this.getExplanationParseMode();
        result = result * 59 + ($explanationParseMode == null ? 43 : $explanationParseMode.hashCode());
        List<MessageEntity> $explanationEntities = this.getExplanationEntities();
        result = result * 59 + ($explanationEntities == null ? 43 : ((Object)$explanationEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $questionParseMode = this.getQuestionParseMode();
        result = result * 59 + ($questionParseMode == null ? 43 : $questionParseMode.hashCode());
        List<MessageEntity> $questionEntities = this.getQuestionEntities();
        result = result * 59 + ($questionEntities == null ? 43 : ((Object)$questionEntities).hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    @Generated
    public String getQuestion() {
        return this.question;
    }

    @NonNull
    @Generated
    public List<InputPollOption> getOptions() {
        return this.options;
    }

    @Generated
    public Boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getAllowMultipleAnswers() {
        return this.allowMultipleAnswers;
    }

    @Generated
    public Integer getCorrectOptionId() {
        return this.correctOptionId;
    }

    @Generated
    public Boolean getIsClosed() {
        return this.isClosed;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public Integer getOpenPeriod() {
        return this.openPeriod;
    }

    @Generated
    public Integer getCloseDate() {
        return this.closeDate;
    }

    @Generated
    public String getExplanation() {
        return this.explanation;
    }

    @Generated
    public String getExplanationParseMode() {
        return this.explanationParseMode;
    }

    @Generated
    public List<MessageEntity> getExplanationEntities() {
        return this.explanationEntities;
    }

    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Generated
    public String getQuestionParseMode() {
        return this.questionParseMode;
    }

    @Generated
    public List<MessageEntity> getQuestionEntities() {
        return this.questionEntities;
    }

    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="question")
    @Generated
    public void setQuestion(@NonNull String question) {
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        this.question = question;
    }

    @JsonProperty(value="options")
    @Generated
    public void setOptions(@NonNull List<InputPollOption> options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
    }

    @JsonProperty(value="is_anonymous")
    @Generated
    public void setIsAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="allows_multiple_answers")
    @Generated
    public void setAllowMultipleAnswers(Boolean allowMultipleAnswers) {
        this.allowMultipleAnswers = allowMultipleAnswers;
    }

    @JsonProperty(value="correct_option_id")
    @Generated
    public void setCorrectOptionId(Integer correctOptionId) {
        this.correctOptionId = correctOptionId;
    }

    @JsonProperty(value="is_closed")
    @Generated
    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="open_period")
    @Generated
    public void setOpenPeriod(Integer openPeriod) {
        this.openPeriod = openPeriod;
    }

    @JsonProperty(value="close_date")
    @Generated
    public void setCloseDate(Integer closeDate) {
        this.closeDate = closeDate;
    }

    @JsonProperty(value="explanation")
    @Generated
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @JsonProperty(value="explanation_parse_mode")
    @Generated
    public void setExplanationParseMode(String explanationParseMode) {
        this.explanationParseMode = explanationParseMode;
    }

    @JsonProperty(value="explanation_entities")
    @Generated
    public void setExplanationEntities(List<MessageEntity> explanationEntities) {
        this.explanationEntities = explanationEntities;
    }

    @JsonProperty(value="allow_sending_without_reply")
    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="question_parse_mode")
    @Generated
    public void setQuestionParseMode(String questionParseMode) {
        this.questionParseMode = questionParseMode;
    }

    @JsonProperty(value="question_entities")
    @Generated
    public void setQuestionEntities(List<MessageEntity> questionEntities) {
        this.questionEntities = questionEntities;
    }

    @JsonProperty(value="message_effect_id")
    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @JsonProperty(value="allow_paid_broadcast")
    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public String toString() {
        return "SendPoll(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", question=" + this.getQuestion() + ", options=" + this.getOptions() + ", isAnonymous=" + this.getIsAnonymous() + ", type=" + this.getType() + ", allowMultipleAnswers=" + this.getAllowMultipleAnswers() + ", correctOptionId=" + this.getCorrectOptionId() + ", isClosed=" + this.getIsClosed() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", openPeriod=" + this.getOpenPeriod() + ", closeDate=" + this.getCloseDate() + ", explanation=" + this.getExplanation() + ", explanationParseMode=" + this.getExplanationParseMode() + ", explanationEntities=" + this.getExplanationEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", questionParseMode=" + this.getQuestionParseMode() + ", questionEntities=" + this.getQuestionEntities() + ", messageEffectId=" + this.getMessageEffectId() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ")";
    }

    @Generated
    public SendPoll(@NonNull String chatId, @NonNull String question, @NonNull List<InputPollOption> options) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.chatId = chatId;
        this.question = question;
        this.options = options;
    }

    @Generated
    public SendPoll(@NonNull String chatId, Integer messageThreadId, @NonNull String question, @NonNull List<InputPollOption> options, Boolean isAnonymous, String type, Boolean allowMultipleAnswers, Integer correctOptionId, Boolean isClosed, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, Integer openPeriod, Integer closeDate, String explanation, String explanationParseMode, List<MessageEntity> explanationEntities, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters, String businessConnectionId, String questionParseMode, List<MessageEntity> questionEntities, String messageEffectId, Boolean allowPaidBroadcast) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.question = question;
        this.options = options;
        this.isAnonymous = isAnonymous;
        this.type = type;
        this.allowMultipleAnswers = allowMultipleAnswers;
        this.correctOptionId = correctOptionId;
        this.isClosed = isClosed;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.openPeriod = openPeriod;
        this.closeDate = closeDate;
        this.explanation = explanation;
        this.explanationParseMode = explanationParseMode;
        this.explanationEntities = explanationEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
        this.questionParseMode = questionParseMode;
        this.questionEntities = questionEntities;
        this.messageEffectId = messageEffectId;
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    public static abstract class SendPollBuilder<C extends SendPoll, B extends SendPollBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private String question;
        @Generated
        private ArrayList<InputPollOption> options;
        @Generated
        private Boolean isAnonymous;
        @Generated
        private String type;
        @Generated
        private Boolean allowMultipleAnswers;
        @Generated
        private Integer correctOptionId;
        @Generated
        private Boolean isClosed;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private Integer openPeriod;
        @Generated
        private Integer closeDate;
        @Generated
        private String explanation;
        @Generated
        private String explanationParseMode;
        @Generated
        private List<MessageEntity> explanationEntities;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private Boolean protectContent;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private String businessConnectionId;
        @Generated
        private String questionParseMode;
        @Generated
        private List<MessageEntity> questionEntities;
        @Generated
        private String messageEffectId;
        @Generated
        private Boolean allowPaidBroadcast;

        public SendPollBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="question")
        @Generated
        public B question(@NonNull String question) {
            if (question == null) {
                throw new NullPointerException("question is marked non-null but is null");
            }
            this.question = question;
            return (B)this.self();
        }

        @Generated
        public B option(InputPollOption option) {
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.add(option);
            return (B)this.self();
        }

        @JsonProperty(value="options")
        @Generated
        public B options(Collection<? extends InputPollOption> options) {
            if (options == null) {
                throw new NullPointerException("options cannot be null");
            }
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.addAll(options);
            return (B)this.self();
        }

        @Generated
        public B clearOptions() {
            if (this.options != null) {
                this.options.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="is_anonymous")
        @Generated
        public B isAnonymous(Boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return (B)this.self();
        }

        @JsonProperty(value="type")
        @Generated
        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @JsonProperty(value="allows_multiple_answers")
        @Generated
        public B allowMultipleAnswers(Boolean allowMultipleAnswers) {
            this.allowMultipleAnswers = allowMultipleAnswers;
            return (B)this.self();
        }

        @JsonProperty(value="correct_option_id")
        @Generated
        public B correctOptionId(Integer correctOptionId) {
            this.correctOptionId = correctOptionId;
            return (B)this.self();
        }

        @JsonProperty(value="is_closed")
        @Generated
        public B isClosed(Boolean isClosed) {
            this.isClosed = isClosed;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="reply_to_message_id")
        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="open_period")
        @Generated
        public B openPeriod(Integer openPeriod) {
            this.openPeriod = openPeriod;
            return (B)this.self();
        }

        @JsonProperty(value="close_date")
        @Generated
        public B closeDate(Integer closeDate) {
            this.closeDate = closeDate;
            return (B)this.self();
        }

        @JsonProperty(value="explanation")
        @Generated
        public B explanation(String explanation) {
            this.explanation = explanation;
            return (B)this.self();
        }

        @JsonProperty(value="explanation_parse_mode")
        @Generated
        public B explanationParseMode(String explanationParseMode) {
            this.explanationParseMode = explanationParseMode;
            return (B)this.self();
        }

        @JsonProperty(value="explanation_entities")
        @Generated
        public B explanationEntities(List<MessageEntity> explanationEntities) {
            this.explanationEntities = explanationEntities;
            return (B)this.self();
        }

        @JsonProperty(value="allow_sending_without_reply")
        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @JsonProperty(value="question_parse_mode")
        @Generated
        public B questionParseMode(String questionParseMode) {
            this.questionParseMode = questionParseMode;
            return (B)this.self();
        }

        @JsonProperty(value="question_entities")
        @Generated
        public B questionEntities(List<MessageEntity> questionEntities) {
            this.questionEntities = questionEntities;
            return (B)this.self();
        }

        @JsonProperty(value="message_effect_id")
        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @JsonProperty(value="allow_paid_broadcast")
        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendPoll.SendPollBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", question=" + this.question + ", options=" + this.options + ", isAnonymous=" + this.isAnonymous + ", type=" + this.type + ", allowMultipleAnswers=" + this.allowMultipleAnswers + ", correctOptionId=" + this.correctOptionId + ", isClosed=" + this.isClosed + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", openPeriod=" + this.openPeriod + ", closeDate=" + this.closeDate + ", explanation=" + this.explanation + ", explanationParseMode=" + this.explanationParseMode + ", explanationEntities=" + this.explanationEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ", questionParseMode=" + this.questionParseMode + ", questionEntities=" + this.questionEntities + ", messageEffectId=" + this.messageEffectId + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendPollBuilderImpl
    extends SendPollBuilder<SendPoll, SendPollBuilderImpl> {
        @Generated
        private SendPollBuilderImpl() {
        }

        @Override
        @Generated
        protected SendPollBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendPoll build() {
            return new SendPoll(this);
        }
    }
}

