/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=AddStickerToSetBuilderImpl.class)
public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String STICKER_FIELD = "sticker";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    @NonNull
    private InputSticker sticker;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredUserId(this.userId, this);
        if (this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        this.sticker.validate();
    }

    @Generated
    protected AddStickerToSet(AddStickerToSetBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        if (this.userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
    }

    @Generated
    public static AddStickerToSetBuilder<?, ?> builder() {
        return new AddStickerToSetBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStickerToSet)) {
            return false;
        }
        AddStickerToSet other = (AddStickerToSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        InputSticker this$sticker = this.getSticker();
        InputSticker other$sticker = other.getSticker();
        return !(this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddStickerToSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        InputSticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public InputSticker getSticker() {
        return this.sticker;
    }

    @Generated
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setSticker(@NonNull InputSticker sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @Generated
    public String toString() {
        return "AddStickerToSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", sticker=" + this.getSticker() + ")";
    }

    @Generated
    public AddStickerToSet(@NonNull Long userId, @NonNull String name, @NonNull InputSticker sticker) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.sticker = sticker;
    }

    @Generated
    public static abstract class AddStickerToSetBuilder<C extends AddStickerToSet, B extends AddStickerToSetBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<Boolean, C, B> {
        @Generated
        private Long userId;
        @Generated
        private String name;
        @Generated
        private InputSticker sticker;

        @Generated
        public B userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return (B)this.self();
        }

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B sticker(@NonNull InputSticker sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AddStickerToSet.AddStickerToSetBuilder(super=" + super.toString() + ", userId=" + this.userId + ", name=" + this.name + ", sticker=" + this.sticker + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AddStickerToSetBuilderImpl
    extends AddStickerToSetBuilder<AddStickerToSet, AddStickerToSetBuilderImpl> {
        @Generated
        private AddStickerToSetBuilderImpl() {
        }

        @Override
        @Generated
        protected AddStickerToSetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AddStickerToSet build() {
            return new AddStickerToSet(this);
        }
    }
}

