/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stories;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.stories.Story;
import org.telegram.telegrambots.meta.api.objects.stories.StoryArea;
import org.telegram.telegrambots.meta.api.objects.stories.input.InputStoryContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditStory
extends BotApiMethod<Story> {
    public static final String PATH = "editStory";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String STORY_ID_FIELD = "story_id";
    private static final String CONTENT_FIELD = "content";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    private static final String AREAS_FIELD = "areas";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="story_id")
    @NonNull
    private Integer storyId;
    @JsonProperty(value="content")
    @NonNull
    private InputStoryContent content;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="areas")
    private List<StoryArea> areas;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Story deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Story.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty", this);
        }
        this.content.validate();
        if (this.caption != null && this.caption.length() > 2048) {
            throw new TelegramApiValidationException("Caption can't be longer than 2048 characters", this);
        }
        if (this.areas != null) {
            for (StoryArea area : this.areas) {
                area.validate();
            }
        }
    }

    @Generated
    public static EditStoryBuilder builder() {
        return new EditStoryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditStory)) {
            return false;
        }
        EditStory other = (EditStory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$storyId = this.getStoryId();
        Integer other$storyId = other.getStoryId();
        if (this$storyId == null ? other$storyId != null : !((Object)this$storyId).equals(other$storyId)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        InputStoryContent this$content = this.getContent();
        InputStoryContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        List<StoryArea> this$areas = this.getAreas();
        List<StoryArea> other$areas = other.getAreas();
        return !(this$areas == null ? other$areas != null : !((Object)this$areas).equals(other$areas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditStory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $storyId = this.getStoryId();
        result = result * 59 + ($storyId == null ? 43 : ((Object)$storyId).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        InputStoryContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        List<StoryArea> $areas = this.getAreas();
        result = result * 59 + ($areas == null ? 43 : ((Object)$areas).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public Integer getStoryId() {
        return this.storyId;
    }

    @NonNull
    @Generated
    public InputStoryContent getContent() {
        return this.content;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Generated
    public List<StoryArea> getAreas() {
        return this.areas;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="story_id")
    @Generated
    public void setStoryId(@NonNull Integer storyId) {
        if (storyId == null) {
            throw new NullPointerException("storyId is marked non-null but is null");
        }
        this.storyId = storyId;
    }

    @JsonProperty(value="content")
    @Generated
    public void setContent(@NonNull InputStoryContent content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    @JsonProperty(value="caption")
    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @JsonProperty(value="areas")
    @Generated
    public void setAreas(List<StoryArea> areas) {
        this.areas = areas;
    }

    @Generated
    public String toString() {
        return "EditStory(businessConnectionId=" + this.getBusinessConnectionId() + ", storyId=" + this.getStoryId() + ", content=" + this.getContent() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ", areas=" + this.getAreas() + ")";
    }

    @Generated
    public EditStory() {
    }

    @Generated
    public EditStory(@NonNull String businessConnectionId, @NonNull Integer storyId, @NonNull InputStoryContent content) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (storyId == null) {
            throw new NullPointerException("storyId is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.storyId = storyId;
        this.content = content;
    }

    @Generated
    public EditStory(@NonNull String businessConnectionId, @NonNull Integer storyId, @NonNull InputStoryContent content, String caption, String parseMode, List<MessageEntity> captionEntities, List<StoryArea> areas) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (storyId == null) {
            throw new NullPointerException("storyId is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.storyId = storyId;
        this.content = content;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
        this.areas = areas;
    }

    @Generated
    public static class EditStoryBuilder {
        @Generated
        private String businessConnectionId;
        @Generated
        private Integer storyId;
        @Generated
        private InputStoryContent content;
        @Generated
        private String caption;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> captionEntities;
        @Generated
        private List<StoryArea> areas;

        @Generated
        EditStoryBuilder() {
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public EditStoryBuilder businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @JsonProperty(value="story_id")
        @Generated
        public EditStoryBuilder storyId(@NonNull Integer storyId) {
            if (storyId == null) {
                throw new NullPointerException("storyId is marked non-null but is null");
            }
            this.storyId = storyId;
            return this;
        }

        @JsonProperty(value="content")
        @Generated
        public EditStoryBuilder content(@NonNull InputStoryContent content) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            return this;
        }

        @JsonProperty(value="caption")
        @Generated
        public EditStoryBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public EditStoryBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        @JsonProperty(value="caption_entities")
        @Generated
        public EditStoryBuilder captionEntities(List<MessageEntity> captionEntities) {
            this.captionEntities = captionEntities;
            return this;
        }

        @JsonProperty(value="areas")
        @Generated
        public EditStoryBuilder areas(List<StoryArea> areas) {
            this.areas = areas;
            return this;
        }

        @Generated
        public EditStory build() {
            return new EditStory(this.businessConnectionId, this.storyId, this.content, this.caption, this.parseMode, this.captionEntities, this.areas);
        }

        @Generated
        public String toString() {
            return "EditStory.EditStoryBuilder(businessConnectionId=" + this.businessConnectionId + ", storyId=" + this.storyId + ", content=" + this.content + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ", areas=" + this.areas + ")";
        }
    }
}

