/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.suggestedpost;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=DeclineSuggestedPostBuilderImpl.class)
public class DeclineSuggestedPost
extends BotApiMethod<Boolean> {
    public static final String PATH = "declineSuggestedPost";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String COMMENT_FIELD = "comment";
    @JsonProperty(value="chat_id")
    @NonNull
    private Integer chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="comment")
    private String comment;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId parameter can't be empty", this);
        }
        if (this.comment != null && this.comment.length() > 128) {
            throw new TelegramApiValidationException("Comment cannot be longer than 128 characters", this);
        }
    }

    @Generated
    protected DeclineSuggestedPost(DeclineSuggestedPostBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.comment = b.comment;
    }

    @Generated
    public static DeclineSuggestedPostBuilder<?, ?> builder() {
        return new DeclineSuggestedPostBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeclineSuggestedPost)) {
            return false;
        }
        DeclineSuggestedPost other = (DeclineSuggestedPost)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$chatId = this.getChatId();
        Integer other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !((Object)this$chatId).equals(other$chatId)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeclineSuggestedPost;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : ((Object)$chatId).hashCode());
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Integer getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull Integer chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="comment")
    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public String toString() {
        return "DeclineSuggestedPost(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", comment=" + this.getComment() + ")";
    }

    @Generated
    protected DeclineSuggestedPost() {
    }

    @Generated
    public DeclineSuggestedPost(@NonNull Integer chatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
    }

    @Generated
    public DeclineSuggestedPost(@NonNull Integer chatId, @NonNull Integer messageId, String comment) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.comment = comment;
    }

    @Generated
    public static abstract class DeclineSuggestedPostBuilder<C extends DeclineSuggestedPost, B extends DeclineSuggestedPostBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<Boolean, C, B> {
        @Generated
        private Integer chatId;
        @Generated
        private Integer messageId;
        @Generated
        private String comment;

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull Integer chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="comment")
        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DeclineSuggestedPost.DeclineSuggestedPostBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", comment=" + this.comment + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class DeclineSuggestedPostBuilderImpl
    extends DeclineSuggestedPostBuilder<DeclineSuggestedPost, DeclineSuggestedPostBuilderImpl> {
        @Generated
        private DeclineSuggestedPostBuilderImpl() {
        }

        @Override
        @Generated
        protected DeclineSuggestedPostBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeclineSuggestedPost build() {
            return new DeclineSuggestedPost(this);
        }
    }
}

