/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=EditMessageMediaBuilderImpl.class)
public class EditMessageMedia
extends PartialBotApiMethod<Serializable> {
    public static final String PATH = "editMessageMedia";
    public static final String CHAT_ID_FIELD = "chat_id";
    public static final String MESSAGE_ID_FIELD = "message_id";
    public static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    public static final String MEDIA_FIELD = "media";
    public static final String REPLY_MARKUP_FIELD = "reply_markup";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="media")
    @NonNull
    private InputMedia media;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="business_connection_id")
    private String businessConnectionId;

    public void setChatId(Long chatId) {
        this.chatId = chatId == null ? null : chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Serializable)result.getResult();
            }
            throw new TelegramApiRequestException("Error editing message text", result);
        }
        catch (IOException e) {
            try {
                ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
                if (result.getOk().booleanValue()) {
                    return (Serializable)result.getResult();
                }
                throw new TelegramApiRequestException("Error editing message text", result);
            }
            catch (IOException e2) {
                throw new TelegramApiRequestException("Unable to deserialize response", e);
            }
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null || this.chatId.isEmpty()) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        this.media.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    @Generated
    protected EditMessageMedia(EditMessageMediaBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        this.messageId = b.messageId;
        this.inlineMessageId = b.inlineMessageId;
        this.media = b.media;
        if (this.media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.replyMarkup = b.replyMarkup;
        this.businessConnectionId = b.businessConnectionId;
    }

    @Generated
    public static EditMessageMediaBuilder<?, ?> builder() {
        return new EditMessageMediaBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageMedia)) {
            return false;
        }
        EditMessageMedia other = (EditMessageMedia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        InputMedia this$media = this.getMedia();
        InputMedia other$media = other.getMedia();
        if (this$media == null ? other$media != null : !((Object)this$media).equals(other$media)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditMessageMedia;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        InputMedia $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : ((Object)$media).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    @Generated
    public InputMedia getMedia() {
        return this.media;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    @Generated
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="media")
    @Generated
    public void setMedia(@NonNull InputMedia media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public String toString() {
        return "EditMessageMedia(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", media=" + this.getMedia() + ", replyMarkup=" + this.getReplyMarkup() + ", businessConnectionId=" + this.getBusinessConnectionId() + ")";
    }

    @Generated
    public EditMessageMedia(@NonNull InputMedia media) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.media = media;
    }

    @Generated
    public EditMessageMedia(String chatId, Integer messageId, String inlineMessageId, @NonNull InputMedia media, InlineKeyboardMarkup replyMarkup, String businessConnectionId) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.media = media;
        this.replyMarkup = replyMarkup;
        this.businessConnectionId = businessConnectionId;
    }

    public static abstract class EditMessageMediaBuilder<C extends EditMessageMedia, B extends EditMessageMediaBuilder<C, B>>
    extends PartialBotApiMethod.PartialBotApiMethodBuilder<Serializable, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageId;
        @Generated
        private String inlineMessageId;
        @Generated
        private InputMedia media;
        @Generated
        private InlineKeyboardMarkup replyMarkup;
        @Generated
        private String businessConnectionId;

        public EditMessageMediaBuilder<C, B> chatId(Long chatId) {
            this.chatId = chatId == null ? null : chatId.toString();
            return this;
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(String chatId) {
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(Integer messageId) {
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="inline_message_id")
        @Generated
        public B inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return (B)this.self();
        }

        @JsonProperty(value="media")
        @Generated
        public B media(@NonNull InputMedia media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EditMessageMedia.EditMessageMediaBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", media=" + this.media + ", replyMarkup=" + this.replyMarkup + ", businessConnectionId=" + this.businessConnectionId + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class EditMessageMediaBuilderImpl
    extends EditMessageMediaBuilder<EditMessageMedia, EditMessageMediaBuilderImpl> {
        @Generated
        private EditMessageMediaBuilderImpl() {
        }

        @Override
        @Generated
        protected EditMessageMediaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EditMessageMedia build() {
            return new EditMessageMedia(this);
        }
    }
}

