/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.location;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LocationAddress
implements BotApiObject,
Validable {
    private static final String COUNTRY_CODE_FIELD = "country_code";
    private static final String STATE_FIELD = "state";
    private static final String CITY_FIELD = "city";
    private static final String STREET_FIELD = "street";
    @JsonProperty(value="country_code")
    @NonNull
    private String countryCode;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="city")
    private String city;
    @JsonProperty(value="street")
    private String street;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.countryCode.isEmpty()) {
            throw new TelegramApiValidationException("Country code parameter can't be empty", this);
        }
        if (this.countryCode.length() != 2) {
            throw new TelegramApiValidationException("Country code must be a two-letter ISO 3166-1 alpha-2 code", this);
        }
    }

    @Generated
    public static LocationAddressBuilder builder() {
        return new LocationAddressBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationAddress)) {
            return false;
        }
        LocationAddress other = (LocationAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        return !(this$street == null ? other$street != null : !this$street.equals(other$street));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocationAddress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="country_code")
    @Generated
    public void setCountryCode(@NonNull String countryCode) {
        if (countryCode == null) {
            throw new NullPointerException("countryCode is marked non-null but is null");
        }
        this.countryCode = countryCode;
    }

    @JsonProperty(value="state")
    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="city")
    @Generated
    public void setCity(String city) {
        this.city = city;
    }

    @JsonProperty(value="street")
    @Generated
    public void setStreet(String street) {
        this.street = street;
    }

    @Generated
    public String toString() {
        return "LocationAddress(countryCode=" + this.getCountryCode() + ", state=" + this.getState() + ", city=" + this.getCity() + ", street=" + this.getStreet() + ")";
    }

    @Generated
    public LocationAddress() {
    }

    @Generated
    public LocationAddress(@NonNull String countryCode) {
        if (countryCode == null) {
            throw new NullPointerException("countryCode is marked non-null but is null");
        }
        this.countryCode = countryCode;
    }

    @Generated
    public LocationAddress(@NonNull String countryCode, String state, String city, String street) {
        if (countryCode == null) {
            throw new NullPointerException("countryCode is marked non-null but is null");
        }
        this.countryCode = countryCode;
        this.state = state;
        this.city = city;
        this.street = street;
    }

    @Generated
    public static class LocationAddressBuilder {
        @Generated
        private String countryCode;
        @Generated
        private String state;
        @Generated
        private String city;
        @Generated
        private String street;

        @Generated
        LocationAddressBuilder() {
        }

        @JsonProperty(value="country_code")
        @Generated
        public LocationAddressBuilder countryCode(@NonNull String countryCode) {
            if (countryCode == null) {
                throw new NullPointerException("countryCode is marked non-null but is null");
            }
            this.countryCode = countryCode;
            return this;
        }

        @JsonProperty(value="state")
        @Generated
        public LocationAddressBuilder state(String state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="city")
        @Generated
        public LocationAddressBuilder city(String city) {
            this.city = city;
            return this;
        }

        @JsonProperty(value="street")
        @Generated
        public LocationAddressBuilder street(String street) {
            this.street = street;
            return this;
        }

        @Generated
        public LocationAddress build() {
            return new LocationAddress(this.countryCode, this.state, this.city, this.street);
        }

        @Generated
        public String toString() {
            return "LocationAddress.LocationAddressBuilder(countryCode=" + this.countryCode + ", state=" + this.state + ", city=" + this.city + ", street=" + this.street + ")";
        }
    }
}

