/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputMediaDocumentBuilderImpl.class)
public class InputMediaDocument
extends InputMedia {
    private static final String TYPE = "document";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String DISABLECONTENTTYPEDETECTION_FIELD = "disable_content_type_detection";
    private InputFile thumbnail;
    @JsonProperty(value="disable_content_type_detection")
    private Boolean disableContentTypeDetection;

    public InputMediaDocument(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaDocument(File mediaFile, String fileName) {
        this.setMedia(mediaFile, fileName);
    }

    public InputMediaDocument(InputStream mediaStream, String fileName) {
        this.setMedia(mediaStream, fileName);
    }

    public InputMediaDocument(@NonNull String media, String caption, String parseMode, List<MessageEntity> captionEntities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, InputFile thumbnail, Boolean disableContentTypeDetection) {
        super(media, caption, parseMode, captionEntities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.thumbnail = thumbnail;
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    @Generated
    protected InputMediaDocument(InputMediaDocumentBuilder<?, ?> b) {
        super(b);
        this.thumbnail = b.thumbnail;
        this.disableContentTypeDetection = b.disableContentTypeDetection;
    }

    @Generated
    public static InputMediaDocumentBuilder<?, ?> builder() {
        return new InputMediaDocumentBuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaDocument)) {
            return false;
        }
        InputMediaDocument other = (InputMediaDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$disableContentTypeDetection = this.getDisableContentTypeDetection();
        Boolean other$disableContentTypeDetection = other.getDisableContentTypeDetection();
        if (this$disableContentTypeDetection == null ? other$disableContentTypeDetection != null : !((Object)this$disableContentTypeDetection).equals(other$disableContentTypeDetection)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaDocument;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $disableContentTypeDetection = this.getDisableContentTypeDetection();
        result = result * 59 + ($disableContentTypeDetection == null ? 43 : ((Object)$disableContentTypeDetection).hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    @Generated
    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public Boolean getDisableContentTypeDetection() {
        return this.disableContentTypeDetection;
    }

    @Generated
    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @JsonProperty(value="disable_content_type_detection")
    @Generated
    public void setDisableContentTypeDetection(Boolean disableContentTypeDetection) {
        this.disableContentTypeDetection = disableContentTypeDetection;
    }

    @Override
    @Generated
    public String toString() {
        return "InputMediaDocument(thumbnail=" + this.getThumbnail() + ", disableContentTypeDetection=" + this.getDisableContentTypeDetection() + ")";
    }

    @Generated
    public static abstract class InputMediaDocumentBuilder<C extends InputMediaDocument, B extends InputMediaDocumentBuilder<C, B>>
    extends InputMedia.InputMediaBuilder<C, B> {
        @Generated
        private InputFile thumbnail;
        @Generated
        private Boolean disableContentTypeDetection;

        @Generated
        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="disable_content_type_detection")
        @Generated
        public B disableContentTypeDetection(Boolean disableContentTypeDetection) {
            this.disableContentTypeDetection = disableContentTypeDetection;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InputMediaDocument.InputMediaDocumentBuilder(super=" + super.toString() + ", thumbnail=" + this.thumbnail + ", disableContentTypeDetection=" + this.disableContentTypeDetection + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputMediaDocumentBuilderImpl
    extends InputMediaDocumentBuilder<InputMediaDocument, InputMediaDocumentBuilderImpl> {
        @Generated
        private InputMediaDocumentBuilderImpl() {
        }

        @Override
        @Generated
        protected InputMediaDocumentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputMediaDocument build() {
            return new InputMediaDocument(this);
        }
    }
}

