/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.starter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.InitializingBean;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.WebhookBot;
import org.telegram.telegrambots.meta.logging.BotLogger;
import org.telegram.telegrambots.starter.AfterBotRegistration;

public class TelegramBotInitializer
implements InitializingBean {
    private final TelegramBotsApi telegramBotsApi;
    private final List<LongPollingBot> longPollingBots;
    private final List<WebhookBot> webHookBots;

    public TelegramBotInitializer(TelegramBotsApi telegramBotsApi, List<LongPollingBot> longPollingBots, List<WebhookBot> webHookBots) {
        Objects.requireNonNull(telegramBotsApi);
        Objects.requireNonNull(longPollingBots);
        Objects.requireNonNull(webHookBots);
        this.telegramBotsApi = telegramBotsApi;
        this.longPollingBots = longPollingBots;
        this.webHookBots = webHookBots;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            for (LongPollingBot longPollingBot : this.longPollingBots) {
                BotSession session = this.telegramBotsApi.registerBot(longPollingBot);
                this.handleAfterRegistrationHook(longPollingBot, session);
            }
            for (WebhookBot webhookBot : this.webHookBots) {
                this.telegramBotsApi.registerBot(webhookBot);
            }
        }
        catch (TelegramApiException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleAnnotatedMethod(Object bot, Method method, BotSession session) {
        try {
            if (method.getParameterCount() > 1) {
                BotLogger.warn((String)this.getClass().getSimpleName(), (String)String.format("Method %s of Type %s has too many parameters", method.getName(), method.getDeclaringClass().getCanonicalName()));
                return;
            }
            if (method.getParameterCount() == 0) {
                method.invoke(bot, new Object[0]);
                return;
            }
            if (method.getParameterTypes()[0].equals(BotSession.class)) {
                method.invoke(bot, session);
                return;
            }
            BotLogger.warn((String)this.getClass().getSimpleName(), (String)String.format("Method %s of Type %s has invalid parameter type", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BotLogger.error((String)this.getClass().getSimpleName(), (String)String.format("Couldn't invoke Method %s of Type %s", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
    }

    private void handleAfterRegistrationHook(Object bot, BotSession botSession) {
        Stream.of(bot.getClass().getMethods()).filter(method -> method.getAnnotation(AfterBotRegistration.class) != null).forEach(method -> this.handleAnnotatedMethod(bot, (Method)method, botSession));
    }
}

