/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.webhook.starter;

import java.util.function.Function;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;

public class SpringTelegramWebhookBot {
    private final String botPath;
    private final Function<Update, BotApiMethod<?>> updateHandler;
    private final Runnable setWebhook;
    private final Runnable deleteWebhook;

    public void runDeleteWebhook() {
        if (this.deleteWebhook != null) {
            this.deleteWebhook.run();
        }
    }

    public void runSetWebhook() {
        if (this.setWebhook != null) {
            this.setWebhook.run();
        }
    }

    public BotApiMethod<?> consumeUpdate(Update update) {
        if (this.updateHandler != null) {
            return this.updateHandler.apply(update);
        }
        return null;
    }

    public static SpringTelegramWebhookBotBuilder builder() {
        return new SpringTelegramWebhookBotBuilder();
    }

    public String getBotPath() {
        return this.botPath;
    }

    public Function<Update, BotApiMethod<?>> getUpdateHandler() {
        return this.updateHandler;
    }

    public Runnable getSetWebhook() {
        return this.setWebhook;
    }

    public Runnable getDeleteWebhook() {
        return this.deleteWebhook;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringTelegramWebhookBot)) {
            return false;
        }
        SpringTelegramWebhookBot other = (SpringTelegramWebhookBot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$botPath = this.getBotPath();
        String other$botPath = other.getBotPath();
        if (this$botPath == null ? other$botPath != null : !this$botPath.equals(other$botPath)) {
            return false;
        }
        Function<Update, BotApiMethod<?>> this$updateHandler = this.getUpdateHandler();
        Function<Update, BotApiMethod<?>> other$updateHandler = other.getUpdateHandler();
        if (this$updateHandler == null ? other$updateHandler != null : !this$updateHandler.equals(other$updateHandler)) {
            return false;
        }
        Runnable this$setWebhook = this.getSetWebhook();
        Runnable other$setWebhook = other.getSetWebhook();
        if (this$setWebhook == null ? other$setWebhook != null : !this$setWebhook.equals(other$setWebhook)) {
            return false;
        }
        Runnable this$deleteWebhook = this.getDeleteWebhook();
        Runnable other$deleteWebhook = other.getDeleteWebhook();
        return !(this$deleteWebhook == null ? other$deleteWebhook != null : !this$deleteWebhook.equals(other$deleteWebhook));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringTelegramWebhookBot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $botPath = this.getBotPath();
        result = result * 59 + ($botPath == null ? 43 : $botPath.hashCode());
        Function<Update, BotApiMethod<?>> $updateHandler = this.getUpdateHandler();
        result = result * 59 + ($updateHandler == null ? 43 : $updateHandler.hashCode());
        Runnable $setWebhook = this.getSetWebhook();
        result = result * 59 + ($setWebhook == null ? 43 : $setWebhook.hashCode());
        Runnable $deleteWebhook = this.getDeleteWebhook();
        result = result * 59 + ($deleteWebhook == null ? 43 : $deleteWebhook.hashCode());
        return result;
    }

    public String toString() {
        return "SpringTelegramWebhookBot(botPath=" + this.getBotPath() + ", updateHandler=" + this.getUpdateHandler() + ", setWebhook=" + this.getSetWebhook() + ", deleteWebhook=" + this.getDeleteWebhook() + ")";
    }

    public SpringTelegramWebhookBot(String botPath, Function<Update, BotApiMethod<?>> updateHandler, Runnable setWebhook, Runnable deleteWebhook) {
        this.botPath = botPath;
        this.updateHandler = updateHandler;
        this.setWebhook = setWebhook;
        this.deleteWebhook = deleteWebhook;
    }

    public static class SpringTelegramWebhookBotBuilder {
        private String botPath;
        private Function<Update, BotApiMethod<?>> updateHandler;
        private Runnable setWebhook;
        private Runnable deleteWebhook;

        SpringTelegramWebhookBotBuilder() {
        }

        public SpringTelegramWebhookBotBuilder botPath(String botPath) {
            this.botPath = botPath;
            return this;
        }

        public SpringTelegramWebhookBotBuilder updateHandler(Function<Update, BotApiMethod<?>> updateHandler) {
            this.updateHandler = updateHandler;
            return this;
        }

        public SpringTelegramWebhookBotBuilder setWebhook(Runnable setWebhook) {
            this.setWebhook = setWebhook;
            return this;
        }

        public SpringTelegramWebhookBotBuilder deleteWebhook(Runnable deleteWebhook) {
            this.deleteWebhook = deleteWebhook;
            return this;
        }

        public SpringTelegramWebhookBot build() {
            return new SpringTelegramWebhookBot(this.botPath, this.updateHandler, this.setWebhook, this.deleteWebhook);
        }

        public String toString() {
            return "SpringTelegramWebhookBot.SpringTelegramWebhookBotBuilder(botPath=" + this.botPath + ", updateHandler=" + this.updateHandler + ", setWebhook=" + this.setWebhook + ", deleteWebhook=" + this.deleteWebhook + ")";
        }
    }
}

