/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.webhook.starter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.webhook.starter.AfterBotRegistration;
import org.telegram.telegrambots.webhook.starter.SpringTelegramWebhookBot;
import org.telegram.telegrambots.webhook.starter.TelegramBotsSpringWebhookApplication;

public class TelegramBotInitializer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TelegramBotInitializer.class);
    private final TelegramBotsSpringWebhookApplication telegramBotsApplication;
    private final List<SpringTelegramWebhookBot> webhookBots;

    public TelegramBotInitializer(TelegramBotsSpringWebhookApplication telegramBotsApplication, List<SpringTelegramWebhookBot> webhookBots) {
        Objects.requireNonNull(telegramBotsApplication);
        Objects.requireNonNull(webhookBots);
        this.telegramBotsApplication = telegramBotsApplication;
        this.webhookBots = webhookBots;
    }

    public void afterPropertiesSet() {
        try {
            for (SpringTelegramWebhookBot webhookBot : this.webhookBots) {
                this.telegramBotsApplication.registerBot(webhookBot);
                this.handleAfterRegistrationHook(webhookBot);
            }
        }
        catch (TelegramApiException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleAfterRegistrationHook(Object bot) {
        Stream.of(bot.getClass().getMethods()).filter(method -> method.getAnnotation(AfterBotRegistration.class) != null).forEach(method -> this.handleAnnotatedMethod(bot, (Method)method));
    }

    private void handleAnnotatedMethod(Object bot, Method method) {
        try {
            if (method.getParameterCount() > 1) {
                log.warn(String.format("Method %s of Type %s has too many parameters", method.getName(), method.getDeclaringClass().getCanonicalName()));
                return;
            }
            if (method.getParameterCount() == 0) {
                method.invoke(bot, new Object[0]);
                return;
            }
            log.warn(String.format("Method %s of Type %s has invalid parameter type", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error(String.format("Couldn't invoke Method %s of Type %s", method.getName(), method.getDeclaringClass().getCanonicalName()));
        }
    }
}

