/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.webhook.starter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpServerErrorException;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.webhook.starter.SpringTelegramWebhookBot;

@RestController
public class TelegramBotsSpringWebhookApplication
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TelegramBotsSpringWebhookApplication.class);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, SpringTelegramWebhookBot> registeredBots = new ConcurrentHashMap();

    public TelegramBotsSpringWebhookApplication() throws TelegramApiException {
        this.isRunning.set(true);
    }

    public void registerBot(String botPath, Function<Update, BotApiMethod<?>> updateHandler, Runnable setWebhook, Runnable deleteWebhook) throws TelegramApiException {
        this.registerBot(SpringTelegramWebhookBot.builder().botPath(botPath).updateHandler(updateHandler).setWebhook(setWebhook).deleteWebhook(deleteWebhook).build());
    }

    public void unregisterBot(String botPath) throws TelegramApiException {
        if (this.isRunning()) {
            SpringTelegramWebhookBot removedBot = this.registeredBots.remove(botPath);
            if (removedBot != null) {
                removedBot.runDeleteWebhook();
            }
        } else {
            throw new TelegramApiException("Server is not running");
        }
    }

    public void registerBot(SpringTelegramWebhookBot telegramWebhookBot) throws TelegramApiException {
        if (!this.isRunning()) {
            throw new TelegramApiException("Server is not running");
        }
        this.registeredBots.put(telegramWebhookBot.getBotPath(), telegramWebhookBot);
        telegramWebhookBot.runSetWebhook();
    }

    public void unregisterBot(SpringTelegramWebhookBot telegramWebhookBot) throws TelegramApiException {
        this.unregisterBot(telegramWebhookBot.getBotPath());
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void start() throws TelegramApiException {
        if (this.isRunning.get()) {
            throw new TelegramApiException("Server already running");
        }
        for (Map.Entry<String, SpringTelegramWebhookBot> bot : this.registeredBots.entrySet()) {
            bot.getValue().runSetWebhook();
        }
        this.isRunning.set(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() throws TelegramApiException {
        if (!this.isRunning.get()) throw new TelegramApiException("Server is not running");
        if (!this.isRunning.get()) throw new TelegramApiException("Server is not running");
        for (Map.Entry<String, SpringTelegramWebhookBot> bot : this.registeredBots.entrySet()) {
            bot.getValue().runDeleteWebhook();
        }
        this.isRunning.set(false);
    }

    @PostMapping(value={"/{botPath}"}, produces={"application/json"}, consumes={"application/json"})
    public BotApiMethod<?> receiveUpdate(@PathVariable(value="botPath") String botPath, @RequestBody Update update) {
        if (!this.isRunning.get()) {
            throw new HttpServerErrorException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "Service is not running");
        }
        SpringTelegramWebhookBot responsibleBot = this.registeredBots.get(botPath);
        if (responsibleBot != null) {
            return responsibleBot.consumeUpdate(update);
        }
        return null;
    }

    @Override
    public void close() throws TelegramApiException {
        this.stop();
    }
}

