/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Solves systems of linear equations.
 * <p>
 * `Matrix` is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
 * form square matrices. `Rhs` is a tensor of shape `[..., M, K]`. The `output` is
 * a tensor shape `[..., M, K]`.  If `adjoint` is `False` then each output matrix
 * satisfies `matrix[..., :, :] * output[..., :, :] = rhs[..., :, :]`.
 * If `adjoint` is `True` then each output matrix satisfies
 * `adjoint(matrix[..., :, :]) * output[..., :, :] = rhs[..., :, :]`.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class MatrixSolve<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.MatrixSolve}
   */
  public static class Options {
    
    /**
     * @param adjoint Boolean indicating whether to solve with `matrix` or its (block-wise)
     * adjoint.
     */
    public Options adjoint(Boolean adjoint) {
      this.adjoint = adjoint;
      return this;
    }
    
    private Boolean adjoint;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new MatrixSolve operation to the graph.
   * 
   * @param scope current graph scope
   * @param matrix Shape is `[..., M, M]`.
   * @param rhs Shape is `[..., M, K]`.
   * @param options carries optional attributes values
   * @return a new instance of MatrixSolve
   */
  public static <T> MatrixSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("MatrixSolve", scope.makeOpName("MatrixSolve"));
    opBuilder.addInput(matrix.asOutput());
    opBuilder.addInput(rhs.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.adjoint != null) {
          opBuilder.setAttr("adjoint", opts.adjoint);
        }
      }
    }
    return new MatrixSolve<T>(opBuilder.build());
  }
  
  /**
   * @param adjoint Boolean indicating whether to solve with `matrix` or its (block-wise)
   * adjoint.
   */
  public static Options adjoint(Boolean adjoint) {
    return new Options().adjoint(adjoint);
  }
  
  /**
   * Shape is `[..., M, K]`.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private MatrixSolve(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
